/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector.github.internal.graphql;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.Mutator;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.openhft.chronicle.releasenotes.connector.github.internal.graphql.type.CustomType;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GetTagsQuery
implements Query<Data, Optional<Data>, Variables> {
    public static final String OPERATION_ID = "cbadb44802491bf8b4b7edb98132d772bfafb0fa110e876903c4316bafb9b08f";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query GetTags($owner: String!, $repository: String!, $amount: Int = 100) {\n  repository(owner: $owner, name: $repository) {\n    __typename\n    refs(refPrefix: \"refs/tags/\", first: $amount, orderBy: {field: TAG_COMMIT_DATE, direction: DESC}) {\n      __typename\n      edges {\n        __typename\n        node {\n          __typename\n          name\n          target {\n            __typename\n            ... on Commit {\n              oid\n            }\n            ... on Tag {\n              target {\n                __typename\n                ... on Commit {\n                  oid\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "GetTags";
        }
    };
    private final Variables variables;

    public GetTagsQuery(@NotNull String owner, @NotNull String repository, @NotNull Input<Integer> amount) {
        Utils.checkNotNull((Object)owner, (Object)"owner == null");
        Utils.checkNotNull((Object)repository, (Object)"repository == null");
        Utils.checkNotNull(amount, (Object)"amount == null");
        this.variables = new Variables(owner, repository, amount);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Optional<Data> wrapData(Data data) {
        return Optional.ofNullable(data);
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Optional<Data>> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Optional<Data>> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Optional<Data>> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Optional<Data>> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static class AsGitObject1
    implements Target {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsGitObject1(@NotNull String __typename) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
        }

        @Override
        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsGitObject1{__typename=" + this.__typename + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsGitObject1) {
                AsGitObject1 that = (AsGitObject1)o;
                return this.__typename.equals(that.__typename);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.__typename.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public AsGitObject1 build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                return new AsGitObject1(this.__typename);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsGitObject1> {
            public AsGitObject1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                return new AsGitObject1(__typename);
            }
        }
    }

    public static class AsGitObject
    implements Target1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsGitObject(@NotNull String __typename) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
        }

        @Override
        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsGitObject{__typename=" + this.__typename + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsGitObject) {
                AsGitObject that = (AsGitObject)o;
                return this.__typename.equals(that.__typename);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.__typename.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public AsGitObject build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                return new AsGitObject(this.__typename);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsGitObject> {
            public AsGitObject map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                return new AsGitObject(__typename);
            }
        }
    }

    public static class AsCommit1
    implements Target1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"oid", (String)"oid", null, (boolean)false, (ScalarType)CustomType.GITOBJECTID, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object oid;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsCommit1(@NotNull String __typename, @NotNull Object oid) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.oid = Utils.checkNotNull((Object)oid, (Object)"oid == null");
        }

        @Override
        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        @NotNull
        public Object getOid() {
            return this.oid;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], oid);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsCommit1{__typename=" + this.__typename + ", oid=" + this.oid + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsCommit1) {
                AsCommit1 that = (AsCommit1)o;
                return this.__typename.equals(that.__typename) && this.oid.equals(that.oid);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.oid.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            builder.oid = this.oid;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;
            @NotNull
            private Object oid;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public Builder oid(@NotNull Object oid) {
                this.oid = oid;
                return this;
            }

            public AsCommit1 build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                Utils.checkNotNull((Object)this.oid, (Object)"oid == null");
                return new AsCommit1(this.__typename, this.oid);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsCommit1> {
            public AsCommit1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object oid = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                return new AsCommit1(__typename, oid);
            }
        }
    }

    public static interface Target1 {
        @NotNull
        public String get__typename();

        public ResponseFieldMarshaller marshaller();

        default public <T> T visit(Visitor<T> visitor) {
            if (this instanceof AsCommit1) {
                return visitor.visit((AsCommit1)this);
            }
            if (this instanceof AsGitObject) {
                return visitor.visit((AsGitObject)this);
            }
            return visitor.visitDefault(this);
        }

        public static interface Visitor<T> {
            public T visitDefault(@NotNull Target1 var1);

            public T visit(@NotNull AsCommit1 var1);

            public T visit(@NotNull AsGitObject var1);
        }

        public static final class Mapper
        implements ResponseFieldMapper<Target1> {
            static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"Commit"})))};
            final AsCommit1.Mapper asCommit1FieldMapper = new AsCommit1.Mapper();
            final AsGitObject.Mapper asGitObjectFieldMapper = new AsGitObject.Mapper();

            public Target1 map(ResponseReader reader) {
                AsCommit1 asCommit = (AsCommit1)reader.readFragment($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsCommit1>(){

                    public AsCommit1 read(ResponseReader reader) {
                        return asCommit1FieldMapper.map(reader);
                    }
                });
                if (asCommit != null) {
                    return asCommit;
                }
                return this.asGitObjectFieldMapper.map(reader);
            }
        }
    }

    public static class AsTag
    implements Target {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"target", (String)"target", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Target1 target;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsTag(@NotNull String __typename, @NotNull Target1 target) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.target = (Target1)Utils.checkNotNull((Object)target, (Object)"target == null");
        }

        @Override
        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        @NotNull
        public Target1 getTarget() {
            return this.target;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], target.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsTag{__typename=" + this.__typename + ", target=" + this.target + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsTag) {
                AsTag that = (AsTag)o;
                return this.__typename.equals(that.__typename) && this.target.equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.target.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            builder.target = this.target;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;
            @NotNull
            private Target1 target;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public Builder target(@NotNull Target1 target) {
                this.target = target;
                return this;
            }

            public AsTag build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                Utils.checkNotNull((Object)this.target, (Object)"target == null");
                return new AsTag(this.__typename, this.target);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsTag> {
            final Target1.Mapper target1FieldMapper = new Target1.Mapper();

            public AsTag map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Target1 target = (Target1)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Target1>(){

                    public Target1 read(ResponseReader reader) {
                        return target1FieldMapper.map(reader);
                    }
                });
                return new AsTag(__typename, target);
            }
        }
    }

    public static class AsCommit
    implements Target {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"oid", (String)"oid", null, (boolean)false, (ScalarType)CustomType.GITOBJECTID, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object oid;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsCommit(@NotNull String __typename, @NotNull Object oid) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.oid = Utils.checkNotNull((Object)oid, (Object)"oid == null");
        }

        @Override
        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        @NotNull
        public Object getOid() {
            return this.oid;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], oid);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsCommit{__typename=" + this.__typename + ", oid=" + this.oid + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsCommit) {
                AsCommit that = (AsCommit)o;
                return this.__typename.equals(that.__typename) && this.oid.equals(that.oid);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.oid.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            builder.oid = this.oid;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;
            @NotNull
            private Object oid;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public Builder oid(@NotNull Object oid) {
                this.oid = oid;
                return this;
            }

            public AsCommit build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                Utils.checkNotNull((Object)this.oid, (Object)"oid == null");
                return new AsCommit(this.__typename, this.oid);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsCommit> {
            public AsCommit map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object oid = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                return new AsCommit(__typename, oid);
            }
        }
    }

    public static interface Target {
        @NotNull
        public String get__typename();

        public ResponseFieldMarshaller marshaller();

        default public <T> T visit(Visitor<T> visitor) {
            if (this instanceof AsCommit) {
                return visitor.visit((AsCommit)this);
            }
            if (this instanceof AsTag) {
                return visitor.visit((AsTag)this);
            }
            if (this instanceof AsGitObject1) {
                return visitor.visit((AsGitObject1)this);
            }
            return visitor.visitDefault(this);
        }

        public static interface Visitor<T> {
            public T visitDefault(@NotNull Target var1);

            public T visit(@NotNull AsCommit var1);

            public T visit(@NotNull AsTag var1);

            public T visit(@NotNull AsGitObject1 var1);
        }

        public static final class Mapper
        implements ResponseFieldMapper<Target> {
            static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"Commit"}))), ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"Tag"})))};
            final AsCommit.Mapper asCommitFieldMapper = new AsCommit.Mapper();
            final AsTag.Mapper asTagFieldMapper = new AsTag.Mapper();
            final AsGitObject1.Mapper asGitObject1FieldMapper = new AsGitObject1.Mapper();

            public Target map(ResponseReader reader) {
                AsCommit asCommit = (AsCommit)reader.readFragment($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsCommit>(){

                    public AsCommit read(ResponseReader reader) {
                        return asCommitFieldMapper.map(reader);
                    }
                });
                if (asCommit != null) {
                    return asCommit;
                }
                AsTag asTag = (AsTag)reader.readFragment($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsTag>(){

                    public AsTag read(ResponseReader reader) {
                        return asTagFieldMapper.map(reader);
                    }
                });
                if (asTag != null) {
                    return asTag;
                }
                return this.asGitObject1FieldMapper.map(reader);
            }
        }
    }

    public static class Node {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"name", (String)"name", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"target", (String)"target", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String name;
        final Optional<Target> target;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Node(@NotNull String __typename, @NotNull String name, @Nullable Target target) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.name = (String)Utils.checkNotNull((Object)name, (Object)"name == null");
            this.target = Optional.ofNullable(target);
        }

        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public Optional<Target> getTarget() {
            return this.target;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], name);
                    writer.writeObject($responseFields[2], target.isPresent() ? target.get().marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Node{__typename=" + this.__typename + ", name=" + this.name + ", target=" + this.target + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Node) {
                Node that = (Node)o;
                return this.__typename.equals(that.__typename) && this.name.equals(that.name) && this.target.equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.name.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.target.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            builder.name = this.name;
            builder.target = this.target.isPresent() ? this.target.get() : null;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;
            @NotNull
            private String name;
            @Nullable
            private Target target;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public Builder name(@NotNull String name) {
                this.name = name;
                return this;
            }

            public Builder target(@Nullable Target target) {
                this.target = target;
                return this;
            }

            public Node build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                Utils.checkNotNull((Object)this.name, (Object)"name == null");
                return new Node(this.__typename, this.name, this.target);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<Node> {
            final Target.Mapper targetFieldMapper = new Target.Mapper();

            public Node map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String name = reader.readString($responseFields[1]);
                Target target = (Target)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Target>(){

                    public Target read(ResponseReader reader) {
                        return targetFieldMapper.map(reader);
                    }
                });
                return new Node(__typename, name, target);
            }
        }
    }

    public static class Edge {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"node", (String)"node", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        final Optional<Node> node;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Edge(@NotNull String __typename, @Nullable Node node) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.node = Optional.ofNullable(node);
        }

        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        public Optional<Node> getNode() {
            return this.node;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], node.isPresent() ? node.get().marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Edge{__typename=" + this.__typename + ", node=" + this.node + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Edge) {
                Edge that = (Edge)o;
                return this.__typename.equals(that.__typename) && this.node.equals(that.node);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.node.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            builder.node = this.node.isPresent() ? this.node.get() : null;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;
            @Nullable
            private Node node;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public Builder node(@Nullable Node node) {
                this.node = node;
                return this;
            }

            public Builder node(@NotNull Mutator<Node.Builder> mutator) {
                Utils.checkNotNull(mutator, (Object)"mutator == null");
                Node.Builder builder = this.node != null ? this.node.toBuilder() : Node.builder();
                mutator.accept((Object)builder);
                this.node = builder.build();
                return this;
            }

            public Edge build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                return new Edge(this.__typename, this.node);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<Edge> {
            final Node.Mapper nodeFieldMapper = new Node.Mapper();

            public Edge map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Node node = (Node)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Node>(){

                    public Node read(ResponseReader reader) {
                        return nodeFieldMapper.map(reader);
                    }
                });
                return new Edge(__typename, node);
            }
        }
    }

    public static class Refs {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"edges", (String)"edges", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        final Optional<List<Edge>> edges;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Refs(@NotNull String __typename, @Nullable List<Edge> edges) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.edges = Optional.ofNullable(edges);
        }

        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        public Optional<List<Edge>> getEdges() {
            return this.edges;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], edges.isPresent() ? edges.get() : null, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Edge)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Refs{__typename=" + this.__typename + ", edges=" + this.edges + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Refs) {
                Refs that = (Refs)o;
                return this.__typename.equals(that.__typename) && this.edges.equals(that.edges);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.edges.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            builder.edges = this.edges.isPresent() ? this.edges.get() : null;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;
            @Nullable
            private List<Edge> edges;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public Builder edges(@Nullable List<Edge> edges) {
                this.edges = edges;
                return this;
            }

            public Builder edges(@NotNull Mutator<List<Edge.Builder>> mutator) {
                Utils.checkNotNull(mutator, (Object)"mutator == null");
                ArrayList<Edge.Builder> builders = new ArrayList<Edge.Builder>();
                if (this.edges != null) {
                    for (Edge item : this.edges) {
                        builders.add(item != null ? item.toBuilder() : null);
                    }
                }
                mutator.accept(builders);
                ArrayList<Edge> edges = new ArrayList<Edge>();
                for (Edge.Builder item : builders) {
                    edges.add(item != null ? item.build() : null);
                }
                this.edges = edges;
                return this;
            }

            public Refs build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                return new Refs(this.__typename, this.edges);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<Refs> {
            final Edge.Mapper edgeFieldMapper = new Edge.Mapper();

            public Refs map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List edges = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Edge>(){

                    public Edge read(ResponseReader.ListItemReader listItemReader) {
                        return (Edge)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Edge>(){

                            public Edge read(ResponseReader reader) {
                                return edgeFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new Refs(__typename, edges);
            }
        }
    }

    public static class Repository {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"refs", (String)"refs", (Map)new UnmodifiableMapBuilder(3).put((Object)"refPrefix", (Object)"refs/tags/").put((Object)"first", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"amount").build()).put((Object)"orderBy", (Object)new UnmodifiableMapBuilder(2).put((Object)"field", (Object)"TAG_COMMIT_DATE").put((Object)"direction", (Object)"DESC").build()).build(), (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        final Optional<Refs> refs;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Repository(@NotNull String __typename, @Nullable Refs refs) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.refs = Optional.ofNullable(refs);
        }

        @NotNull
        public String get__typename() {
            return this.__typename;
        }

        public Optional<Refs> getRefs() {
            return this.refs;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], refs.isPresent() ? refs.get().marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Repository{__typename=" + this.__typename + ", refs=" + this.refs + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Repository) {
                Repository that = (Repository)o;
                return this.__typename.equals(that.__typename) && this.refs.equals(that.refs);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.refs.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.__typename = this.__typename;
            builder.refs = this.refs.isPresent() ? this.refs.get() : null;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @NotNull
            private String __typename;
            @Nullable
            private Refs refs;

            Builder() {
            }

            public Builder __typename(@NotNull String __typename) {
                this.__typename = __typename;
                return this;
            }

            public Builder refs(@Nullable Refs refs) {
                this.refs = refs;
                return this;
            }

            public Builder refs(@NotNull Mutator<Refs.Builder> mutator) {
                Utils.checkNotNull(mutator, (Object)"mutator == null");
                Refs.Builder builder = this.refs != null ? this.refs.toBuilder() : Refs.builder();
                mutator.accept((Object)builder);
                this.refs = builder.build();
                return this;
            }

            public Repository build() {
                Utils.checkNotNull((Object)this.__typename, (Object)"__typename == null");
                return new Repository(this.__typename, this.refs);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<Repository> {
            final Refs.Mapper refsFieldMapper = new Refs.Mapper();

            public Repository map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Refs refs = (Refs)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Refs>(){

                    public Refs read(ResponseReader reader) {
                        return refsFieldMapper.map(reader);
                    }
                });
                return new Repository(__typename, refs);
            }
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"repository", (String)"repository", (Map)new UnmodifiableMapBuilder(2).put((Object)"owner", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"owner").build()).put((Object)"name", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"repository").build()).build(), (boolean)true, Collections.emptyList())};
        final Optional<Repository> repository;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable Repository repository) {
            this.repository = Optional.ofNullable(repository);
        }

        public Optional<Repository> getRepository() {
            return this.repository;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], repository.isPresent() ? repository.get().marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{repository=" + this.repository + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.repository.equals(that.repository);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.repository.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.repository = this.repository.isPresent() ? this.repository.get() : null;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Repository repository;

            Builder() {
            }

            public Builder repository(@Nullable Repository repository) {
                this.repository = repository;
                return this;
            }

            public Builder repository(@NotNull Mutator<Repository.Builder> mutator) {
                Utils.checkNotNull(mutator, (Object)"mutator == null");
                Repository.Builder builder = this.repository != null ? this.repository.toBuilder() : Repository.builder();
                mutator.accept((Object)builder);
                this.repository = builder.build();
                return this;
            }

            public Data build() {
                return new Data(this.repository);
            }
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Repository.Mapper repositoryFieldMapper = new Repository.Mapper();

            public Data map(ResponseReader reader) {
                Repository repository = (Repository)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Repository>(){

                    public Repository read(ResponseReader reader) {
                        return repositoryFieldMapper.map(reader);
                    }
                });
                return new Data(repository);
            }
        }
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String owner;
        @NotNull
        private final String repository;
        private final Input<Integer> amount;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String owner, @NotNull String repository, Input<Integer> amount) {
            this.owner = owner;
            this.repository = repository;
            this.amount = amount;
            this.valueMap.put("owner", owner);
            this.valueMap.put("repository", repository);
            if (amount.defined) {
                this.valueMap.put("amount", amount.value);
            }
        }

        @NotNull
        public String owner() {
            return this.owner;
        }

        @NotNull
        public String repository() {
            return this.repository;
        }

        public Input<Integer> amount() {
            return this.amount;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeString("owner", owner);
                    writer.writeString("repository", repository);
                    if (((Variables)this).amount.defined) {
                        writer.writeInt("amount", (Integer)((Variables)this).amount.value);
                    }
                }
            };
        }
    }

    public static final class Builder {
        @NotNull
        private String owner;
        @NotNull
        private String repository;
        private Input<Integer> amount = Input.absent();

        Builder() {
        }

        public Builder owner(@NotNull String owner) {
            this.owner = owner;
            return this;
        }

        public Builder repository(@NotNull String repository) {
            this.repository = repository;
            return this;
        }

        public Builder amount(@Nullable Integer amount) {
            this.amount = Input.fromNullable((Object)amount);
            return this;
        }

        public Builder amountInput(@NotNull Input<Integer> amount) {
            this.amount = (Input)Utils.checkNotNull(amount, (Object)"amount == null");
            return this;
        }

        public GetTagsQuery build() {
            Utils.checkNotNull((Object)this.owner, (Object)"owner == null");
            Utils.checkNotNull((Object)this.repository, (Object)"repository == null");
            return new GetTagsQuery(this.owner, this.repository, this.amount);
        }
    }
}

