/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector.github.graphql;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.openhft.chronicle.releasenotes.connector.github.graphql.model.Tag;
import net.openhft.chronicle.releasenotes.connector.github.internal.graphql.GetTagsQuery;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

public class GitHubGraphQLClient
implements AutoCloseable {
    private static final String GITHUB_GRAPHQL_URL = "https://api.github.com/graphql";
    private final OkHttpClient okHttpClient;
    private final ApolloClient apolloClient;
    private boolean closed = false;

    public GitHubGraphQLClient(String token) {
        Objects.requireNonNull(token);
        this.okHttpClient = new OkHttpClient.Builder().addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", "Bearer " + token).build())).build();
        this.apolloClient = ApolloClient.builder().serverUrl(GITHUB_GRAPHQL_URL).okHttpClient(this.okHttpClient).build();
    }

    public List<Tag> getTags(String owner, String repository) {
        if (this.closed) {
            throw new RuntimeException("Cannot execute request from closed client");
        }
        Optional optionalData = (Optional)this.callSync((ApolloCall)this.apolloClient.query((Query)new GetTagsQuery(owner, repository, (Input<Integer>)Input.absent()))).getData();
        if (!optionalData.isPresent()) {
            throw new RuntimeException("Failed to fetch tag data for repository '" + owner + "/" + repository + "'");
        }
        GetTagsQuery.Data data = (GetTagsQuery.Data)optionalData.get();
        if (!data.getRepository().isPresent()) {
            throw new RuntimeException("Failed to find repository '" + owner + "/" + repository + "'");
        }
        GetTagsQuery.Repository repo = data.getRepository().get();
        if (!repo.getRefs().isPresent()) {
            throw new RuntimeException("Failed to find tag refs for repository '" + owner + "/" + repository + "'");
        }
        GetTagsQuery.Refs refs = repo.getRefs().get();
        if (!refs.getEdges().isPresent()) {
            throw new RuntimeException("Failed to find tag ref edges for repository '" + owner + "/" + repository + "'");
        }
        List nodes = refs.getEdges().get().stream().filter(edge -> edge.getNode().isPresent()).map(edge -> edge.getNode().get()).collect(Collectors.toList());
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (GetTagsQuery.Node node : nodes) {
            GetTagsQuery.Target nodeTarget;
            if (!node.getTarget().isPresent() || !((nodeTarget = node.getTarget().get()) instanceof GetTagsQuery.AsCommit) && !(nodeTarget instanceof GetTagsQuery.AsTag)) continue;
            String tagName = null;
            String commitSHA1 = null;
            if (nodeTarget instanceof GetTagsQuery.AsCommit) {
                GetTagsQuery.AsCommit commitTarget = (GetTagsQuery.AsCommit)nodeTarget;
                if (!(commitTarget.getOid() instanceof String)) continue;
                tagName = node.getName();
                commitSHA1 = (String)commitTarget.getOid();
            }
            if (nodeTarget instanceof GetTagsQuery.AsTag) {
                GetTagsQuery.AsCommit1 commitTarget;
                GetTagsQuery.AsTag tagTarget = (GetTagsQuery.AsTag)nodeTarget;
                if (!(tagTarget.getTarget() instanceof GetTagsQuery.AsCommit1) || !((commitTarget = (GetTagsQuery.AsCommit1)tagTarget.getTarget()).getOid() instanceof String)) continue;
                tagName = node.getName();
                commitSHA1 = (String)commitTarget.getOid();
                Tag tag = new Tag(tagName, commitSHA1);
                tags.add(tag);
            }
            Tag tag = new Tag(tagName, commitSHA1);
            tags.add(tag);
        }
        return tags;
    }

    private <T> Response<T> callSync(ApolloCall<T> call) {
        final CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.whenComplete((tResponse, throwable) -> {
            if (completableFuture.isCancelled()) {
                completableFuture.cancel(true);
            }
        });
        call.enqueue(new ApolloCall.Callback<T>(){

            public void onResponse(@NotNull Response<T> response) {
                completableFuture.complete(response);
            }

            public void onFailure(@NotNull ApolloException e) {
                completableFuture.completeExceptionally((Throwable)e);
            }
        });
        return (Response)completableFuture.join();
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        this.closed = true;
    }
}

