/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.openhft.chronicle.releasenotes.connector.Connector;
import net.openhft.chronicle.releasenotes.connector.MigrateException;

public interface MigrateConnector
extends Connector,
AutoCloseable {
    public MigrateResult migrateMilestones(String var1, List<String> var2, String var3, MigrateOptions var4);

    @Override
    default public void close() throws Exception {
    }

    @Deprecated
    default public MigrateResult migrateMilestones(String repository, List<String> fromMilestones, String toMilestone, List<String> ignoredLabels) {
        MigrateOptions migrateOptions = new MigrateOptions.Builder().ignoreLabels(ignoredLabels).build();
        return this.migrateMilestones(repository, fromMilestones, toMilestone, migrateOptions);
    }

    public static class MigrateOptions {
        public static final MigrateOptions DEFAULT = new MigrateOptions(new ArrayList<String>());
        private final List<String> ignoredLabels;

        private MigrateOptions(List<String> ignoredLabels) {
            this.ignoredLabels = ignoredLabels;
        }

        public List<String> getIgnoredLabels() {
            return this.ignoredLabels;
        }

        public static final class Builder {
            private final List<String> ignoredLabels = new ArrayList<String>();

            public Builder ignoreLabels(String ... labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(Arrays.asList(labels));
                return this;
            }

            public Builder ignoreLabels(List<String> labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(labels);
                return this;
            }

            public MigrateOptions build() {
                return new MigrateOptions(this.ignoredLabels);
            }
        }
    }

    public static class MigrateResult {
        private final MigrateException error;

        private MigrateResult(MigrateException error) {
            this.error = error;
        }

        public MigrateException getError() {
            return this.error;
        }

        public void throwIfFail() {
            if (this.isFail()) {
                throw this.error;
            }
        }

        public boolean isSuccess() {
            return this.error == null;
        }

        public boolean isFail() {
            return !this.isSuccess();
        }

        public static MigrateResult success() {
            return new MigrateResult(null);
        }

        public static MigrateResult fail(MigrateException error) {
            Objects.requireNonNull(error);
            return new MigrateResult(error);
        }

        public static MigrateResult fail(Throwable error) {
            return MigrateResult.fail(new MigrateException(error.getMessage()));
        }
    }
}

