/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.issue;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ChangeRollCycleTest {
    @Test
    public void changeRollCycleWithReadOnlyTailer() {
        this.testChangeRollCycle(true);
    }

    @Test
    public void changeRollCycleWithReadWriteTailer() {
        this.testChangeRollCycle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChangeRollCycle(boolean readOnly) {
        String queuePath = OS.getTarget() + "/changeRollCycle-" + System.nanoTime();
        try (SingleChronicleQueue q1 = ChronicleQueue.singleBuilder((String)queuePath).rollCycle((RollCycle)RollCycles.FAST_DAILY).readOnly(readOnly).build();
             ExcerptTailer tailer = q1.createTailer();){
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((String)"Queue should be empty initially", (boolean)dc.isPresent());
            }
            var8_12 = null;
            try (SingleChronicleQueue q2 = ChronicleQueue.singleBuilder((String)queuePath).rollCycle((RollCycle)RollCycles.WEEKLY).build();
                 ExcerptAppender appender2 = q2.createAppender();){
                appender2.writeText((CharSequence)"Hello");
                try (SingleChronicleQueue q3 = ChronicleQueue.singleBuilder((String)queuePath).rollCycle((RollCycle)RollCycles.FAST_HOURLY).build();
                     ExcerptAppender appender3 = q3.createAppender();){
                    Assert.assertEquals((Object)q2.rollCycle(), (Object)q3.rollCycle());
                    appender3.writeText((CharSequence)"World");
                    if (readOnly) {
                        Assert.assertEquals((String)"Roll cycle should match WEEKLY for read-only mode", (Object)RollCycles.WEEKLY, (Object)q3.rollCycle());
                    }
                }
                Assume.assumeFalse((boolean)readOnly);
                Assert.assertEquals((String)"First message should match", (Object)"Hello", (Object)tailer.readText());
                if (readOnly) {
                    Assert.assertEquals((String)"Roll cycle should match WEEKLY for read-only mode", (Object)RollCycles.WEEKLY, (Object)q1.rollCycle());
                }
                Assert.assertEquals((String)"Second message should match", (Object)"World", (Object)tailer.readText());
                Assert.assertEquals((Object)q2.rollCycle(), (Object)q1.rollCycle());
                var12_24 = null;
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertFalse((String)"No more data should be present in the queue", (boolean)dc.isPresent());
                }
                catch (Throwable throwable) {
                    var12_24 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
        }
        finally {
            IOTools.deleteDirWithFiles((String)queuePath, (int)2);
        }
    }
}

