/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.stress.backwardstailer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.LargeRollCycles;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class BackwardsTailerToEndPerfAcceptanceTest
extends QueueTestCommon {
    private static final Logger log = LoggerFactory.getLogger(BackwardsTailerToEndPerfAcceptanceTest.class);
    private final RollCycle rollCycle;
    private final TailerIndexStartPosition tailerIndexStartPosition;
    private long baseline;

    public BackwardsTailerToEndPerfAcceptanceTest(RollCycle rollCycle, TailerIndexStartPosition tailerIndexStartPosition) {
        this.rollCycle = rollCycle;
        this.tailerIndexStartPosition = tailerIndexStartPosition;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{TestRollCycles.TEST_HOURLY, TailerIndexStartPosition.BEGINNING});
        data.add(new Object[]{LegacyRollCycles.DAILY, TailerIndexStartPosition.BEGINNING});
        data.add(new Object[]{LegacyRollCycles.DAILY, TailerIndexStartPosition.MIDDLE});
        data.add(new Object[]{LargeRollCycles.LARGE_DAILY, TailerIndexStartPosition.BEGINNING});
        data.add(new Object[]{TestRollCycles.TEST2_DAILY, TailerIndexStartPosition.BEGINNING});
        return data;
    }

    @Before
    public void before() {
        log.info("rollCycle={}, tailerIndexStartPosition={}", (Object)this.rollCycle, (Object)this.tailerIndexStartPosition);
        log.info("Capturing baseline performance. rollCycle={}", (Object)this.rollCycle);
        this.baseline = this.runTest(this.rollCycle.defaultIndexCount() * this.rollCycle.defaultIndexSpacing() - 1, TailerDirection.BACKWARD, this.tailerIndexStartPosition, this.rollCycle);
        log.info("Baseline performance captured. rollCycle={}", (Object)this.rollCycle);
    }

    @Ignore(value="Disabled as too flaky when run as part of the full test suite")
    @Test
    public void fromBeginning() {
        long duration = this.runTest(this.rollCycle.defaultIndexCount() * this.rollCycle.defaultIndexSpacing() + 1, TailerDirection.BACKWARD, this.tailerIndexStartPosition, this.rollCycle);
        this.assertReasonablePerformance(duration);
    }

    @Ignore(value="Disabled as too flaky when run as part of the full test suite")
    @Test
    public void lessThanBoundary() {
        long duration = this.runTest(this.rollCycle.defaultIndexCount() * this.rollCycle.defaultIndexSpacing() + 1, TailerDirection.BACKWARD, this.tailerIndexStartPosition, this.rollCycle);
        this.assertReasonablePerformance(duration);
    }

    @Ignore(value="Disabled as too flaky when run as part of the full test suite")
    @Test
    public void onBoundary() {
        long duration = this.runTest(this.rollCycle.defaultIndexCount() * this.rollCycle.defaultIndexSpacing(), TailerDirection.BACKWARD, this.tailerIndexStartPosition, this.rollCycle);
        this.assertReasonablePerformance(duration);
    }

    @Ignore(value="Disabled as too flaky when run as part of the full test suite")
    @Test
    public void greaterThanBoundary() {
        long duration = this.runTest(this.rollCycle.defaultIndexCount() * this.rollCycle.defaultIndexSpacing() - 1, TailerDirection.BACKWARD, this.tailerIndexStartPosition, this.rollCycle);
        this.assertReasonablePerformance(duration);
    }

    private void assertReasonablePerformance(long duration) {
        double factor = (double)duration / (double)this.baseline;
        long baselineUs = this.baseline / 1000L;
        long durationUs = duration / 1000L;
        String message = "Performance of this test was " + factor + "x baseline. baseline=" + baselineUs + "us, duration=" + durationUs + "us.";
        log.info(message);
        Assert.assertTrue((String)message, (factor < 10.0 ? 1 : 0) != 0);
    }

    private void populateQueue(int entriesToWrite, ExcerptAppender appender) {
        for (int i = 0; i < entriesToWrite; ++i) {
            appender.writeText((CharSequence)("message_" + i));
            if (!this.rollCycle.equals(TestRollCycles.TEST2_DAILY)) continue;
            log.info("lastIndexAppended={}", (Object)appender.lastIndexAppended());
        }
    }

    /*
     * Exception decompiling
     */
    private long runTest(int entriesToWrite, TailerDirection tailerDirection, TailerIndexStartPosition tailerIndexStartPosition, RollCycle rollCycle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private SingleChronicleQueue createQueue(File path, RollCycle rollCycle) {
        SetTimeProvider setTimeProvider = new SetTimeProvider();
        return SingleChronicleQueueBuilder.builder().timeProvider((TimeProvider)setTimeProvider).path(path).rollCycle(rollCycle).build();
    }

    public static enum TailerIndexStartPosition {
        BEGINNING,
        MIDDLE;

    }
}

