/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.junit.Assert;
import org.junit.Test;

public class WriteBytesIndexTest
extends QueueTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeMultipleAppenders() {
        File path = IOTools.createTempFile((String)"writeMultipleAppenders");
        try (ChronicleQueue q0 = WriteBytesIndexTest.createQueue(path);
             ExcerptAppender a0 = q0.createAppender();
             ExcerptTailer t0 = q0.createTailer();
             ChronicleQueue q1 = WriteBytesIndexTest.createQueue(path);
             ExcerptAppender a1 = q1.createAppender();
             ExcerptTailer t1 = q1.createTailer();
             ChronicleQueue q2 = WriteBytesIndexTest.createQueue(path);){
            OnHeapBytes bytes = Bytes.allocateElasticOnHeap();
            OnHeapBytes bytes2 = Bytes.allocateElasticOnHeap();
            for (int cycle = 1; cycle < 10; ++cycle) {
                for (int seq = 0; seq < cycle; ++seq) {
                    ((Bytes)((Bytes)((Bytes)bytes.clear().append((CharSequence)"Msg ")).append((CharSequence)String.valueOf(cycle))).append((CharSequence)" ")).append((CharSequence)String.valueOf(seq));
                    long index = q0.rollCycle().toIndex(cycle, (long)seq);
                    if ((cycle + seq) % 5 < 2) {
                        ((InternalAppender)a0).writeBytes(index, (BytesStore)bytes);
                    }
                    ((InternalAppender)a1).writeBytes(index, (BytesStore)bytes);
                    Assert.assertTrue((boolean)t1.readBytes(bytes2.clear()));
                    if (!bytes.contentEquals((BytesStore)bytes2)) {
                        System.out.println(q2.dump());
                        Assert.assertEquals((Object)bytes.toString(), (Object)bytes2.toString());
                    }
                    Assert.assertFalse((boolean)t1.readBytes(bytes2.clear()));
                    Assert.assertTrue((boolean)t0.readBytes(bytes2.clear()));
                    if (!bytes.contentEquals((BytesStore)bytes2)) {
                        System.out.println(q2.dump());
                        Assert.assertEquals((Object)bytes.toString(), (Object)bytes2.toString());
                    }
                    Assert.assertFalse((boolean)t0.readBytes(bytes2.clear()));
                }
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)path);
        }
    }

    static ChronicleQueue createQueue(File path) {
        return SingleChronicleQueueBuilder.single((File)path).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).build();
    }
}

