/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class ToEndTest
extends QueueTestCommon {
    private static final long FIVE_SECONDS = TimeUnit.SECONDS.toMicros(5L);
    private static final String ZERO_AS_HEX_STRING = Long.toHexString(0L);
    private static final String LONG_MIN_VALUE_AS_HEX_STRING = Long.toHexString(Long.MIN_VALUE);
    long lastCycle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void missingCyclesToEndTest() {
        String path = OS.getTarget() + "/missingCyclesToEndTest-" + Time.uniqueId();
        try {
            IOTools.shallowDeleteDirWithFiles((String)path);
            SetTimeProvider timeProvider = new SetTimeProvider();
            long now = 1470757797000L;
            long timeIncMs = 1001L;
            timeProvider.currentTimeMillis(now);
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)timeProvider).build();
                 ExcerptAppender appender = queue.createAppender();){
                appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(1));
                timeProvider.currentTimeMillis(now += timeIncMs);
                appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(2));
                appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(3));
                ExcerptTailer tailer = queue.createTailer().toEnd();
                try (DocumentContext dc = tailer.readingDocument();){
                    if (dc.isPresent()) {
                        Assert.fail((String)("Should be at the end of the queue but dc.isPresent and we read: " + dc.wire().read("msg").int32()));
                    }
                }
                appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(4));
                dc = tailer.readingDocument();
                var13_17 = null;
                try {
                    Assert.assertTrue((String)"Should be able to read entry in this cycle. Got NoDocumentContext.", (boolean)dc.isPresent());
                    int i = dc.wire().read("msg").int32();
                    Assert.assertEquals((String)("Should've read 4, instead we read: " + i), (long)4L, (long)i);
                }
                catch (Throwable throwable) {
                    var13_17 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc != null) {
                        if (var13_17 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable) {
                                var13_17.addSuppressed(throwable);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                tailer.toStart();
                for (int j = 1; j <= 4; ++j) {
                    try (DocumentContext dc = tailer.readingDocument();){
                        Assert.assertTrue((boolean)dc.isPresent());
                        int i = dc.wire().read("msg").int32();
                        Assert.assertEquals((long)j, (long)i);
                        continue;
                    }
                }
                dc = tailer.readingDocument();
                var13_17 = null;
                try {
                    if (dc.isPresent()) {
                        Assert.fail((String)("Should be at the end of the queue but dc.isPresent and we read: " + String.valueOf(dc.wire().read("msg").int32())));
                    }
                }
                catch (Throwable throwable) {
                    var13_17 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc != null) {
                        if (var13_17 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable) {
                                var13_17.addSuppressed(throwable);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(5));
                timeProvider.currentTimeMillis(now += timeIncMs * 5L);
                dc = tailer.readingDocument();
                var13_17 = null;
                try {
                    Assert.assertTrue((boolean)dc.isPresent());
                    Assert.assertEquals((long)5L, (long)dc.wire().read("msg").int32());
                }
                catch (Throwable throwable) {
                    var13_17 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc != null) {
                        if (var13_17 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable) {
                                var13_17.addSuppressed(throwable);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                dc = tailer.readingDocument();
                var13_17 = null;
                try {
                    Assert.assertFalse((boolean)dc.isPresent());
                }
                catch (Throwable throwable) {
                    var13_17 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc != null) {
                        if (var13_17 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable) {
                                var13_17.addSuppressed(throwable);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{path});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{path});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tailerToEndIncreasesRefCount() throws NoSuchFieldException, IllegalAccessException {
        String path = OS.getTarget() + "/toEndIncRefCount-" + Time.uniqueId();
        IOTools.shallowDeleteDirWithFiles((String)path);
        SetTimeProvider time = new SetTimeProvider();
        long now = System.currentTimeMillis();
        time.currentTimeMillis(now);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)time).build();
             StoreAppender appender = (StoreAppender)queue.createAppender();){
            Field storeF1 = StoreAppender.class.getDeclaredField("store");
            Jvm.setAccessible((AccessibleObject)storeF1);
            SingleChronicleQueueStore store1 = (SingleChronicleQueueStore)storeF1.get(appender);
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(1));
            StoreTailer tailer = (StoreTailer)queue.createTailer();
            tailer.toEnd();
            Field storeF2 = StoreTailer.class.getDeclaredField("store");
            Jvm.setAccessible((AccessibleObject)storeF2);
            SingleChronicleQueueStore store2 = (SingleChronicleQueueStore)storeF2.get(tailer);
            Assert.assertFalse((boolean)store2.isClosed());
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{path});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{path});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void toEndTest() {
        File baseDir = this.getTmpDir();
        try {
            ArrayList<Integer> results = new ArrayList<Integer>();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)baseDir).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_DAILY).build();
                 ExcerptAppender appender = queue.createAppender();){
                this.checkOneFile(baseDir);
                this.checkOneFile(baseDir);
                int i = 0;
                while (i < 10) {
                    int j = i++;
                    appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(j));
                }
                this.checkOneFile(baseDir);
                ExcerptTailer tailer = queue.createTailer();
                this.checkOneFile(baseDir);
                ExcerptTailer atEnd = tailer.toEnd();
                Assert.assertEquals((long)10L, (long)queue.rollCycle().toSequenceNumber(atEnd.index()));
                this.checkOneFile(baseDir);
                this.fillResults(atEnd, results);
                this.checkOneFile(baseDir);
                Assert.assertEquals((long)0L, (long)results.size());
                tailer.toStart();
                this.checkOneFile(baseDir);
                this.fillResults(tailer, results);
                Assert.assertEquals((long)10L, (long)results.size());
                this.checkOneFile(baseDir);
            }
            System.gc();
        }
        finally {
            IOTools.deleteDirWithFiles((File)baseDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void toEndBeforeWriteTest() {
        File baseDir = this.getTmpDir();
        IOTools.shallowDeleteDirWithFiles((File)baseDir);
        try {
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)baseDir).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_DAILY).build();){
                this.checkOneFile(baseDir);
                try (ExcerptAppender appender = queue.createAppender();){
                    Assert.assertNotNull((Object)appender);
                    this.checkOneFile(baseDir);
                    ExcerptTailer tailer = queue.createTailer();
                    this.checkOneFile(baseDir);
                    ExcerptTailer tailer2 = queue.createTailer();
                    this.checkOneFile(baseDir);
                    tailer.toEnd();
                    this.checkOneFile(baseDir);
                    tailer2.toEnd();
                    this.checkOneFile(baseDir);
                }
            }
            System.gc();
        }
        finally {
            IOTools.deleteDirWithFiles((File)baseDir);
        }
    }

    @Test
    public void toEndAfterWriteTest() {
        File file = this.getTmpDir();
        IOTools.shallowDeleteDirWithFiles((File)file);
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(1470757797000L);
        try (SingleChronicleQueue wqueue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)stp).build();
             ExcerptAppender appender = wqueue.createAppender();){
            for (int i = 0; i < 10; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().getValueOut().text("hi-" + i);
                    this.lastCycle = wqueue.rollCycle().toCycle(dc.index());
                }
                stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            }
        }
        var4_4 = null;
        try (SingleChronicleQueue rqueue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)stp).build();){
            ExcerptTailer tailer = rqueue.createTailer();
            stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            while (tailer.readText() != null) {
            }
            Assert.assertNull((Object)tailer.readText());
            stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            ExcerptTailer tailer1 = rqueue.createTailer();
            ExcerptTailer excerptTailer = tailer1.toEnd();
            Assert.assertNull((Object)excerptTailer.readText());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        System.gc();
    }

    @Test
    public void shouldReturnExpectedValuesForEmptyQueue() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = this.createQueue(timeProvider);){
            Assert.assertEquals((Object)ZERO_AS_HEX_STRING, (Object)this.tailerToEndIndex(queue));
            Assert.assertEquals((Object)LONG_MIN_VALUE_AS_HEX_STRING, (Object)this.lastWriteIndex(queue));
        }
    }

    @Test
    public void shouldReturnExpectedValuesForQueueWithOnlyMetadata() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.advanceMicros(FIVE_SECONDS);
        try (SingleChronicleQueue queue = this.createQueue(timeProvider);){
            Assume.assumeFalse((String)"Ignored on hugetlbfs as byte offsets will be different due to page size", (boolean)PageUtil.isHugePage((String)queue.file().getAbsolutePath()));
            this.writeMetadataToQueue(queue);
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !short 1000, format: yyyyMMdd-HHmmss'T4', epoch: 0 },\n    sourceId: 0\n  }\n}\n# position: 160, header: 0\n--- !!data #binary\nlisting.highestCycle: 5\n# position: 200, header: 1\n--- !!data #binary\nlisting.lowestCycle: 5\n# position: 240, header: 2\n--- !!data #binary\nlisting.modCount: 3\n# position: 272, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 312, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 352, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 400, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n# position: 456, header: 7\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n...\n# 130564 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    0,\n    0\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 200,\n    lastIndex: 0\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 32, used: 1\n  496,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 496, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 784, header: -1\n--- !!meta-data #binary\n\"\": hello!\n...\n# 130272 bytes remaining\n", (Object)queue.dump());
            Assert.assertEquals((Object)LONG_MIN_VALUE_AS_HEX_STRING, (Object)this.lastWriteIndex(queue));
            String actual = this.tailerToEndIndex(queue);
            this.writeExcerptToQueue(queue);
            Assert.assertEquals((Object)actual, (Object)this.lastWriteIndex(queue));
        }
    }

    @Test
    public void shouldReturnExpectedValuesForNonEmptyQueueRolledByMetadata() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.advanceMicros(FIVE_SECONDS);
        try (SingleChronicleQueue queue = this.createQueue(timeProvider);){
            this.writeExcerptToQueue(queue);
            String lastWriteIndexBefore = this.lastWriteIndex(queue);
            String tailerToEndIndexBefore = this.tailerToEndIndex(queue);
            timeProvider.advanceMicros(FIVE_SECONDS);
            this.writeMetadataToQueue(queue);
            Assert.assertEquals((Object)lastWriteIndexBefore, (Object)this.lastWriteIndex(queue));
            Assert.assertEquals((Object)tailerToEndIndexBefore, (Object)this.tailerToEndIndex(queue));
        }
    }

    @Ignore(value="for manual use")
    @Test
    public void shouldReuseStoreWhenNoUpdates() {
        File dir = this.getTmpDir();
        ChronicleQueue queue = ChronicleQueue.single((String)dir.toString());
        Throwable throwable = null;
        try {
            try {
                ExcerptAppender appender = queue.createAppender();
                Throwable throwable2 = null;
                try {
                    try {
                        appender.writeBytes(Bytes.from((String)"i must not leak"));
                        ExcerptTailer tailer = queue.createTailer();
                        Throwable throwable3 = null;
                        try {
                            try {
                                while (true) {
                                    tailer.toEnd();
                                }
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (tailer != null) {
                                if (throwable3 != null) {
                                    try {
                                        tailer.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable3.addSuppressed(throwable6);
                                    }
                                } else {
                                    tailer.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable2 = throwable7;
                        throw throwable7;
                    }
                }
                catch (Throwable throwable8) {
                    if (appender != null) {
                        if (throwable2 != null) {
                            try {
                                appender.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            appender.close();
                        }
                    }
                    throw throwable8;
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
        }
        catch (Throwable throwable11) {
            if (queue != null) {
                if (throwable != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable12) {
                        throwable.addSuppressed(throwable12);
                    }
                } else {
                    queue.close();
                }
            }
            throw throwable11;
        }
    }

    private String tailerToEndIndex(SingleChronicleQueue queue) {
        try (ExcerptTailer tailer = queue.createTailer().toEnd();){
            String string = Long.toHexString(tailer.index());
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    private String lastWriteIndex(SingleChronicleQueue queue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeExcerptToQueue(SingleChronicleQueue queue) {
        try (ExcerptAppender excerptAppender = queue.createAppender();){
            excerptAppender.writeText((CharSequence)"hello!");
        }
    }

    private void writeMetadataToQueue(SingleChronicleQueue queue) {
        try (ExcerptAppender excerptAppender = queue.createAppender();
             DocumentContext documentContext = excerptAppender.writingDocument(true);){
            documentContext.wire().write().text("hello!");
        }
    }

    private SingleChronicleQueue createQueue(SetTimeProvider timeProvider) {
        File queueDir = this.getTmpDir();
        return SingleChronicleQueueBuilder.binary((File)queueDir).blockSize(65536).rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)timeProvider).build();
    }

    private void checkOneFile(@NotNull File baseDir) {
        Object[] files = baseDir.list((d, n) -> n.endsWith(".cq4"));
        if (files == null || files.length == 0) {
            return;
        }
        if (files.length == 1) {
            Assert.assertTrue((String)files[0], (boolean)files[0].startsWith("2"));
        } else {
            Assert.fail((String)("Too many files " + Arrays.toString(files)));
        }
    }

    @NotNull
    private List<Integer> fillResults(@NotNull ExcerptTailer tailer, @NotNull List<Integer> results) {
        for (int i = 0; i < 10; ++i) {
            try (DocumentContext documentContext = tailer.readingDocument();){
                if (!documentContext.isPresent()) break;
                results.add(documentContext.wire().read("msg").int32());
                continue;
            }
        }
        return results;
    }
}

