/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ToEndInvalidIndexTest
extends QueueTestCommon {
    private static final long LAST_INDEX = RollCycles.FAST_DAILY.toIndex(2, 2L);
    private Path queuePath;
    private SetTimeProvider setTimeProvider;

    @Before
    public void setUp() throws StreamCorruptedException {
        this.queuePath = IOTools.createTempDirectory((String)"partialIndex");
        this.setTimeProvider = new SetTimeProvider();
        ToEndInvalidIndexTest.createQueueWithZeroFirstSubIndexValue(this.setTimeProvider, this.queuePath);
    }

    @Override
    @After
    public void tearDown() {
        IOTools.deleteDirWithFiles((File)this.queuePath.toFile());
    }

    @Test
    public void testBackwardsToEndReportsCorrectIndex() {
        try (SingleChronicleQueue queue = ToEndInvalidIndexTest.createQueue(this.setTimeProvider, this.queuePath);
             ExcerptTailer tailer = queue.createTailer();){
            StoreTailer storeTailer = (StoreTailer)tailer;
            Assert.assertEquals((long)0L, (long)storeTailer.store.indexing.linearScanCount());
            tailer.direction(TailerDirection.BACKWARD).toEnd();
            Assert.assertEquals((long)1L, (long)storeTailer.store.indexing.linearScanCount());
        }
    }

    private static void createQueueWithZeroFirstSubIndexValue(SetTimeProvider setTimeProvider, Path path) throws StreamCorruptedException {
        try (SingleChronicleQueue queue = ToEndInvalidIndexTest.createQueue(setTimeProvider, path);
             ExcerptAppender appender = queue.createAppender();){
            NativeBytes bytes = Bytes.allocateElasticDirect();
            bytes.write((CharSequence)"x");
            int count = queue.indexCount() * queue.indexSpacing() + 1;
            for (int x = 0; x < count; ++x) {
                appender.writeBytes((Bytes)bytes);
            }
            long index = appender.lastIndexAppended();
            long sequenceNumber = queue.rollCycle().toSequenceNumber(index);
            StoreAppender storeAppender = (StoreAppender)appender;
            SingleChronicleQueueStore store = storeAppender.store;
            assert (store != null);
            store.indexing.setPositionForSequenceNumber((ExcerptContext)storeAppender, sequenceNumber, 0L);
        }
    }

    @NotNull
    private static SingleChronicleQueue createQueue(SetTimeProvider setTimeProvider, Path queuePath) {
        return SingleChronicleQueueBuilder.binary((Path)queuePath).timeProvider((TimeProvider)setTimeProvider).testBlockSize().rollCycle((RollCycle)RollCycles.FAST_DAILY).build();
    }
}

