/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListing;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListingReadOnly;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableDirectoryListingTest
extends QueueTestCommon {
    private DirectoryListing listing;
    private DirectoryListing listingReadOnly;
    private TableStore<Metadata.NoMeta> tablestore;
    private TableStore<Metadata.NoMeta> tablestoreReadOnly;
    private File testDirectory;
    private File tempFile;

    @NotNull
    private File testDirectory() {
        return this.getTmpDir();
    }

    @Before
    public void setUp() throws IOException {
        this.testDirectory = this.testDirectory();
        this.testDirectory.mkdirs();
        File tableFile = new File(this.testDirectory, "dir-list.cq4t");
        this.tablestore = SingleTableBuilder.binary((File)tableFile, (Metadata)Metadata.NoMeta.INSTANCE).build();
        this.tablestoreReadOnly = SingleTableBuilder.binary((File)tableFile, (Metadata)Metadata.NoMeta.INSTANCE).readOnly(true).build();
        SystemTimeProvider time = SystemTimeProvider.INSTANCE;
        this.listing = new TableDirectoryListing(this.tablestore, this.testDirectory.toPath(), f -> Integer.parseInt(f.split("\\.")[0]), (TimeProvider)time);
        this.listingReadOnly = new TableDirectoryListingReadOnly(this.tablestore, (TimeProvider)time);
        this.listing.init();
        this.listingReadOnly.init();
        this.tempFile = File.createTempFile("foo", "bar");
        this.tempFile.deleteOnExit();
    }

    @Override
    public void preAfter() {
        Closeable.closeQuietly((Object[])new Object[]{this.tablestore, this.tablestoreReadOnly, this.listing, this.listingReadOnly});
    }

    @Test(expected=IllegalStateException.class)
    public void shouldBlowUpIfClosed() {
        this.listing.close();
        this.listing.getMaxCreatedCycle();
    }

    @Test
    public void shouldTrackMaxValue() {
        this.listing.refresh(true);
        this.listing.onFileCreated(this.tempFile, 7);
        Assert.assertEquals((long)7L, (long)this.listing.getMaxCreatedCycle());
        Assert.assertEquals((long)7L, (long)this.listing.getMinCreatedCycle());
        Assert.assertEquals((long)7L, (long)this.listingReadOnly.getMaxCreatedCycle());
        Assert.assertEquals((long)7L, (long)this.listingReadOnly.getMinCreatedCycle());
        this.listing.onFileCreated(this.tempFile, 8);
        Assert.assertEquals((long)8L, (long)this.listing.getMaxCreatedCycle());
        Assert.assertEquals((long)7L, (long)this.listing.getMinCreatedCycle());
        Assert.assertEquals((long)8L, (long)this.listingReadOnly.getMaxCreatedCycle());
        Assert.assertEquals((long)7L, (long)this.listingReadOnly.getMinCreatedCycle());
    }

    @Test
    public void shouldInitialiseFromFilesystem() throws IOException {
        new File(this.testDirectory, "1.cq4").createNewFile();
        new File(this.testDirectory, "2.cq4").createNewFile();
        new File(this.testDirectory, "3.cq4").createNewFile();
        this.listing.refresh(true);
        Assert.assertEquals((long)3L, (long)this.listing.getMaxCreatedCycle());
        Assert.assertEquals((long)1L, (long)this.listing.getMinCreatedCycle());
        Assert.assertEquals((long)3L, (long)this.listingReadOnly.getMaxCreatedCycle());
        Assert.assertEquals((long)1L, (long)this.listingReadOnly.getMinCreatedCycle());
    }

    @Test
    public void lockShouldTimeOut() {
        this.listing.onFileCreated(this.tempFile, 8);
        this.listing.onFileCreated(this.tempFile, 9);
        Assert.assertEquals((long)9L, (long)this.listing.getMaxCreatedCycle());
        Assert.assertEquals((long)9L, (long)this.listingReadOnly.getMaxCreatedCycle());
    }
}

