/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.BinarySearch;
import net.openhft.chronicle.queue.impl.single.NotComparableException;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SparseBinarySearchTest
extends QueueTestCommon {
    private static final GapTolerantComparator GAP_TOLERANT_COMPARATOR = new GapTolerantComparator();
    private final int numberOfMessages;
    private final float percentageWithValues;

    public SparseBinarySearchTest(int numberOfMessages, float percentageWithValues) {
        this.numberOfMessages = numberOfMessages;
        this.percentageWithValues = percentageWithValues;
    }

    @Parameterized.Parameters(name="items in queue: {0}, percentage with values: {1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        List<Integer> numbersOfMessages = Arrays.asList(0, 1, 2, 100);
        List<Float> percentagesWithValues = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.1f), Float.valueOf(0.9f));
        for (int nom : numbersOfMessages) {
            for (float pwv : percentagesWithValues) {
                parameters.add(new Object[]{nom, Float.valueOf(pwv)});
            }
        }
        return parameters;
    }

    @Test
    public void testBinarySearchWithManyGapsAndManyRollCycles() throws ParseException {
        this.runWithTimeParameters((RollCycle)TestRollCycles.TEST_SECONDLY, 300L);
    }

    @Test
    public void testBinarySearchWithManyGaps() throws ParseException {
        this.runWithTimeParameters((RollCycle)LegacyRollCycles.DAILY, 1L);
    }

    public void runWithTimeParameters(RollCycle rollCycle, long incrementInMillis) throws ParseException {
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(0L);
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle(rollCycle).timeProvider((TimeProvider)stp).build();
             ExcerptAppender appender = queue.createAppender();){
            HashSet<Integer> entriesWithValues = new HashSet<Integer>();
            Random random = new Random();
            for (int i = 0; i < this.numberOfMessages; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    MyData myData = new MyData();
                    boolean putValueAtIndex = random.nextFloat() < this.percentageWithValues;
                    myData.key = putValueAtIndex ? i : -1;
                    myData.value = "some value where the key=" + i;
                    dc.wire().getValueOut().typedMarshallable((WriteMarshallable)myData);
                    stp.currentTimeMillis(stp.currentTimeMillis() + incrementInMillis);
                    if (!putValueAtIndex) continue;
                    entriesWithValues.add(i);
                    continue;
                }
            }
            try (ExcerptTailer tailer = queue.createTailer();
                 ExcerptTailer binarySearchTailer = queue.createTailer();){
                for (int j = 0; j < this.numberOfMessages; ++j) {
                    try (DocumentContext ignored = tailer.readingDocument();){
                        Assert.assertNotNull((Object)ignored);
                        Wire key = this.toWire(j);
                        long index = BinarySearch.search((ExcerptTailer)binarySearchTailer, (Wire)key, (Comparator)GAP_TOLERANT_COMPARATOR);
                        if (entriesWithValues.contains(j)) {
                            Assert.assertEquals((long)tailer.index(), (long)index);
                        } else {
                            Assert.assertTrue((index < 0L ? 1 : 0) != 0);
                        }
                        key.bytes().releaseLast();
                        continue;
                    }
                }
                Wire key = this.toWire(this.numberOfMessages);
                Assert.assertTrue((String)"Should not find non-existent", (BinarySearch.search((ExcerptTailer)tailer, (Wire)key, (Comparator)GAP_TOLERANT_COMPARATOR) < 0L ? 1 : 0) != 0);
            }
        }
    }

    @NotNull
    private Wire toWire(int key) {
        MyData myData = new MyData();
        myData.key = key;
        myData.value = Integer.toString(key);
        Wire wire = (Wire)WireType.BINARY.apply((Object)Bytes.allocateElasticOnHeap());
        wire.usePadding(true);
        try (DocumentContext dc = wire.writingDocument();){
            dc.wire().getValueOut().typedMarshallable((WriteMarshallable)myData);
        }
        return wire;
    }

    public static class MyData
    extends SelfDescribingMarshallable {
        private int key;
        private String value;

        @NotNull
        public String toString() {
            return "MyData{key=" + this.key + ", value='" + this.value + '\'' + '}';
        }
    }

    static class GapTolerantComparator
    implements Comparator<Wire> {
        GapTolerantComparator() {
        }

        @Override
        public int compare(Wire o1, Wire o2) {
            long readPositionO1 = o1.bytes().readPosition();
            long readPositionO2 = o2.bytes().readPosition();
            try {
                MyData myDataO2;
                MyData myDataO1;
                try (DocumentContext dc = o1.readingDocument();){
                    myDataO1 = (MyData)((Object)dc.wire().getValueIn().typedMarshallable());
                }
                try (DocumentContext dc = o2.readingDocument();){
                    myDataO2 = (MyData)((Object)dc.wire().getValueIn().typedMarshallable());
                }
                if (myDataO1.key >= 0 && myDataO2.key >= 0) {
                    int compare;
                    int n = compare = Integer.compare(myDataO1.key, myDataO2.key);
                    return n;
                }
                throw NotComparableException.INSTANCE;
            }
            finally {
                o1.bytes().readPosition(readPositionO1);
                o2.bytes().readPosition(readPositionO2);
            }
        }
    }
}

