/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycleDefaultingTest;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.TailerState;
import net.openhft.chronicle.queue.TestKey;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.queue.rollcycles.SparseRollCycles;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.testframework.FlakyTestRunner;
import net.openhft.chronicle.testframework.GcControls;
import net.openhft.chronicle.testframework.mappedfiles.MappedFileUtil;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.YieldingPauser;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SingleChronicleQueueTest
extends QueueTestCommon {
    private static final long TIMES = 0x400000L;
    @NotNull
    protected final WireType wireType;
    protected final boolean named;
    protected final Bytes<?> appenderListenerDump = Bytes.allocateElasticOnHeap((int)256);

    public SingleChronicleQueueTest(@NotNull WireType wireType, boolean named) {
        this.wireType = wireType;
        this.named = named;
    }

    @Parameterized.Parameters(name="wireType={0}, named={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({WireType.BINARY_LIGHT, true}, {WireType.BINARY, false}, {WireType.BINARY_LIGHT, false});
    }

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    private static List<String> getMappedQueueFiles() {
        return MappedFileUtil.getAllMappedFiles().stream().filter(filename -> filename.contains(".cq4")).collect(Collectors.toList());
    }

    private static long countEntries(ChronicleQueue queue, boolean named) {
        ExcerptTailer tailer = queue.createTailer(named ? "named" : null);
        tailer.toStart().direction(TailerDirection.FORWARD);
        long entryCount = 0L;
        while (true) {
            DocumentContext ctx = tailer.readingDocument();
            Throwable throwable = null;
            try {
                if (!ctx.isPresent()) break;
                ++entryCount;
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
                continue;
            }
            break;
        }
        return entryCount;
    }

    private static void waitFor(Supplier<Boolean> condition, String message) {
        long timeoutAt = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeoutAt) {
            if (!condition.get().booleanValue()) continue;
            return;
        }
        Assert.fail((String)message);
    }

    @Test
    public void testAppend() {
        try (SingleChronicleQueue queue = this.builderWithAppendListener(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            int i = 0;
            while (i < 10) {
                int n = i++;
                appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(n));
                Assert.assertEquals((long)n, (long)queue.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
            }
            Assert.assertEquals((long)10L, (long)SingleChronicleQueueTest.countEntries((ChronicleQueue)queue, this.named));
        }
        Assert.assertEquals((Object)this.expectedForTestAppend(), (Object)this.appenderListenerDump.toString());
    }

    @Test
    public void createAppenderWillReturnANewAppenderEachTime() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender1 = queue.createAppender();
             ExcerptAppender appender2 = queue.createAppender();){
            Assert.assertNotSame((Object)appender1, (Object)appender2);
        }
    }

    @Test
    public void createAppenderWillThrowWhenQueueIsReadOnly() {
        Assume.assumeFalse((boolean)OS.isWindows());
        File queueDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(queueDir, this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeText((CharSequence)"hello world");
            try (SingleChronicleQueue readOnlyQueue = this.builder(queueDir, this.wireType).readOnly(true).build();){
                Assert.assertThrows(IllegalStateException.class, () -> ((ChronicleQueue)readOnlyQueue).createAppender());
            }
        }
    }

    @NotNull
    protected String expectedForTestAppend() {
        return "idx: 4a0400000000\n# position: 784, header: 0\n--- !!data #binary\ntest: 0\n\nidx: 4a0400000001\n# position: 796, header: 0\n--- !!data #binary\ntest: 1\n\nidx: 4a0400000002\n# position: 808, header: 0\n--- !!data #binary\ntest: 2\n\nidx: 4a0400000003\n# position: 820, header: 0\n--- !!data #binary\ntest: 3\n\nidx: 4a0400000004\n# position: 832, header: 0\n--- !!data #binary\ntest: 4\n\nidx: 4a0400000005\n# position: 844, header: 0\n--- !!data #binary\ntest: 5\n\nidx: 4a0400000006\n# position: 856, header: 0\n--- !!data #binary\ntest: 6\n\nidx: 4a0400000007\n# position: 868, header: 0\n--- !!data #binary\ntest: 7\n\nidx: 4a0400000008\n# position: 880, header: 0\n--- !!data #binary\ntest: 8\n\nidx: 4a0400000009\n# position: 892, header: 0\n--- !!data #binary\ntest: 9\n\n";
    }

    @Test
    public void testTextReadWrite() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builderWithAppendListener(tmpDir, this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeText((CharSequence)"hello world");
            Assert.assertEquals((Object)"hello world", (Object)queue.createTailer(this.named ? "named" : null).readText());
        }
        Assert.assertEquals((Object)this.expectedForTestTextReadWrite(), (Object)this.appenderListenerDump.toString());
    }

    @NotNull
    protected String expectedForTestTextReadWrite() {
        return "idx: 4a0400000000\n# position: 784, header: 0\n--- !!data #binary\nhello world\n\n";
    }

    @Test
    public void testCleanupDir() throws Throwable {
        if (OS.isWindows()) {
            FlakyTestRunner.builder(this::testCleanupDir0).build().run();
        } else {
            this.testCleanupDir0();
        }
    }

    private void testCleanupDir0() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, this.wireType).build();
             ExcerptAppender appender = queue.createAppender();
             DocumentContext dc = appender.writingDocument();){
            dc.wire().write((CharSequence)"hello").text("world");
        }
        this.afterChecks();
        this.recordExceptions();
        IOTools.deleteDirWithFilesOrThrow((File[])new File[]{tmpDir});
    }

    @Test
    public void testRollbackOnAppend() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"hello").text("world");
            }
            dc = appender.writingDocument();
            var6_10 = null;
            try {
                dc.wire().write((CharSequence)"hello").text("world2");
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_10 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            try (DocumentContext dc = tailer.readingDocument();){
                dc.wire().read("hello");
                dc.rollbackOnClose();
            }
            dc = tailer.readingDocument();
            var7_15 = null;
            try {
                Assert.assertEquals((Object)"world", (Object)dc.wire().read("hello").text());
            }
            catch (Throwable throwable) {
                var7_15 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_15 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_15.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var7_15 = null;
            try {
                Assert.assertEquals((Object)"world2", (Object)dc.wire().read("hello").text());
            }
            catch (Throwable throwable) {
                var7_15 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_15 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_15.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWithDocumentReadBytesDifferentThreads() throws InterruptedException, TimeoutException, ExecutionException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            String expected = "some long message";
            ExecutorService service1 = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("service1"));
            ExecutorService service2 = null;
            try {
                Future<?> f = service1.submit(() -> SingleChronicleQueueTest.lambda$testWriteWithDocumentReadBytesDifferentThreads$2((ChronicleQueue)queue));
                ArrayBlockingQueue result = new ArrayBlockingQueue(10);
                service2 = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("service2"));
                service2.scheduleAtFixedRate(() -> this.lambda$testWriteWithDocumentReadBytesDifferentThreads$3((ChronicleQueue)queue, result), 1L, 1L, TimeUnit.MICROSECONDS);
                Bytes bytes = (Bytes)result.poll(5L, TimeUnit.SECONDS);
                if (bytes == null) {
                    f.get(1L, TimeUnit.SECONDS);
                    throw new NullPointerException("nothing in result");
                }
                try {
                    String actual = ((Wire)this.wireType.apply((Object)bytes)).read("key").text();
                    Assert.assertEquals((Object)"some long message", (Object)actual);
                    f.get(1L, TimeUnit.SECONDS);
                }
                finally {
                    bytes.releaseLast();
                }
            }
            finally {
                service1.shutdownNow();
                if (service2 != null) {
                    service2.shutdownNow();
                }
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldBlowUpIfTryingToCreateQueueWithUnparseableRollCycle() {
        this.expectException("Overriding roll length from existing metadata");
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)new RollCycleDefaultingTest.MyRollcycle()).build();
             ExcerptAppender excerptAppender = queue.createAppender();
             DocumentContext documentContext = excerptAppender.writingDocument();){
            documentContext.wire().write((CharSequence)"somekey").text("somevalue");
        }
        SingleChronicleQueue ignored = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();
        var3_3 = null;
        if (ignored != null) {
            if (var3_3 != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    var3_3.addSuppressed(throwable);
                }
            } else {
                ignored.close();
            }
        }
    }

    @Test
    public void testCanAppendMetadataIfAppendLockIsSet() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, this.wireType).build();){
            queue.appendLock().lock();
            try (ExcerptAppender appender = queue.createAppender();){
                Assume.assumeTrue((String)"Failing in CQE", (boolean)(appender instanceof StoreAppender));
                try (DocumentContext dc = appender.writingDocument(true);){
                    dc.wire().write((CharSequence)"Hello World");
                }
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testCantAppendIfAppendLockIsSet() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, this.wireType).build();){
            queue.appendLock().lock();
            try (ExcerptAppender appender = queue.createAppender();){
                appender.writeText((CharSequence)"Hello World");
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testCantAppendIfAppendLockIsSetInDifferentQueue() {
        this.expectException("Overriding roll length from existing metadata");
        this.expectException("Overriding roll cycle from");
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, this.wireType).build();){
            queue.appendLock().lock();
        }
        queue = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)new RollCycleDefaultingTest.MyRollcycle()).build();
        var3_3 = null;
        try (ExcerptAppender excerptAppender = queue.createAppender();){
            excerptAppender.writeText((CharSequence)"hello");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testCanAppendWriteBytesInternalIfAppendLockIsSet() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builderWithAppendListener(tmpDir, this.wireType).build();){
            queue.appendLock().lock();
            try (ExcerptAppender appender = queue.createAppender();){
                Assume.assumeTrue((boolean)(appender instanceof StoreAppender));
                Assume.assumeTrue((boolean)(appender instanceof StoreAppender));
                StoreAppender storeAppender = (StoreAppender)appender;
                queue.writeLock().lock();
                storeAppender.writeBytesInternal(0L, (BytesStore)test);
            }
        }
        Assert.assertEquals((Object)this.expectedForTestCanAppendWriteBytesInternalIfAppendLockIsSet(), (Object)this.appenderListenerDump.toString());
    }

    @NotNull
    protected String expectedForTestCanAppendWriteBytesInternalIfAppendLockIsSet() {
        return "idx: 0\n# position: 784, header: 0\n--- !!data\nhello world\n\n";
    }

    @Test
    public void shouldNotBlowUpIfTryingToCreateQueueWithIncorrectRollCycle() {
        this.expectException("Overriding roll length from existing metadata");
        this.expectException("Overriding roll cycle from");
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)RollCycles.DEFAULT).build();
             ExcerptAppender appender = queue.createAppender();
             DocumentContext documentContext = appender.writingDocument();){
            documentContext.wire().write((CharSequence)"somekey").text("somevalue");
        }
        var3_3 = null;
        try (SingleChronicleQueue reopen = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();){
            Assert.assertEquals((Object)RollCycles.DEFAULT, (Object)reopen.rollCycle());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldOverrideDifferentEpoch() {
        this.expectException("Overriding roll epoch from existing metadata, was 10, overriding to 100");
        File tmpDir = this.getTmpDir();
        int shouldBeEpoch = 100;
        try (SingleChronicleQueue queue = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).epoch(100L).build();
             ExcerptAppender appender = queue.createAppender();
             DocumentContext documentContext = appender.writingDocument();){
            documentContext.wire().write((CharSequence)"somekey").text("somevalue");
        }
        var4_4 = null;
        try (SingleChronicleQueue ignored = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).epoch(10L).build();){
            Assert.assertEquals((long)100L, (long)ignored.epoch());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testReadWriteHourly() {
        Throwable throwable;
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue qAppender = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();){
            throwable = null;
            try (ExcerptAppender appender = qAppender.createAppender();
                 DocumentContext documentContext2 = appender.writingDocument();){
                documentContext2.wire().write((CharSequence)"somekey").text("somevalue");
            }
            catch (Throwable documentContext2) {
                throwable = documentContext2;
                throw documentContext2;
            }
        }
        var3_3 = null;
        try (SingleChronicleQueue qTailer = this.builder(tmpDir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();){
            throwable = null;
            try (DocumentContext documentContext2 = qTailer.createTailer(this.named ? "named" : null).readingDocument();){
                String str = documentContext2.wire().read("somekey").text();
                Assert.assertEquals((Object)"somevalue", (Object)str);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var3_3 = throwable3;
            throw throwable3;
        }
    }

    private long toSeq(ChronicleQueue q, long index) {
        return q.rollCycle().toSequenceNumber(index);
    }

    @Test
    public void shouldAllowDirectoryToBeDeletedWhenQueueIsClosed() throws IOException {
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test deleting after close on windows");
            return;
        }
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(dir, this.wireType).testBlockSize().build();
             ExcerptAppender appender = queue.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("foo");
            }
            dc = queue.createTailer(this.named ? "named" : null).readingDocument();
            var7_13 = null;
            try {
                Assert.assertEquals((Object)"foo", (Object)dc.wire().read().text());
            }
            catch (Throwable throwable) {
                var7_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        var3_3 = null;
        try (Stream<Path> paths = Files.walk(dir.toPath(), new FileVisitOption[0]);){
            List unDeletable = paths.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> !p.toFile().delete()).collect(Collectors.toList());
            Assert.assertTrue((String)("Unable to delete " + unDeletable), (boolean)unDeletable.isEmpty());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        Assert.assertTrue((boolean)dir.delete());
    }

    @Test
    public void testReadingLessBytesThanWritten() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            Bytes expected = Bytes.wrapForRead((byte[])"some long message".getBytes(StandardCharsets.ISO_8859_1));
            for (int i = 0; i < 10; ++i) {
                appender.writeBytes(expected);
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            for (int i = 0; i < 10; ++i) {
                VanillaBytes b = Bytes.allocateDirect((long)8L);
                tailer.readBytes((Bytes)b);
                Assert.assertEquals((long)expected.readInt(0L), (long)b.readInt(0L));
                b.releaseLast();
            }
        }
    }

    @Test
    public void testAppendAndRead() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            int n;
            int cycle = appender.cycle();
            int i = 0;
            while (i < 10) {
                int n2 = i++;
                appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(n2));
                Assert.assertEquals((long)n2, (long)queue.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            int i2 = 0;
            while (i2 < 10) {
                n = i2++;
                Assert.assertTrue((boolean)tailer.readDocument(r -> Assert.assertEquals((long)n, (long)r.read((WireKey)TestKey.test).int32())));
                Assert.assertEquals((long)(n + 1), (long)queue.rollCycle().toSequenceNumber(tailer.index()));
            }
            i2 = 0;
            while (i2 < 10) {
                n = i2++;
                Assert.assertTrue((String)("n: " + n), (boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, (long)n)));
                Assert.assertTrue((String)("n: " + n), (boolean)tailer.readDocument(r -> Assert.assertEquals((long)n, (long)r.read((WireKey)TestKey.test).int32())));
                Assert.assertEquals((long)(n + 1), (long)queue.rollCycle().toSequenceNumber(tailer.index()));
            }
        }
    }

    @Test
    public void testReadAndAppend() throws InterruptedException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            CountDownLatch started = new CountDownLatch(1);
            int[] results = new int[2];
            Thread t = new Thread(() -> this.lambda$testReadAndAppend$10(started, (ChronicleQueue)queue, results));
            t.setDaemon(true);
            t.start();
            Assert.assertTrue((boolean)started.await(1L, TimeUnit.SECONDS));
            int i = 0;
            while (i < 2) {
                int n = i++;
                appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(n));
            }
            t.join(1000L);
            Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])results);
        }
    }

    @Test
    public void testCheckIndexWithWritingDocument() {
        this.doTestCheckIndex((appender, n) -> {
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().writeEventName((CharSequence)"").object((Object)("" + n));
            }
        });
    }

    @Test
    public void testCheckIndexWithWritingDocument2() {
        this.doTestCheckIndex((appender, n) -> {
            try (DocumentContext dc = appender.writingDocument();){
                ((Bytes)((Bytes)((Bytes)dc.wire().bytes().writeUtf8("Hello")).writeStopBit(12345L)).writeStopBit(1.2)).writeInt(1);
            }
        });
    }

    @Test
    public void testCheckIndexWithWriteBytes() {
        this.doTestCheckIndex((appender, n) -> appender.writeBytes(Bytes.from((String)("Message-" + n))));
    }

    @Test
    public void testCheckIndexWithWriteBytes2() {
        this.doTestCheckIndex((appender, n) -> appender.writeBytes(b -> {
            Bytes cfr_ignored_0 = (Bytes)((Bytes)b.append8bit("Message-")).append(n.intValue());
        }));
    }

    @Test
    public void testCheckIndexWithWriteBytes3() {
        this.doTestCheckIndex((appender, n) -> appender.writeBytes(b -> {
            Bytes cfr_ignored_0 = (Bytes)((Bytes)((Bytes)((Bytes)b.writeUtf8("Hello")).writeStopBit(12345L)).writeStopBit(1.2)).writeInt(1);
        }));
    }

    @Test
    public void testCheckIndexWithWriteMap() {
        this.doTestCheckIndex((appender, n) -> appender.writeMap((Map)new HashMap<String, String>(){
            {
                this.put("key", "Message-" + n);
            }
        }));
    }

    @Test
    public void testCheckIndexWithWriteText() {
        this.doTestCheckIndex((appender, n) -> appender.writeText((CharSequence)("Message-" + n)));
    }

    void doTestCheckIndex(@NotNull BiConsumer<ExcerptAppender, Integer> writeTo) {
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(System.currentTimeMillis() - 259200000L);
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).timeProvider((TimeProvider)stp).build();
             ExcerptAppender appender = queue.createAppender();){
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            int cycle = appender.cycle();
            for (int i = 0; i <= 5; ++i) {
                int n = i;
                writeTo.accept(appender, n);
                Assert.assertEquals((long)(cycle + i), (long)appender.cycle());
                try (DocumentContext dc = tailer.readingDocument();){
                    long index = tailer.index();
                    Assert.assertEquals((long)appender.cycle(), (long)tailer.cycle());
                    Assert.assertEquals((long)(cycle + i), (long)RollCycles.DEFAULT.toCycle(index));
                }
                stp.currentTimeMillis(stp.currentTimeMillis() + 86400000L);
            }
        }
    }

    @Test
    public void testAppendAndReadWithRollingB() {
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(System.currentTimeMillis() - 259200000L);
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).timeProvider((TimeProvider)stp).build();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(0));
            appender.writeDocument(w -> w.write((WireKey)TestKey.test2).int32(1000));
            int cycle = appender.cycle();
            for (int i = 1; i <= 5; ++i) {
                stp.currentTimeMillis(stp.currentTimeMillis() + 86400000L);
                int n = i;
                appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(n));
                Assert.assertEquals((long)(cycle + i), (long)appender.cycle());
                appender.writeDocument(w -> w.write((WireKey)TestKey.test2).int32(n + 1000));
                Assert.assertEquals((long)(cycle + i), (long)appender.cycle());
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null).toStart();
            for (int i = 0; i < 6; ++i) {
                int n = i;
                boolean condition = tailer.readDocument(r -> Assert.assertEquals((long)n, (long)r.read((WireKey)TestKey.test).int32()));
                Assert.assertTrue((String)("i : " + i), (boolean)condition);
                Assert.assertEquals((long)(cycle + i), (long)tailer.cycle());
                boolean condition2 = tailer.readDocument(r -> Assert.assertEquals((long)(n + 1000), (long)r.read((WireKey)TestKey.test2).int32()));
                Assert.assertTrue((String)("i2 : " + i), (boolean)condition2);
                Assert.assertEquals((long)(cycle + i), (long)tailer.cycle());
            }
        }
    }

    @Test
    public void testAppendAndReadAtIndex() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST2_DAILY).build();
             ExcerptAppender appender = queue.createAppender();){
            appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int n = i;
                appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(n));
                Assert.assertEquals((long)i, (long)queue.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            int i = 0;
            while (i < 5) {
                long index = queue.rollCycle().toIndex(appender.cycle(), (long)i);
                Assert.assertTrue((boolean)tailer.moveToIndex(index));
                int n = i++;
                Assert.assertTrue((boolean)tailer.readDocument(arg_0 -> SingleChronicleQueueTest.lambda$testAppendAndReadAtIndex$28(n, (ChronicleQueue)queue, arg_0)));
                long index2 = tailer.index();
                long sequenceNumber = queue.rollCycle().toSequenceNumber(index2);
                Assert.assertEquals((long)(n + 1), (long)sequenceNumber);
            }
        }
    }

    @Test
    public void testSimpleWire() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.writeDocument(wire -> wire.write((CharSequence)"FirstName").text("Steve"));
            appender.writeDocument(wire -> wire.write((CharSequence)"Surname").text("Jobs"));
            StringBuilder first = new StringBuilder();
            StringBuilder surname = new StringBuilder();
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            tailer.readDocument(wire -> wire.read("FirstName").text(first));
            tailer.readDocument(wire -> wire.read("Surname").text(surname));
            Assert.assertEquals((Object)"Steve Jobs", (Object)(first + " " + surname));
        }
    }

    @Test
    public void testIndexWritingDocument() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            long index;
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"FirstName").text("Quartilla");
                index = dc.index();
            }
            dc = appender.writingDocument(true);
            var8_8 = null;
            try {
                dc.wire().write((CharSequence)"FirstName").text("Quartilla");
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_8 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Assert.assertEquals((long)index, (long)appender.lastIndexAppended());
        }
    }

    @Test
    public void testReadingWritingMarshallableDocument() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            MyMarshable myMarshable = new MyMarshable();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"myMarshable").typedMarshallable((WriteMarshallable)myMarshable);
            }
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertEquals((Object)((Object)myMarshable), (Object)dc.wire().read("myMarshable").typedMarshallable());
            }
        }
    }

    @Test
    public void testMetaData() {
        Assume.assumeFalse((boolean)this.named);
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            long robIndex;
            try (DocumentContext dc = appender.writingDocument(true);){
                dc.wire().write((CharSequence)"FirstName").text("Quartilla");
            }
            dc = appender.writingDocument();
            var6_10 = null;
            try {
                dc.wire().write((CharSequence)"FirstName").text("Rob");
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_10 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = appender.writingDocument(true);
            var6_10 = null;
            try {
                dc.wire().write((CharSequence)"FirstName").text("Steve");
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_10 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            StringBuilder event = new StringBuilder();
            while (true) {
                DocumentContext dc = tailer.readingDocument(true);
                Throwable throwable = null;
                try {
                    Assert.assertTrue((boolean)dc.isMetaData());
                    ValueIn in = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in.text((Object)"Quartilla", Assert::assertEquals);
                }
                catch (Throwable in) {
                    throwable = in;
                    throw in;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            try (DocumentContext dc = tailer.readingDocument(true);){
                Assert.assertTrue((boolean)dc.isData());
                robIndex = dc.index();
                dc.wire().read("FirstName").text((Object)"Rob", Assert::assertEquals);
            }
            while (true) {
                dc = tailer.readingDocument(true);
                var10_27 = null;
                try {
                    Assert.assertTrue((boolean)dc.isMetaData());
                    ValueIn in = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in.text((Object)"Steve", Assert::assertEquals);
                }
                catch (Throwable throwable) {
                    var10_27 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc == null) continue;
                    if (var10_27 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_27.addSuppressed(throwable);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            Assert.assertTrue((boolean)tailer.moveToIndex(robIndex));
            dc = tailer.readingDocument(false);
            var10_27 = null;
            try {
                Assert.assertTrue((boolean)dc.isData());
                dc.wire().read("FirstName").text((Object)"Rob", Assert::assertEquals);
            }
            catch (Throwable throwable) {
                var10_27 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_27 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_27.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReadingSecondDocumentNotExist() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"FirstName").text("Quartilla");
            }
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            try (DocumentContext dc = tailer.readingDocument();){
                String text = dc.wire().read("FirstName").text();
                Assert.assertEquals((Object)"Quartilla", (Object)text);
            }
            dc = tailer.readingDocument();
            var7_13 = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var7_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testDocumentIndexTest() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                long index = dc.index();
                Assert.assertEquals((long)0L, (long)chronicle.rollCycle().toSequenceNumber(index));
                dc.wire().write((CharSequence)"FirstName").text("Quartilla");
            }
            dc = appender.writingDocument();
            var6_10 = null;
            try {
                Assert.assertEquals((long)1L, (long)chronicle.rollCycle().toSequenceNumber(dc.index()));
                dc.wire().write((CharSequence)"FirstName").text("Rob");
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_10 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = appender.writingDocument();
            var6_10 = null;
            try {
                Assert.assertEquals((long)2L, (long)chronicle.rollCycle().toSequenceNumber(dc.index()));
                dc.wire().write((CharSequence)"FirstName").text("Rob");
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_10 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            try (DocumentContext dc = tailer.readingDocument();){
                long index = dc.index();
                Assert.assertEquals((long)0L, (long)chronicle.rollCycle().toSequenceNumber(index));
            }
            dc = tailer.readingDocument();
            var7_18 = null;
            try {
                Assert.assertEquals((long)1L, (long)chronicle.rollCycle().toSequenceNumber(dc.index()));
            }
            catch (Throwable throwable) {
                var7_18 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_18 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_18.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var7_18 = null;
            try {
                Assert.assertEquals((long)2L, (long)chronicle.rollCycle().toSequenceNumber(dc.index()));
            }
            catch (Throwable throwable) {
                var7_18 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_18 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_18.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReadingSecondDocumentNotExistIncludingMeta() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            Throwable throwable;
            DocumentContext dc;
            try (DocumentContext dc2 = appender.writingDocument();){
                dc2.wire().write((CharSequence)"FirstName").text("Quartilla");
            }
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            StringBuilder event = new StringBuilder();
            while (true) {
                dc = tailer.readingDocument(true);
                throwable = null;
                try {
                    ValueIn in = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in.text((Object)"Quartilla", Assert::assertEquals);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleByteTest() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST2_DAILY).build();
             ExcerptAppender appender = chronicle.createAppender();){
            VanillaBytes steve = Bytes.allocateDirect((byte[])"Steve".getBytes());
            appender.writeBytes((Bytes)steve);
            VanillaBytes jobs = Bytes.allocateDirect((byte[])"Jobs".getBytes());
            appender.writeBytes((Bytes)jobs);
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            Bytes bytes = Bytes.elasticByteBuffer();
            try {
                tailer.readBytes(bytes);
                Assert.assertEquals((Object)"Steve", (Object)bytes.toString());
                bytes.clear();
                tailer.readBytes(bytes);
                Assert.assertEquals((Object)"Jobs", (Object)bytes.toString());
            }
            finally {
                steve.releaseLast();
                jobs.releaseLast();
                bytes.releaseLast();
            }
        }
    }

    @Test
    public void testReadAtIndex() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).indexCount(8).indexSpacing(8).build();
             ExcerptAppender appender = queue.createAppender();){
            int i = 0;
            while (i < 100) {
                int j = i++;
                try (DocumentContext context = appender.writingDocument();){
                    context.wire().write((CharSequence)"key").text("value=" + j);
                }
            }
            long lastIndex = appender.lastIndexAppended();
            int cycle = queue.rollCycle().toCycle(lastIndex);
            Assert.assertEquals((long)queue.firstCycle(), (long)cycle);
            Assert.assertEquals((long)queue.lastCycle(), (long)cycle);
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            StringBuilder sb = new StringBuilder();
            for (int i2 : new int[]{0, 8, 7, 9, 64, 65, 66}) {
                long index = queue.rollCycle().toIndex(cycle, (long)i2);
                Assert.assertTrue((String)("i: " + i2), (boolean)tailer.moveToIndex(index));
                try (DocumentContext context = tailer.readingDocument();){
                    Assert.assertEquals((long)index, (long)context.index());
                    context.wire().read("key").text(sb);
                    Assert.assertEquals((Object)("value=" + i2), (Object)sb.toString());
                }
            }
        }
    }

    @Ignore(value="long running test")
    @Test
    public void testReadAtIndex4MB() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder((File)this.getTmpDir(), (WireType)this.wireType).rollCycle((RollCycle)SparseRollCycles.SMALL_DAILY).build();
             ExcerptAppender appender = queue.createAppender();){
            long i = 0L;
            while (i < 0x400000L) {
                long j = i++;
                appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=" + j));
            }
            long lastIndex = appender.lastIndexAppended();
            int cycle = queue.rollCycle().toCycle(lastIndex);
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            StringBuilder sb = new StringBuilder();
            for (long i2 = 0L; i2 < 0x400000L; ++i2) {
                Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, i2)));
                tailer.readDocument(wire -> wire.read("key").text(sb));
                Assert.assertEquals((Object)("value=" + i2), (Object)sb.toString());
            }
        }
    }

    @Test
    public void testMetaIndexTest() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue q = this.builderWithAppendListener(tmpDir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();
             ExcerptAppender appender = q.createAppender();){
            try (DocumentContext documentContext = appender.writingDocument();){
                documentContext.wire().getValueOut().text("one");
            }
            documentContext = appender.writingDocument();
            var7_11 = null;
            try {
                documentContext.wire().getValueOut().text("two");
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var7_11 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            documentContext = appender.writingDocument(true);
            var7_11 = null;
            try {
                documentContext.wire().getValueOut().text("meta1");
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var7_11 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            documentContext = appender.writingDocument();
            var7_11 = null;
            try {
                documentContext.wire().getValueOut().text("three");
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var7_11 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            documentContext = appender.writingDocument(true);
            var7_11 = null;
            try {
                documentContext.wire().getValueOut().text("meta2");
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var7_11 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            documentContext = appender.writingDocument(true);
            var7_11 = null;
            try {
                documentContext.wire().getValueOut().text("meta3");
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var7_11 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            documentContext = appender.writingDocument();
            var7_11 = null;
            try {
                documentContext.wire().getValueOut().text("four");
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var7_11 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            ExcerptTailer tailer = q.createTailer(this.named ? "named" : null);
            try (DocumentContext documentContext2 = tailer.readingDocument();){
                Assert.assertEquals((long)0L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertFalse((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"one", (Object)documentContext2.wire().getValueIn().text());
            }
            documentContext2 = tailer.readingDocument(true);
            var8_16 = null;
            try {
                Assert.assertEquals((long)1L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertFalse((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"two", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
            documentContext2 = tailer.readingDocument(true);
            var8_16 = null;
            try {
                Assert.assertEquals((long)2L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertTrue((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"meta1", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
            documentContext2 = tailer.readingDocument(true);
            var8_16 = null;
            try {
                Assert.assertEquals((long)2L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertFalse((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"three", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
            documentContext2 = tailer.readingDocument(true);
            var8_16 = null;
            try {
                Assert.assertEquals((long)3L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertTrue((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"meta2", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
            documentContext2 = tailer.readingDocument(true);
            var8_16 = null;
            try {
                Assert.assertEquals((long)3L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertTrue((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"meta3", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
            documentContext2 = tailer.readingDocument(true);
            var8_16 = null;
            try {
                Assert.assertEquals((long)3L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertFalse((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"four", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
            tailer = q.createTailer(this.named ? "named2" : null);
            documentContext2 = tailer.readingDocument();
            var8_16 = null;
            try {
                Assert.assertEquals((long)0L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertFalse((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"one", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
            documentContext2 = tailer.readingDocument(false);
            var8_16 = null;
            try {
                Assert.assertEquals((long)1L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertFalse((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"two", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
            documentContext2 = tailer.readingDocument(false);
            var8_16 = null;
            try {
                Assert.assertEquals((long)2L, (long)this.toSeq((ChronicleQueue)q, documentContext2.index()));
                Assert.assertFalse((boolean)documentContext2.isMetaData());
                Assert.assertEquals((Object)"three", (Object)documentContext2.wire().getValueIn().text());
            }
            catch (Throwable throwable) {
                var8_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext2 != null) {
                    if (var8_16 != null) {
                        try {
                            documentContext2.close();
                        }
                        catch (Throwable throwable) {
                            var8_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext2.close();
                    }
                }
            }
        }
        Assert.assertEquals((Object)"idx: 6f06c00000000\n# position: 65808, header: 0\n--- !!data #binary\none\n\nidx: 6f06c00000001\n# position: 65816, header: 0\n--- !!data #binary\ntwo\n\nidx: 6f06c00000002\n# position: 65836, header: 0\n--- !!data #binary\nthree\n\nidx: 6f06c00000003\n# position: 65872, header: 0\n--- !!data #binary\nfour\n\n", (Object)this.appenderListenerDump.toString());
    }

    @Test
    public void testLastWrittenIndexPerAppender() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeDocument(wire -> wire.write((CharSequence)"key").text("test"));
            Assert.assertEquals((long)0L, (long)queue.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testLastWrittenIndexPerAppenderNoData() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.lastIndexAppended();
            Assert.fail();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testNoMessagesWritten() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.lastIndexAppended();
        }
    }

    @Test
    public void testHeaderIndexReadAtIndex() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            int cycle = appender.cycle();
            int i = 0;
            while (i < 100) {
                int j = i++;
                appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=" + j));
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, 0L)));
            StringBuilder sb = new StringBuilder();
            tailer.readDocument(wire -> wire.read("key").text(sb));
            Assert.assertEquals((Object)"value=0", (Object)sb.toString());
        }
    }

    @Test
    public void testEPOC() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).epoch(System.currentTimeMillis()).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=v"));
            Assert.assertEquals((long)0L, (long)appender.cycle());
        }
    }

    @Test
    public void shouldBeAbleToReadFromQueueWithNonZeroEpoch() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).epoch(System.currentTimeMillis()).rollCycle((RollCycle)RollCycles.DEFAULT).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=v"));
            Assert.assertEquals((long)0L, (long)appender.cycle());
            ExcerptTailer excerptTailer = chronicle.createTailer(this.named ? "named" : null).toStart();
            Assert.assertTrue((boolean)excerptTailer.readingDocument().isPresent());
        }
    }

    @Test
    public void shouldHandleLargeEpoch() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).epoch(System.currentTimeMillis()).epoch(1284739200000L).rollCycle((RollCycle)RollCycles.DEFAULT).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=v"));
            ExcerptTailer excerptTailer = chronicle.createTailer(this.named ? "named" : null).toStart();
            Assert.assertTrue((boolean)excerptTailer.readingDocument().isPresent());
        }
    }

    @Test
    public void testNegativeEPOC() {
        for (int h = -14; h <= 14; ++h) {
            try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).epoch(TimeUnit.HOURS.toMillis(h)).build();
                 ExcerptAppender appender = chronicle.createAppender();){
                appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=v"));
                chronicle.createTailer(this.named ? "named" : null).readDocument(wire -> Assert.assertEquals((Object)"value=v", (Object)wire.read("key").text()));
                continue;
            }
        }
    }

    @Test
    public void testIndex() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();
             ExcerptAppender appender = queue.createAppender();){
            int cycle = appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int j = i;
                appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=" + j));
                if (i != 2) continue;
                long cycle1 = queue.rollCycle().toCycle(appender.lastIndexAppended());
                Assert.assertEquals((long)cycle1, (long)cycle);
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, 2L)));
            StringBuilder sb = new StringBuilder();
            tailer.readDocument(wire -> wire.read("key").text(sb));
            Assert.assertEquals((Object)"value=2", (Object)sb.toString());
            tailer.readDocument(wire -> wire.read("key").text(sb));
            Assert.assertEquals((Object)"value=3", (Object)sb.toString());
            tailer.readDocument(wire -> wire.read("key").text(sb));
            Assert.assertEquals((Object)"value=4", (Object)sb.toString());
        }
    }

    @Test
    public void testReadingDocument() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();
             ExcerptAppender appender = queue.createAppender();){
            long cycle = appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int j = i;
                appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=" + j));
                if (i != 2) continue;
                long cycle1 = queue.rollCycle().toCycle(appender.lastIndexAppended());
                Assert.assertEquals((long)cycle1, (long)cycle);
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            StringBuilder sb = new StringBuilder();
            try (DocumentContext dc = tailer.readingDocument();){
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=0", (Object)sb.toString());
            }
            dc = tailer.readingDocument();
            var10_16 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=1", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var10_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var10_16 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=2", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var10_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var10_16 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=3", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var10_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var10_16 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=4", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var10_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var10_16 = null;
            try {
                assert (!dc.isPresent());
                assert (!dc.isData());
                assert (!dc.isMetaData());
            }
            catch (Throwable throwable) {
                var10_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReadingDocumentWithFirstAMove() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();
             ExcerptAppender appender = queue.createAppender();){
            int cycle = appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int j = i;
                appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=" + j));
                if (i != 2) continue;
                long cycle1 = queue.rollCycle().toCycle(appender.lastIndexAppended());
                Assert.assertEquals((long)cycle1, (long)cycle);
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, 2L)));
            StringBuilder sb = new StringBuilder();
            try (DocumentContext dc = tailer.readingDocument();){
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=2", (Object)sb.toString());
            }
            dc = tailer.readingDocument();
            var9_16 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=3", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var9_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var9_16 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=4", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var9_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var9_16 = null;
            try {
                assert (!dc.isPresent());
                assert (!dc.isData());
                assert (!dc.isMetaData());
            }
            catch (Throwable throwable) {
                var9_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReadingDocumentWithFirstAMoveWithEpoch() {
        Instant hourly = Instant.parse("2018-02-12T00:59:59.999Z");
        Instant minutely = Instant.parse("2018-02-12T00:00:59.999Z");
        Date epochHourlyFirstCycle = Date.from(hourly);
        Date epochMinutelyFirstCycle = Date.from(minutely);
        Date epochHourlySecondCycle = Date.from(hourly.plusMillis(1L));
        Date epochMinutelySecondCycle = Date.from(minutely.plusMillis(1L));
        this.doTestEpochMove(epochHourlyFirstCycle.getTime(), (RollCycle)LegacyRollCycles.MINUTELY);
        this.doTestEpochMove(epochHourlySecondCycle.getTime(), (RollCycle)LegacyRollCycles.MINUTELY);
        this.doTestEpochMove(epochHourlyFirstCycle.getTime(), (RollCycle)LegacyRollCycles.HOURLY);
        this.doTestEpochMove(epochHourlySecondCycle.getTime(), (RollCycle)LegacyRollCycles.HOURLY);
        this.doTestEpochMove(epochHourlyFirstCycle.getTime(), (RollCycle)LegacyRollCycles.DAILY);
        this.doTestEpochMove(epochHourlySecondCycle.getTime(), (RollCycle)LegacyRollCycles.DAILY);
        this.doTestEpochMove(epochMinutelyFirstCycle.getTime(), (RollCycle)LegacyRollCycles.MINUTELY);
        this.doTestEpochMove(epochMinutelySecondCycle.getTime(), (RollCycle)LegacyRollCycles.MINUTELY);
        this.doTestEpochMove(epochMinutelyFirstCycle.getTime(), (RollCycle)LegacyRollCycles.HOURLY);
        this.doTestEpochMove(epochMinutelySecondCycle.getTime(), (RollCycle)LegacyRollCycles.HOURLY);
        this.doTestEpochMove(epochMinutelyFirstCycle.getTime(), (RollCycle)LegacyRollCycles.DAILY);
        this.doTestEpochMove(epochMinutelySecondCycle.getTime(), (RollCycle)LegacyRollCycles.DAILY);
    }

    private void doTestEpochMove(long epoch, RollCycle rollCycle) {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle(rollCycle).epoch(epoch).build();
             ExcerptAppender appender = queue.createAppender();){
            int cycle = appender.cycle();
            int last = 4;
            for (int i = 0; i <= last; ++i) {
                long cycle1;
                int j = i;
                appender.writeDocument(wire -> wire.write((CharSequence)"key").text("value=" + j));
                if (i != last || (long)(cycle + 1) == (cycle1 = (long)queue.rollCycle().toCycle(appender.lastIndexAppended()))) continue;
                Assert.assertEquals((long)cycle, (long)cycle1);
            }
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, 2L)));
            StringBuilder sb = new StringBuilder();
            try (DocumentContext dc = tailer.readingDocument();){
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=2", (Object)sb.toString());
            }
            dc = tailer.readingDocument();
            var13_19 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=3", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var13_19 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var13_19 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var13_19.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var13_19 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read("key").text(sb);
                Assert.assertEquals((Object)"value=4", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var13_19 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var13_19 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var13_19.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var13_19 = null;
            try {
                assert (!dc.isPresent());
                assert (!dc.isData());
                assert (!dc.isMetaData());
            }
            catch (Throwable throwable) {
                var13_19 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var13_19 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var13_19.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testAppendedBeforeToEnd() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue chronicle = this.builder(dir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();
             SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();
             ExcerptAppender append = chronicle2.createAppender();){
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            append.writeDocument(w -> w.write((CharSequence)"test").text("text"));
            while (tailer.state() == TailerState.UNINITIALISED) {
                tailer.toEnd();
            }
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((String)(tailer.index() + " " + tailer.state()), (boolean)dc.isPresent());
            }
            append.writeDocument(w -> w.write((CharSequence)"test").text("text2"));
            dc = tailer.readingDocument();
            var10_16 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"text2", (Object)dc.wire().read("test").text());
            }
            catch (Throwable throwable) {
                var10_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReentrant() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.binary(tmpDir).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_DAILY).timeProvider((TimeProvider)new SetTimeProvider("2020/10/19T01:01:01")).build();
             ExcerptAppender appender = queue.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"some").text("data");
                try (DocumentContext dc2 = appender.writingDocument();){
                    dc2.wire().write((CharSequence)"some2").text("other");
                }
                Assert.assertTrue((boolean)dc.isOpen());
            }
            Assert.assertEquals((Object)("--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    sourceId: 0\n  }\n}\n--- !!data #binary\nlisting.highestCycle: 18554\n--- !!data #binary\nlisting.lowestCycle: 18554\n--- !!data #binary\nlisting.modCount: 3\n" + this.queueLockForTestReentrant() + "--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    400,\n    1717986918400\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  400,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nsome: data\nsome2: other\n...\n"), (Object)SingleChronicleQueueTest.tidyDump((ChronicleQueue)queue));
        }
    }

    protected String queueLockForTestReentrant() {
        return "";
    }

    @Test
    public void testToEnd() throws InterruptedException {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(dir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();){
            Throwable throwable;
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            tailer.toEnd();
            try (SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();){
                throwable = null;
                try (ExcerptAppender append = chronicle2.createAppender();){
                    append.writeDocument(w -> w.write((CharSequence)"test").text("text"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            Thread.sleep(1L);
            var6_8 = null;
            try (DocumentContext dc = tailer.readingDocument();){
                throwable = null;
                try (SingleChronicleQueue build = this.builder(dir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();){
                    String message = "dump: " + build.dump();
                    Assert.assertTrue((String)message, (boolean)dc.isPresent());
                    Assert.assertEquals((String)message, (Object)"text", (Object)dc.wire().read("test").text());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var6_8 = throwable4;
                throw throwable4;
            }
        }
    }

    @Test
    public void testToEnd2() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue chronicle = this.builder(dir, this.wireType).build();
             SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).build();
             ExcerptAppender append = chronicle2.createAppender();){
            append.writeDocument(w -> w.write((CharSequence)"test").text("before text"));
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            tailer.toEnd();
            append.writeDocument(w -> w.write((CharSequence)"test").text("text"));
            Assert.assertTrue((boolean)tailer.readDocument(w -> w.read("test").text((Object)"text", Assert::assertEquals)));
        }
    }

    @Test
    public void testToEndOnDeletedQueueFiles() throws IOException {
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test delete after close on windows");
            return;
        }
        File dir = this.getTmpDir();
        try (SingleChronicleQueue q = this.builder(dir, this.wireType).build();
             ExcerptAppender append = q.createAppender();){
            append.writeDocument(w -> w.write((CharSequence)"test").text("before text"));
            ExcerptTailer tailer = q.createTailer(this.named ? "named" : null);
            tailer.toEnd();
            append.writeDocument(w -> w.write((CharSequence)"test").text("text"));
            Assert.assertTrue((boolean)tailer.readDocument(w -> w.read("test").text((Object)"text", Assert::assertEquals)));
            try (Stream<Path> cq4Files = Files.find(dir.toPath(), 1, (p, basicFileAttributes) -> p.toString().endsWith("cq4"), FileVisitOption.FOLLOW_LINKS);){
                List unDeletable = cq4Files.filter(path -> !path.toFile().delete()).collect(Collectors.toList());
                Assert.assertTrue((String)("Unable to delete" + unDeletable), (boolean)unDeletable.isEmpty());
            }
            var8_12 = null;
            try (SingleChronicleQueue q2 = this.builder(dir, this.wireType).build();
                 ExcerptAppender q2Appender = q2.createAppender();){
                tailer = q2.createTailer(this.named ? "named" : null);
                tailer.toEnd();
                Assert.assertEquals((Object)TailerState.UNINITIALISED, (Object)tailer.state());
                q2Appender.writeDocument(w -> w.write((CharSequence)"test").text("before text"));
                Assert.assertTrue((boolean)tailer.readDocument(w -> w.read("test").text((Object)"before text", Assert::assertEquals)));
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testReadWrite() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue chronicle = this.builder(dir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).testBlockSize().build();
             SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).testBlockSize().build();
             ExcerptAppender append = chronicle2.createAppender();){
            int runs = 50000;
            for (int i = 0; i < runs; ++i) {
                append.writeDocument(w -> w.write((CharSequence)"test - message").text("text"));
            }
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named1" : null);
            ExcerptTailer tailer2 = chronicle.createTailer(this.named ? "named2" : null);
            ExcerptTailer tailer3 = chronicle.createTailer(this.named ? "named3" : null);
            ExcerptTailer tailer4 = chronicle.createTailer(this.named ? "named4" : null);
            for (int i = 0; i < runs; ++i) {
                if (i % 10000 == 0) {
                    System.gc();
                }
                if (i % 2 == 0) {
                    Assert.assertTrue((boolean)tailer2.readDocument(w -> w.read("test - message").text((Object)"text", Assert::assertEquals)));
                }
                if (i % 3 == 0) {
                    Assert.assertTrue((boolean)tailer3.readDocument(w -> w.read("test - message").text((Object)"text", Assert::assertEquals)));
                }
                if (i % 4 == 0) {
                    Assert.assertTrue((boolean)tailer4.readDocument(w -> w.read("test - message").text((Object)"text", Assert::assertEquals)));
                }
                Assert.assertTrue((boolean)tailer.readDocument(w -> w.read("test - message").text((Object)"text", Assert::assertEquals)));
            }
        }
    }

    @Test
    public void testReadingDocumentForEmptyQueue() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue chronicle = this.builder(dir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();){
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
            var6_8 = null;
            try (SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();
                 ExcerptAppender appender = chronicle2.createAppender();){
                appender.writeDocument(w -> w.write((CharSequence)"test - message").text("text"));
                while (tailer.state() == TailerState.UNINITIALISED) {
                    tailer.toStart();
                }
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertTrue((boolean)dc.isPresent());
                    dc.wire().read("test - message").text((Object)"text", Assert::assertEquals);
                }
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testMetaData6() {
        Assume.assumeFalse((boolean)this.named);
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST2_DAILY).timeProvider((TimeProvider)new SetTimeProvider("2020/10/19T01:01:01")).build();
             ExcerptAppender appender = chronicle.createAppender();){
            ValueIn in2;
            Throwable throwable;
            DocumentContext dc;
            try (DocumentContext dc2 = appender.writingDocument(true);){
                dc2.wire().write((CharSequence)"FirstName").text("Quartilla");
            }
            dc2 = appender.writingDocument();
            var6_10 = null;
            try {
                Assert.assertFalse((boolean)dc2.isMetaData());
                dc2.wire().write((CharSequence)"FirstName").text("Helen");
            }
            catch (Throwable throwable2) {
                var6_10 = throwable2;
                throw throwable2;
            }
            finally {
                if (dc2 != null) {
                    if (var6_10 != null) {
                        try {
                            dc2.close();
                        }
                        catch (Throwable throwable3) {
                            var6_10.addSuppressed(throwable3);
                        }
                    } else {
                        dc2.close();
                    }
                }
            }
            dc2 = appender.writingDocument(true);
            var6_10 = null;
            try {
                dc2.wire().write((CharSequence)"FirstName").text("Steve");
            }
            catch (Throwable throwable4) {
                var6_10 = throwable4;
                throw throwable4;
            }
            finally {
                if (dc2 != null) {
                    if (var6_10 != null) {
                        try {
                            dc2.close();
                        }
                        catch (Throwable throwable5) {
                            var6_10.addSuppressed(throwable5);
                        }
                    } else {
                        dc2.close();
                    }
                }
            }
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            StringBuilder event = new StringBuilder();
            while (true) {
                dc = tailer.readingDocument(true);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)dc.isMetaData());
                    in2 = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in2.text((Object)"Quartilla", Assert::assertEquals);
                }
                catch (Throwable in2) {
                    throwable = in2;
                    throw in2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            dc = tailer.readingDocument(true);
            throwable = null;
            try {
                Assert.assertTrue((boolean)dc.isData());
                Assert.assertTrue((boolean)dc.isPresent());
                dc.wire().read("FirstName").text((Object)"Helen", Assert::assertEquals);
            }
            catch (Throwable in2) {
                throwable = in2;
                throw in2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable in2) {
                            throwable.addSuppressed(in2);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            while (true) {
                dc = tailer.readingDocument(true);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)dc.isMetaData());
                    in2 = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in2.text((Object)"Steve", Assert::assertEquals);
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            Assert.assertEquals((Object)this.expectedMetaDataTest2(), (Object)SingleChronicleQueueTest.tidyDump((ChronicleQueue)chronicle));
        }
    }

    @NotNull
    protected String expectedMetaDataTest2() {
        if (this.wireType == WireType.BINARY || this.wireType == WireType.BINARY_LIGHT) {
            return "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T2', epoch: 0 },\n    sourceId: 0\n  }\n}\n--- !!data #binary\nlisting.highestCycle: 18554\n--- !!data #binary\nlisting.lowestCycle: 18554\n--- !!data #binary\nlisting.modCount: 4\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    552,\n    2370821947392\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 200,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  552,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nFirstName: Quartilla\n--- !!data #binary\nFirstName: Helen\n--- !!meta-data #binary\nFirstName: Steve\n...\n";
        }
        throw new IllegalStateException("unknown type " + this.wireType);
    }

    @Test
    public void testToEndBeforeWrite() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST2_DAILY).build();
             ExcerptAppender appender = chronicle.createAppender();
             ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);){
            int entries = chronicle.rollCycle().defaultIndexSpacing() * 2 + 2;
            int i = 0;
            while (i < entries) {
                tailer.toEnd();
                int finalI = i++;
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world" + finalI));
                tailer.readDocument(w -> w.read().text((Object)("world" + finalI), Assert::assertEquals));
            }
        }
    }

    @Test
    public void testForwardFollowedBackBackwardTailer() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST2_DAILY).build();
             ExcerptAppender appender = chronicle.createAppender();){
            int entries = chronicle.rollCycle().defaultIndexSpacing() + 2;
            int i = 0;
            while (i < entries) {
                int finalI = i++;
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world" + finalI));
            }
            for (i = 0; i < 3; ++i) {
                this.readForward((ChronicleQueue)chronicle, entries);
                this.readBackward((ChronicleQueue)chronicle, entries);
            }
        }
    }

    @Test
    public void shouldReadBackwardFromEndOfQueueWhenDirectionIsSetAfterMoveToEnd() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST2_DAILY).build();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world"));
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            tailer.toEnd();
            tailer.direction(TailerDirection.BACKWARD);
            Assert.assertTrue((boolean)tailer.readingDocument().isPresent());
        }
    }

    void readForward(@NotNull ChronicleQueue chronicle, int entries) {
        try (ExcerptTailer forwardTailer = chronicle.createTailer(this.named ? "named" : null).direction(TailerDirection.FORWARD).toStart();){
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < entries; ++i) {
                try (DocumentContext documentContext = forwardTailer.readingDocument();){
                    Assert.assertTrue((boolean)documentContext.isPresent());
                    Assert.assertEquals((long)i, (long)RollCycles.DEFAULT.toSequenceNumber(documentContext.index()));
                    sb.setLength(0);
                    ValueIn valueIn = documentContext.wire().readEventName(sb);
                    Assert.assertTrue((boolean)"hello".contentEquals(sb));
                    String actual = valueIn.text();
                    Assert.assertEquals((Object)("world" + i), (Object)actual);
                    continue;
                }
            }
            try (DocumentContext documentContext = forwardTailer.readingDocument();){
                Assert.assertFalse((boolean)documentContext.isPresent());
            }
        }
    }

    void readBackward(@NotNull ChronicleQueue chronicle, int entries) {
        ExcerptTailer backwardTailer = chronicle.createTailer(this.named ? "named" : null).direction(TailerDirection.BACKWARD).toEnd();
        StringBuilder sb = new StringBuilder();
        for (int i = entries - 1; i >= 0; --i) {
            try (DocumentContext documentContext = backwardTailer.readingDocument();){
                Assert.assertTrue((boolean)documentContext.isPresent());
                long index = documentContext.index();
                Assert.assertEquals((String)("index: " + index), (long)i, (long)((int)index));
                Assert.assertEquals((long)i, (long)RollCycles.DEFAULT.toSequenceNumber(index));
                Assert.assertTrue((boolean)documentContext.isPresent());
                sb.setLength(0);
                ValueIn valueIn = documentContext.wire().readEventName(sb);
                Assert.assertTrue((boolean)"hello".contentEquals(sb));
                String actual = valueIn.text();
                Assert.assertEquals((Object)("world" + i), (Object)actual);
                continue;
            }
        }
        try (DocumentContext documentContext = backwardTailer.readingDocument();){
            Assert.assertFalse((boolean)documentContext.isPresent());
        }
    }

    @Test
    public void testOverreadForwardFromFutureCycleThenReadBackwardTailer() {
        TestRollCycles cycle = TestRollCycles.TEST2_DAILY;
        AtomicBoolean forwardToFuture = new AtomicBoolean(false);
        TimeProvider timeProvider = () -> forwardToFuture.get() ? System.currentTimeMillis() + TimeUnit.MILLISECONDS.toDays(1L) : System.currentTimeMillis();
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)cycle).timeProvider(timeProvider).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world"));
            forwardToFuture.set(true);
            ExcerptTailer forwardTailer = chronicle.createTailer(this.named ? "named" : null).direction(TailerDirection.FORWARD).toStart();
            try (DocumentContext context = forwardTailer.readingDocument();){
                Assert.assertTrue((boolean)context.isPresent());
            }
            context = forwardTailer.readingDocument();
            var10_14 = null;
            try {
                Assert.assertFalse((boolean)context.isPresent());
            }
            catch (Throwable throwable) {
                var10_14 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var10_14 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var10_14.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            ExcerptTailer backwardTailer = chronicle.createTailer(this.named ? "named" : null).direction(TailerDirection.BACKWARD).toEnd();
            try (DocumentContext context = backwardTailer.readingDocument();){
                Assert.assertTrue((boolean)context.isPresent());
            }
        }
    }

    @Test
    public void testSomeMessages() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST2_DAILY).build();
             ExcerptAppender appender = chronicle.createAppender();){
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            int entries = chronicle.rollCycle().defaultIndexSpacing() * 2 + 2;
            for (long i = 0L; i < (long)entries; ++i) {
                long finalI = i;
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").int64(finalI));
                long seq = chronicle.rollCycle().toSequenceNumber(appender.lastIndexAppended());
                Assert.assertEquals((long)i, (long)seq);
                tailer.readDocument(w -> w.read().int64((Object)finalI, (a, b) -> Assert.assertEquals((long)a, (long)b)));
            }
        }
    }

    @Test
    public void testZeroLengthMessage() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.writeDocument(w -> {});
            ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((boolean)dc.wire().hasMore());
            }
        }
    }

    @Test
    public void testMoveToWithAppender() {
        try (SingleChronicleQueue syncQ = this.builder(this.getTmpDir(), this.wireType).build();
             InternalAppender sync = (InternalAppender)syncQ.createAppender();){
            File name2 = this.getTmpDir();
            try (SingleChronicleQueue chronicle = this.builder(name2, this.wireType).build();
                 ExcerptAppender appender = chronicle.createAppender();){
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world0"));
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world1"));
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world2"));
                ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
                try (DocumentContext documentContext = tailer.readingDocument();){
                    sync.writeBytes(documentContext.index(), (BytesStore)documentContext.wire().bytes());
                }
                documentContext = tailer.readingDocument();
                var12_20 = null;
                try {
                    String text = documentContext.wire().read().text();
                    Assert.assertEquals((Object)"world1", (Object)text);
                }
                catch (Throwable throwable) {
                    var12_20 = throwable;
                    throw throwable;
                }
                finally {
                    if (documentContext != null) {
                        if (var12_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable) {
                                var12_20.addSuppressed(throwable);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testMapWrapper() {
        try (SingleChronicleQueue syncQ = this.builder(this.getTmpDir(), this.wireType).build();){
            File name2 = this.getTmpDir();
            try (SingleChronicleQueue chronicle = this.builder(name2, this.wireType).build();
                 ExcerptAppender appender = chronicle.createAppender();){
                MapWrapper myMap = new MapWrapper();
                myMap.map.put("hello", 1.2);
                appender.writeDocument(w -> w.write().object((Object)myMap));
                ExcerptTailer tailer = chronicle.createTailer(this.named ? "named" : null);
                try (DocumentContext documentContext = tailer.readingDocument();){
                    MapWrapper object = (MapWrapper)((Object)documentContext.wire().read().object(MapWrapper.class));
                    Assert.assertEquals((double)1.2, (double)object.map.get("hello"), (double)0.0);
                }
            }
        }
    }

    @Test
    public void testLastIndexAppended() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = chronicle.createAppender();){
            appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world0"));
            long nextIndexToWrite = appender.lastIndexAppended() + 1L;
            appender.writeDocument(w -> w.getValueOut().bytes(new byte[0]));
            Assert.assertEquals((long)nextIndexToWrite, (long)appender.lastIndexAppended());
        }
    }

    @Test
    public void testAppendedSkipToEndMultiThreaded() throws InterruptedException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            sb.append(UUID.randomUUID());
        }
        String text = sb.toString();
        try (SingleChronicleQueue q = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();){
            System.err.println(q.file());
            int size = 50000;
            int threadCount = 8;
            int sizePerThread = size / threadCount;
            CountDownLatch latch = new CountDownLatch(threadCount);
            for (int j = 0; j < threadCount; ++j) {
                new Thread(() -> this.lambda$testAppendedSkipToEndMultiThreaded$85((ChronicleQueue)q, sizePerThread, text, latch)).start();
            }
            latch.await();
            ExcerptTailer tailer = q.createTailer(this.named ? "named" : null);
            for (int i = 0; i < size; ++i) {
                try (DocumentContext dc = tailer.readingDocument(false);){
                    long index = dc.index();
                    long actual = dc.wire().read("key").int64();
                    Assert.assertEquals((Object)this.toTextIndex((ChronicleQueue)q, index), (Object)this.toTextIndex((ChronicleQueue)q, actual));
                    continue;
                }
            }
        }
    }

    @NotNull
    private String toTextIndex(ChronicleQueue q, long index) {
        return Long.toHexString(q.rollCycle().toCycle(index)) + "_" + Long.toHexString(q.rollCycle().toSequenceNumber(index));
    }

    @Test
    public void testAppendedSkipToEnd() {
        try (SingleChronicleQueue q = this.builder(this.getTmpDir(), this.wireType).build();
             ExcerptAppender appender = q.createAppender();
             ExcerptAppender appender2 = q.createAppender();){
            int indexCount = 100;
            for (int i = 0; i < indexCount; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().write((CharSequence)"key").text("some more 1");
                }
                Assert.assertEquals((long)i, (long)q.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
            }
            try (DocumentContext dc = appender2.writingDocument();){
                dc.wire().write((CharSequence)"key").text("some data " + indexCount);
            }
            Assert.assertEquals((long)indexCount, (long)q.rollCycle().toSequenceNumber(appender2.lastIndexAppended()));
        }
    }

    @Test
    public void testToEndPrevCycleEOF() {
        ExcerptTailer tailer2;
        Throwable throwable;
        ExcerptAppender appender;
        AtomicLong clock = new AtomicLong(System.currentTimeMillis());
        File dir = this.getTmpDir();
        try (SingleChronicleQueue q = this.builder(dir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider(clock::get).build();){
            appender = q.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"first");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        AbstractCloseable.assertCloseablesClosed();
        clock.addAndGet(1100L);
        q = this.builder(dir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider(clock::get).build();
        var4_4 = null;
        try {
            tailer2 = q.createTailer(this.named ? "named" : null);
            Assert.assertEquals((Object)"first", (Object)tailer2.readText());
            Assert.assertNull((Object)tailer2.readText());
        }
        catch (Throwable tailer2) {
            var4_4 = tailer2;
            throw tailer2;
        }
        finally {
            if (q != null) {
                if (var4_4 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable tailer2) {
                        var4_4.addSuppressed(tailer2);
                    }
                } else {
                    q.close();
                }
            }
        }
        AbstractCloseable.assertCloseablesClosed();
        q = this.builder(dir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider(clock::get).build();
        var4_4 = null;
        try {
            tailer2 = q.createTailer(this.named ? "named" : null).toEnd();
            try (DocumentContext documentContext = tailer2.readingDocument();){
                Assert.assertFalse((boolean)documentContext.isPresent());
            }
            documentContext = tailer2.readingDocument();
            var7_17 = null;
            try {
                Assert.assertFalse((boolean)documentContext.isPresent());
            }
            catch (Throwable throwable4) {
                var7_17 = throwable4;
                throw throwable4;
            }
            finally {
                if (documentContext != null) {
                    if (var7_17 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable5) {
                            var7_17.addSuppressed(throwable5);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
        }
        catch (Throwable tailer3) {
            var4_4 = tailer3;
            throw tailer3;
        }
        finally {
            if (q != null) {
                if (var4_4 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable tailer3) {
                        var4_4.addSuppressed(tailer3);
                    }
                } else {
                    q.close();
                }
            }
        }
        AbstractCloseable.assertCloseablesClosed();
        clock.addAndGet(50L);
        q = this.builder(dir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider(clock::get).build();
        var4_4 = null;
        try {
            appender = q.createAppender();
            throwable = null;
            try {
                ExcerptTailer excerptTailerBeforeAppend = q.createTailer(this.named ? "named" : null).toEnd();
                appender.writeText((CharSequence)"more text");
                ExcerptTailer excerptTailerAfterAppend = q.createTailer(this.named ? "named" : null).toEnd();
                appender.writeText((CharSequence)"even more text");
                Assert.assertEquals((Object)"more text", (Object)excerptTailerBeforeAppend.readText());
                Assert.assertEquals((Object)"even more text", (Object)excerptTailerAfterAppend.readText());
                Assert.assertEquals((Object)"even more text", (Object)excerptTailerBeforeAppend.readText());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        catch (Throwable throwable8) {
            var4_4 = throwable8;
            throw throwable8;
        }
        finally {
            if (q != null) {
                if (var4_4 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable throwable9) {
                        var4_4.addSuppressed(throwable9);
                    }
                } else {
                    q.close();
                }
            }
        }
        AbstractCloseable.assertCloseablesClosed();
    }

    @Ignore(value="Long Running Test")
    @Test
    public void testRandomConcurrentReadWrite() throws InterruptedException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            sb.append(UUID.randomUUID());
        }
        String text = sb.toString();
        for (int i = 0; i < 20; ++i) {
            ExecutorService executor = Executors.newWorkStealingPool(8);
            try (SingleChronicleQueue q = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)LegacyRollCycles.MINUTELY).build();){
                int size = 20000000;
                for (int j = 0; j < size; ++j) {
                    executor.execute(() -> this.lambda$testRandomConcurrentReadWrite$86((ChronicleQueue)q, text));
                }
                executor.shutdown();
                if (!executor.awaitTermination(10000L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
                Jvm.pause((long)1000L);
                continue;
            }
        }
    }

    @Test
    public void testTailerWhenCyclesWhereSkippedOnWrite() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider((TimeProvider)timeProvider).syncMode(SyncMode.SYNC).build();
             ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);){
            tailer.sync();
            try (ExcerptAppender appender = queue.createAppender();){
                appender.sync();
                List<String> stringsToPut = Arrays.asList("one", "two", "three");
                try (DocumentContext writingContext = appender.writingDocument();){
                    writingContext.wire().write().bytes(stringsToPut.get(0).getBytes());
                }
                appender.sync();
                writingContext = appender.writingDocument();
                var10_16 = null;
                try {
                    writingContext.wire().write().bytes(stringsToPut.get(1).getBytes());
                }
                catch (Throwable throwable) {
                    var10_16 = throwable;
                    throw throwable;
                }
                finally {
                    if (writingContext != null) {
                        if (var10_16 != null) {
                            try {
                                writingContext.close();
                            }
                            catch (Throwable throwable) {
                                var10_16.addSuppressed(throwable);
                            }
                        } else {
                            writingContext.close();
                        }
                    }
                }
                appender.sync();
                timeProvider.advanceMillis(2100L);
                writingContext = appender.writingDocument();
                var10_16 = null;
                try {
                    writingContext.wire().write().bytes(stringsToPut.get(2).getBytes());
                }
                catch (Throwable throwable) {
                    var10_16 = throwable;
                    throw throwable;
                }
                finally {
                    if (writingContext != null) {
                        if (var10_16 != null) {
                            try {
                                writingContext.close();
                            }
                            catch (Throwable throwable) {
                                var10_16.addSuppressed(throwable);
                            }
                        } else {
                            writingContext.close();
                        }
                    }
                }
                appender.sync();
                for (String expected : stringsToPut) {
                    try (DocumentContext readingContext = tailer.readingDocument();){
                        if (!readingContext.isPresent()) {
                            Assert.fail();
                        }
                        String text = readingContext.wire().read().text();
                        Assert.assertEquals((Object)expected, (Object)text);
                    }
                    tailer.sync();
                }
            }
        }
    }

    private void doSomething(@NotNull ExcerptAppender appender, @NotNull ExcerptTailer tailer, String text) {
        if (Math.random() > 0.5) {
            this.writeTestDocument(appender, text);
        } else {
            this.readDocument(tailer, text);
        }
    }

    private void readDocument(@NotNull ExcerptTailer tailer, String text) {
        try (DocumentContext dc = tailer.readingDocument();){
            if (!dc.isPresent()) {
                return;
            }
            Assert.assertEquals((long)dc.index(), (long)dc.wire().read("key").int64());
            Assert.assertEquals((Object)text, (Object)dc.wire().read("text").text());
        }
    }

    private void writeTestDocument(@NotNull ExcerptAppender appender, String text) {
        try (DocumentContext dc = appender.writingDocument();){
            long index = dc.index();
            dc.wire().write((CharSequence)"key").int64(index);
            dc.wire().write((CharSequence)"text").text(text);
        }
    }

    @Test
    public void testMultipleAppenders() {
        try (SingleChronicleQueue syncQ = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).timeProvider((TimeProvider)new SetTimeProvider("2020/10/19T01:01:01")).build();
             ExcerptAppender syncA = syncQ.createAppender();
             ExcerptAppender syncB = syncQ.createAppender();
             ExcerptAppender syncC = syncQ.createAppender();){
            int count = 0;
            for (int i = 0; i < 3; ++i) {
                syncA.writeText((CharSequence)("hello A" + i));
                Assert.assertEquals((long)count++, (long)((int)syncA.lastIndexAppended()));
                syncB.writeText((CharSequence)("hello B" + i));
                Assert.assertEquals((long)count++, (long)((int)syncB.lastIndexAppended()));
                try (DocumentContext dc = syncC.writingDocument(true);){
                    dc.wire().getValueOut().text("some meta " + i);
                    continue;
                }
            }
            String expected = this.expectedMultipleAppenders();
            Assert.assertEquals((Object)expected, (Object)SingleChronicleQueueTest.tidyDump((ChronicleQueue)syncQ));
        }
    }

    @NotNull
    private static String tidyDump(ChronicleQueue queue) {
        return queue.dump().replaceAll("(?m)^#.+$\\n", "").replaceAll("(\\n0000\\d+ ).*", "$1Binary");
    }

    @NotNull
    protected String expectedMultipleAppenders() {
        if (this.wireType == WireType.BINARY || this.wireType == WireType.BINARY_LIGHT) {
            return "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    sourceId: 0\n  }\n}\n--- !!data #binary\nlisting.highestCycle: 18554\n--- !!data #binary\nlisting.lowestCycle: 18554\n--- !!data #binary\nlisting.modCount: 5\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n--- !!data #binary\nnormalisedEOFsTo: 18554\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    512,\n    2199023255557\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 6\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 6\n  400,\n  416,\n  448,\n  464,\n  496,\n  512,\n  0, 0\n]\n--- !!data #binary\nhello A0\n--- !!data #binary\nhello B0\n--- !!meta-data #binary\nsome meta 0\n--- !!data #binary\nhello A1\n--- !!data #binary\nhello B1\n--- !!meta-data #binary\nsome meta 1\n--- !!data #binary\nhello A2\n--- !!data #binary\nhello B2\n--- !!meta-data #binary\nsome meta 2\n...\n";
        }
        throw new IllegalStateException("unknown wiretype=" + this.wireType);
    }

    @Test
    public void shouldNotGenerateGarbageReadingDocumentAfterEndOfFile() {
        Throwable throwable;
        AtomicLong clock = new AtomicLong(System.currentTimeMillis());
        File dir = this.getTmpDir();
        try (SingleChronicleQueue q = this.builder(dir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider(clock::get).build();){
            throwable = null;
            try (ExcerptAppender appender = q.createAppender();){
                appender.writeText((CharSequence)"first");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        clock.addAndGet(1100L);
        q = this.builder(dir, this.wireType).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider(clock::get).build();
        var4_4 = null;
        try {
            throwable = null;
            try (ExcerptTailer tailer = q.createTailer(this.named ? "named" : null);){
                Assert.assertEquals((Object)"first", (Object)tailer.readText());
                GcControls.waitForGcCycle();
                long startCollectionCount = GcControls.getGcCount();
                long maxAllowedGcCycles = 6L;
                long endCollectionCount = GcControls.getGcCount();
                long actualGcCycles = endCollectionCount - startCollectionCount;
                Assert.assertTrue((String)String.format("Too many GC cycles. Expected <= %d, but was %d", 6L, actualGcCycles), (actualGcCycles <= 6L ? 1 : 0) != 0);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (q != null) {
                if (var4_4 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    q.close();
                }
            }
        }
    }

    @Test
    public void testReadingWritingWhenNextCycleIsInSequence() {
        Throwable throwable;
        ExcerptAppender appender;
        SetTimeProvider timeProvider = new SetTimeProvider();
        File dir = this.getTmpDir();
        TestRollCycles rollCycle = TestRollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();){
            appender = queue.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"first message");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        timeProvider.advanceMillis(1100L);
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();
        var5_5 = null;
        try {
            appender = queue.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"second message");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        catch (Throwable appender2) {
            var5_5 = appender2;
            throw appender2;
        }
        finally {
            if (queue != null) {
                if (var5_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender2) {
                        var5_5.addSuppressed(appender2);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();
        var5_5 = null;
        try {
            throwable = null;
            try (ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);){
                Assert.assertEquals((Object)"first message", (Object)tailer.readText());
                Assert.assertEquals((Object)"second message", (Object)tailer.readText());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable throwable7) {
            var5_5 = throwable7;
            throw throwable7;
        }
        finally {
            if (queue != null) {
                if (var5_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable8) {
                        var5_5.addSuppressed(throwable8);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testReadingWritingWhenCycleIsSkipped() {
        Throwable throwable;
        ExcerptAppender appender;
        SetTimeProvider timeProvider = new SetTimeProvider();
        File dir = this.getTmpDir();
        TestRollCycles rollCycle = TestRollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();){
            appender = queue.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"first message");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        timeProvider.advanceMillis(2100L);
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();
        var5_5 = null;
        try {
            appender = queue.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"second message");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        catch (Throwable appender2) {
            var5_5 = appender2;
            throw appender2;
        }
        finally {
            if (queue != null) {
                if (var5_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender2) {
                        var5_5.addSuppressed(appender2);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();
        var5_5 = null;
        try {
            throwable = null;
            try (ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);){
                Assert.assertEquals((Object)"first message", (Object)tailer.readText());
                Assert.assertEquals((Object)"second message", (Object)tailer.readText());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable throwable7) {
            var5_5 = throwable7;
            throw throwable7;
        }
        finally {
            if (queue != null) {
                if (var5_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable8) {
                        var5_5.addSuppressed(throwable8);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testReadingWritingWhenCycleIsSkippedBackwards() {
        Throwable throwable;
        ExcerptAppender appender;
        SetTimeProvider timeProvider = new SetTimeProvider();
        long time = System.currentTimeMillis();
        timeProvider.currentTimeMillis(time);
        File dir = this.getTmpDir();
        TestRollCycles rollCycle = TestRollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();){
            appender = queue.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"first message");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        timeProvider.advanceMillis(2100L);
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();
        var7_6 = null;
        try {
            appender = queue.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"second message");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        catch (Throwable appender2) {
            var7_6 = appender2;
            throw appender2;
        }
        finally {
            if (queue != null) {
                if (var7_6 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender2) {
                        var7_6.addSuppressed(appender2);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();
        var7_6 = null;
        try {
            throwable = null;
            try (ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);){
                ExcerptTailer excerptTailer = tailer.direction(TailerDirection.BACKWARD).toEnd();
                Assert.assertEquals((Object)"second message", (Object)excerptTailer.readText());
                Assert.assertEquals((Object)"first message", (Object)excerptTailer.readText());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable throwable7) {
            var7_6 = throwable7;
            throw throwable7;
        }
        finally {
            if (queue != null) {
                if (var7_6 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable8) {
                        var7_6.addSuppressed(throwable8);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testReadWritingWithTimeProvider() {
        File dir = this.getTmpDir();
        long time = System.currentTimeMillis();
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.currentTimeMillis(time);
        try (SingleChronicleQueue q1 = this.binary(dir).timeProvider((TimeProvider)timeProvider).build();
             SingleChronicleQueue q2 = this.binary(dir).timeProvider((TimeProvider)timeProvider).build();
             ExcerptAppender appender2 = q2.createAppender();
             ExcerptTailer tailer1 = q1.createTailer(this.named ? "named" : null);
             ExcerptTailer tailer2 = q2.createTailer(this.named ? "named" : null);){
            try (DocumentContext dc = appender2.writingDocument();){
                dc.wire().write().text("some data");
            }
            dc = tailer2.readingDocument();
            var16_26 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var16_26 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var16_26 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var16_26.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Assert.assertEquals((Object)q1.file(), (Object)q2.file());
            timeProvider.advanceMillis(1L);
            for (int i = 0; i < 10; ++i) {
                try (DocumentContext dc = tailer1.readingDocument();){
                    if (dc.isPresent()) {
                        return;
                    }
                }
                Jvm.pause((long)1L);
            }
            Assert.fail();
        }
    }

    @Test
    public void testCountExceptsBetweenCycles() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider((TimeProvider)timeProvider).build();
             ExcerptAppender appender = queue.createAppender();){
            long[] indexs = new long[10];
            for (int i = 0; i < indexs.length; ++i) {
                try (DocumentContext writingContext = appender.writingDocument();){
                    writingContext.wire().write().text("some-text-" + i);
                    indexs[i] = writingContext.index();
                }
                if ((i + 1) % 5 == 0) {
                    timeProvider.advanceMillis(2000L);
                    continue;
                }
                if ((i + 1) % 3 != 0) continue;
                timeProvider.advanceMillis(1000L);
            }
            for (int lower = 0; lower < indexs.length; ++lower) {
                for (int upper = lower; upper < indexs.length; ++upper) {
                    Assert.assertEquals((long)(upper - lower), (long)queue.countExcerpts(indexs[lower], indexs[upper]));
                }
            }
            Assert.assertEquals((long)6L, (long)queue.countExcerpts(indexs[0], indexs[6]));
            Assert.assertEquals((long)0L, (long)queue.rollCycle().toSequenceNumber(indexs[6]));
            Assert.assertEquals((long)5L, (long)queue.countExcerpts(indexs[0], indexs[6] - 1L));
            Assert.assertEquals((long)7L, (long)queue.countExcerpts(indexs[0] - 1L, indexs[6]));
        }
    }

    @Test
    public void testLongLivingTailerAppenderReAcquiredEachSecond() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        File dir = this.getTmpDir();
        TestRollCycles rollCycle = TestRollCycles.TEST4_SECONDLY;
        try (SingleChronicleQueue queuet = this.binary(dir).rollCycle((RollCycle)rollCycle).testBlockSize().timeProvider((TimeProvider)timeProvider).build();
             ExcerptTailer tailer = queuet.createTailer(this.named ? "named" : null);){
            Jvm.pause((long)1L);
            try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).testBlockSize().timeProvider((TimeProvider)timeProvider).build();
                 ExcerptAppender appender = queue.createAppender();){
                for (int i = 0; i < 5; ++i) {
                    Jvm.pause((long)1L);
                    timeProvider.advanceMillis(1100L);
                    try (DocumentContext dc = appender.writingDocument();){
                        dc.wire().write((CharSequence)"some").int32(i);
                    }
                    dc = tailer.readingDocument();
                    var14_22 = null;
                    try {
                        if (!dc.isPresent()) {
                            System.out.println(queue.dump());
                        }
                        Assert.assertTrue((boolean)dc.isPresent());
                        Assert.assertEquals((long)i, (long)dc.wire().read("some").int32());
                        continue;
                    }
                    catch (Throwable throwable) {
                        var14_22 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (dc != null) {
                            if (var14_22 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable) {
                                    var14_22.addSuppressed(throwable);
                                }
                            } else {
                                dc.close();
                            }
                        }
                    }
                }
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testCountExceptsWithRubbishData() {
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();){
            queue.countExcerpts(6309354155219615744L, 5949066185029976064L);
        }
    }

    @Test
    public void testFromSizePrefixedBlobs() {
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).build();
             ExcerptAppender appender = queue.createAppender();){
            DocumentContext dc0;
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"some").text("data");
            }
            String s = null;
            try (DocumentContext dc = queue.createTailer(this.named ? "named" : null).readingDocument();){
                s = Wires.fromSizePrefixedBlobs((DocumentContext)dc);
                Assert.assertTrue((boolean)s.contains("some: data"));
                dc0 = dc;
            }
            String out = Wires.fromSizePrefixedBlobs((DocumentContext)dc0);
            Assert.assertEquals((Object)s, (Object)out);
        }
    }

    @Test
    public void tailerRollBackTest() {
        File source = this.getTmpDir();
        try (SingleChronicleQueue q = this.binary(source).build();
             ExcerptAppender appender = q.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"hello").text("hello-world");
            }
            dc = appender.writingDocument();
            var7_11 = null;
            try {
                dc.wire().write((CharSequence)"hello2").text("hello-world-2");
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_11 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testCopyQueue() {
        Throwable throwable;
        File source = this.getTmpDir();
        File target = this.getTmpDir();
        try (SingleChronicleQueue q = this.binary(source).build();){
            throwable = null;
            try (ExcerptAppender excerptAppender = q.createAppender();){
                excerptAppender.writeMessage("one", (Object)1);
                excerptAppender.writeMessage("two", (Object)2);
                excerptAppender.writeMessage("three", (Object)3);
                excerptAppender.writeMessage("four", (Object)4);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var4_4 = null;
        try (SingleChronicleQueue s = this.binary(source).build();){
            throwable = null;
            try (SingleChronicleQueue t = this.binary(target).build();
                 ExcerptTailer sourceTailer = s.createTailer(this.named ? "named" : null);
                 ExcerptAppender appender = t.createAppender();){
                Throwable throwable3;
                DocumentContext rdc;
                while (true) {
                    block101: {
                        block98: {
                            block99: {
                                rdc = sourceTailer.readingDocument();
                                throwable3 = null;
                                if (rdc.isPresent()) break block98;
                                if (rdc == null) return;
                                if (throwable3 == null) break block99;
                                try {
                                    rdc.close();
                                    return;
                                }
                                catch (Throwable throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                    return;
                                }
                            }
                            rdc.close();
                            return;
                        }
                        try (DocumentContext wdc = appender.writingDocument();){
                            Bytes bytes = rdc.wire().bytes();
                            wdc.wire().bytes().write((BytesStore)bytes);
                        }
                        if (rdc == null) continue;
                        if (throwable3 == null) break block101;
                        try {
                            rdc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    rdc.close();
                }
                catch (Throwable throwable6) {
                    try {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        if (rdc == null) throw throwable7;
                        if (throwable3 != null) {
                            try {
                                rdc.close();
                                throw throwable7;
                            }
                            catch (Throwable throwable8) {
                                throwable3.addSuppressed(throwable8);
                                throw throwable7;
                            }
                        }
                        rdc.close();
                        throw throwable7;
                    }
                }
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
        }
        catch (Throwable throwable10) {
            var4_4 = throwable10;
            throw throwable10;
        }
    }

    @Test
    public void testIncorrectExcerptTailerReadsAfterSwitchingTailerDirection() {
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)LegacyRollCycles.DAILY).build();
             ExcerptAppender appender = queue.createAppender();){
            int value = 0;
            long cycle = 0L;
            long startIndex = 0L;
            for (int i = 0; i < 56; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    if (cycle == 0L) {
                        cycle = queue.rollCycle().toCycle(dc.index());
                    }
                    long index = dc.index();
                    long seq = queue.rollCycle().toSequenceNumber(index);
                    if (seq == 52L) {
                        startIndex = dc.index();
                    }
                    if (seq >= 52L) {
                        int v = value++;
                        dc.wire().write((CharSequence)"value").int64((long)v);
                        continue;
                    }
                    dc.wire().write((CharSequence)"value").int64(0L);
                    continue;
                }
            }
            try (ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);){
                Assert.assertTrue((boolean)tailer.moveToIndex(startIndex));
                tailer.direction(TailerDirection.FORWARD);
                Assert.assertEquals((long)0L, (long)this.action(tailer, queue.rollCycle()));
                Assert.assertEquals((long)1L, (long)this.action(tailer, queue.rollCycle()));
                tailer.direction(TailerDirection.BACKWARD);
                Assert.assertEquals((long)2L, (long)this.action(tailer, queue.rollCycle()));
                Assert.assertEquals((long)1L, (long)this.action(tailer, queue.rollCycle()));
                tailer.direction(TailerDirection.FORWARD);
                Assert.assertEquals((long)0L, (long)this.action(tailer, queue.rollCycle()));
                Assert.assertEquals((long)1L, (long)this.action(tailer, queue.rollCycle()));
            }
        }
    }

    @Test
    public void testExistingRollCycleIsMaintained() {
        this.expectException("Overriding roll cycle from ");
        this.expectException("Overriding roll length from ");
        List values = StreamSupport.stream(RollCycles.all().spliterator(), false).collect(Collectors.toList());
        for (int i = 0; i < values.size() - 1; ++i) {
            File tmpDir = this.getTmpDir();
            try (SingleChronicleQueue queue = this.binary(tmpDir).rollCycle((RollCycle)values.get(i)).build();
                 ExcerptAppender appender = queue.createAppender();){
                appender.writeText((CharSequence)"hello world");
            }
            queue = this.binary(tmpDir).rollCycle((RollCycle)values.get(i + 1)).build();
            var5_5 = null;
            try {
                Assert.assertEquals(values.get(i), (Object)queue.rollCycle());
                continue;
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (queue != null) {
                    if (var5_5 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private long action(@NotNull ExcerptTailer tailer1, @NotNull RollCycle rollCycle) {
        try {
            try (DocumentContext dc = tailer1.readingDocument();){
                long l = dc.wire().read("value").int64();
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            rollCycle.toSequenceNumber(tailer1.index());
        }
    }

    @Test
    public void checkReferenceCountingAndCheckFileDeletion() {
        MappedFile mappedFile;
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();
             ExcerptAppender appender = queue.createAppender();){
            try (DocumentContext documentContext1 = appender.writingDocument();){
                documentContext1.wire().write().text("some text");
            }
            var7_10 = null;
            try (DocumentContext documentContext = queue.createTailer(this.named ? "named" : null).readingDocument();){
                mappedFile = this.toMappedFile(documentContext);
                Assert.assertEquals((Object)"some text", (Object)documentContext.wire().read().text());
            }
            catch (Throwable throwable) {
                var7_10 = throwable;
                throw throwable;
            }
        }
        SingleChronicleQueueTest.waitFor(() -> ((MappedFile)mappedFile).isClosed(), "mappedFile is not closed");
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test delete after close on windows");
            return;
        }
        Assert.assertTrue((boolean)mappedFile.file().delete());
    }

    @Test
    public void checkReferenceCountingWhenRollingAndCheckFileDeletion() {
        MappedFile mappedFile2;
        MappedFile mappedFile1;
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider((TimeProvider)timeProvider).build();
             ExcerptAppender appender = queue.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("some text");
                mappedFile1 = this.toMappedFile(dc);
            }
            timeProvider.advanceMillis(1100L);
            dc = appender.writingDocument();
            var11_11 = null;
            try {
                dc.wire().write().text("some more text");
                mappedFile2 = this.toMappedFile(dc);
            }
            catch (Throwable throwable) {
                var11_11 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var11_11 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            var11_11 = null;
            try (ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);){
                try (DocumentContext documentContext = tailer.readingDocument();){
                    MappedFile mappedFile3 = this.toMappedFile(documentContext);
                    Assert.assertEquals((Object)"some text", (Object)documentContext.wire().read().text());
                }
                documentContext = tailer.readingDocument();
                var13_21 = null;
                try {
                    MappedFile mappedFile4 = this.toMappedFile(documentContext);
                    Assert.assertEquals((Object)"some more text", (Object)documentContext.wire().read().text());
                }
                catch (Throwable throwable) {
                    var13_21 = throwable;
                    throw throwable;
                }
                finally {
                    if (documentContext != null) {
                        if (var13_21 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable) {
                                var13_21.addSuppressed(throwable);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                var11_11 = throwable;
                throw throwable;
            }
        }
        SingleChronicleQueueTest.waitFor(() -> ((MappedFile)mappedFile1).isClosed(), "mappedFile1 is not closed");
        SingleChronicleQueueTest.waitFor(() -> ((MappedFile)mappedFile2).isClosed(), "mappedFile2 is not closed");
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test delete after close on windows");
            return;
        }
        Assert.assertTrue((boolean)mappedFile1.file().delete());
        Assert.assertTrue((boolean)mappedFile2.file().delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testWritingDocumentIsAtomic() {
        int threadCount = 8;
        ExecutorService executorService = Executors.newFixedThreadPool(8, (ThreadFactory)new NamedThreadFactory("test"));
        AtomicLong fixedClock = new AtomicLong(System.currentTimeMillis());
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeoutMS(3000L).timeProvider(fixedClock::get).testBlockSize().build();){
            int iterationsPerThread = 4095;
            int totalIterations = 32760;
            int[] nonAtomicCounter = new int[]{0};
            for (int i = 0; i < 8; ++i) {
                executorService.submit(() -> SingleChronicleQueueTest.lambda$testWritingDocumentIsAtomic$87((ChronicleQueue)queue, nonAtomicCounter));
            }
            long timeout = 20000L + System.currentTimeMillis();
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            block29: for (int expected = 0; expected < 32760; ++expected) {
                while (true) {
                    if (System.currentTimeMillis() > timeout) {
                        Assert.fail((String)("Timed out, having read " + expected + " documents of " + 32760));
                    }
                    DocumentContext dc = tailer.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!dc.isPresent()) {
                            Thread.yield();
                            continue;
                        }
                        long justRead = dc.wire().read("some key").int64();
                        Assert.assertEquals((long)expected, (long)justRead);
                        continue block29;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dc == null) continue;
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dc.close();
                        continue;
                    }
                    break;
                }
            }
        }
        finally {
            executorService.shutdownNow();
            try {
                executorService.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
            }
        }
    }

    @Test
    public void shouldBeAbleToLoadQueueFromReadOnlyFiles() throws IOException {
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test read only mode on windows");
            return;
        }
        Assume.assumeFalse((boolean)this.named);
        File queueDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(queueDir, this.wireType).testBlockSize().build();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeDocument((Object)"foo", (v, t) -> v.text(t));
        }
        var3_3 = null;
        try (Stream<Path> list = Files.list(queueDir.toPath());){
            list.forEach(p -> Assert.assertTrue((boolean)p.toFile().setReadOnly()));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        queue = this.builder(queueDir, this.wireType).readOnly(true).testBlockSize().build();
        var3_3 = null;
        try {
            Assert.assertTrue((boolean)queue.createTailer(this.named ? "named" : null).readingDocument().isPresent());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void shouldCreateQueueInCurrentDirectory() {
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test delete after close on windows");
            return;
        }
        SingleChronicleQueue ignored = this.builder(new File(""), this.wireType).testBlockSize().build();
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
        Assert.assertTrue((boolean)new File("metadata.cq4t").delete());
    }

    @NotNull
    protected SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).rollCycle((RollCycle)TestRollCycles.TEST4_DAILY).testBlockSize();
    }

    @Test
    public void testTailerSnappingRollWithNewAppender() throws InterruptedException, ExecutionException, TimeoutException {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.currentTimeMillis(System.currentTimeMillis() - 2000L);
        File dir = this.getTmpDir();
        TestRollCycles rollCycle = TestRollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)timeProvider).build();
             ExcerptAppender excerptAppender = queue.createAppender();){
            excerptAppender.writeText((CharSequence)"someText");
            ExecutorService executorService = Executors.newFixedThreadPool(2, (ThreadFactory)new NamedThreadFactory("test"));
            Future<?> f1 = executorService.submit(() -> this.lambda$testTailerSnappingRollWithNewAppender$90(dir, (RollCycle)rollCycle, timeProvider));
            Future<?> f2 = executorService.submit(() -> this.lambda$testTailerSnappingRollWithNewAppender$91(dir, (RollCycle)rollCycle, timeProvider));
            f1.get(10L, TimeUnit.SECONDS);
            f2.get(10L, TimeUnit.SECONDS);
            executorService.shutdownNow();
        }
    }

    @NotNull
    protected SingleChronicleQueueBuilder builderWithAppendListener(@NotNull File file, @NotNull WireType wireType) {
        this.appenderListenerDump.clear();
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).rollCycle((RollCycle)TestRollCycles.TEST4_DAILY).timeProvider((TimeProvider)new SetTimeProvider("2021/11/17T12:34:56").advanceMillis(1000L)).appenderListener((w, idx) -> {
            ((Bytes)((Bytes)this.appenderListenerDump.append((CharSequence)"idx: ")).append((CharSequence)Long.toHexString(idx))).append((CharSequence)"\n");
            w.bytes().readSkip(-4L);
            ((Bytes)this.appenderListenerDump.append((CharSequence)Wires.fromSizePrefixedBlobs((WireIn)w))).append((CharSequence)"\n");
        }).testBlockSize();
    }

    @NotNull
    protected SingleChronicleQueueBuilder binary(@NotNull File file) {
        return this.builder(file, WireType.BINARY_LIGHT);
    }

    private MappedFile toMappedFile(@NotNull DocumentContext documentContext) {
        MappedBytes bytes = (MappedBytes)documentContext.wire().bytes();
        MappedFile mappedFile = bytes.mappedFile();
        return mappedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeBytesAndIndexFiveTimesWithOverwriteTest() {
        try (SingleChronicleQueue sourceQueue = this.builder(this.getTmpDir(), this.wireType).testBlockSize().build();
             ExcerptAppender excerptAppender = sourceQueue.createAppender();){
            for (int i = 0; i < 5; ++i) {
                try (DocumentContext dc = excerptAppender.writingDocument();){
                    dc.wire().write((CharSequence)"hello").text("world" + i);
                    continue;
                }
            }
            try (ExcerptTailer tailer = sourceQueue.createTailer(this.named ? "named" : null);
                 SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).testBlockSize().build();
                 ExcerptAppender appender0 = queue.createAppender();){
                Assume.assumeTrue((boolean)(appender0 instanceof InternalAppender));
                InternalAppender appender = (InternalAppender)appender0;
                Assume.assumeTrue((boolean)(appender instanceof StoreAppender));
                ArrayList<BytesWithIndex> bytesWithIndies = new ArrayList<BytesWithIndex>();
                try {
                    BytesWithIndex b;
                    int i;
                    for (i = 0; i < 5; ++i) {
                        bytesWithIndies.add(this.bytes(tailer));
                    }
                    for (i = 0; i < 4; ++i) {
                        b = (BytesWithIndex)bytesWithIndies.get(i);
                        appender.writeBytes(b.index, b.bytes);
                    }
                    for (i = 0; i < 4; ++i) {
                        b = (BytesWithIndex)bytesWithIndies.get(i);
                        appender.writeBytes(b.index, b.bytes);
                    }
                    BytesWithIndex b2 = (BytesWithIndex)bytesWithIndies.get(4);
                    appender.writeBytes(b2.index, b2.bytes);
                    ((StoreAppender)appender).checkWritePositionHeaderNumber();
                    appender0.writeText((CharSequence)"goodbye");
                }
                finally {
                    Closeable.closeQuietly(bytesWithIndies);
                }
                String dump = SingleChronicleQueueTest.tidyDump((ChronicleQueue)queue);
                Assert.assertTrue((String)dump, (boolean)dump.contains("--- !!data #binary\nhello: world0\n--- !!data #binary\nhello: world1\n--- !!data #binary\nhello: world2\n--- !!data #binary\nhello: world3\n--- !!data #binary\nhello: world4\n--- !!data #binary\ngoodbye\n"));
            }
        }
    }

    @Test
    public void writeBytesAndIndexFiveTimesTest() {
        try (SingleChronicleQueue sourceQueue = this.builder(this.getTmpDir(), this.wireType).testBlockSize().build();
             ExcerptAppender excerptAppender = sourceQueue.createAppender();){
            Throwable throwable;
            for (int i = 0; i < 5; ++i) {
                throwable = null;
                try (DocumentContext dc = excerptAppender.writingDocument();){
                    dc.wire().write((CharSequence)"hello").text("world" + i);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            String before = SingleChronicleQueueTest.tidyDump((ChronicleQueue)sourceQueue);
            throwable = null;
            try (ExcerptTailer tailer = sourceQueue.createTailer(this.named ? "named" : null);
                 SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).testBlockSize().build();
                 ExcerptAppender appender = queue.createAppender();){
                if (!(appender instanceof StoreAppender)) {
                    return;
                }
                for (int i = 0; i < 5; ++i) {
                    try (BytesWithIndex b = this.bytes(tailer);){
                        ((InternalAppender)appender).writeBytes(b.index, b.bytes);
                        continue;
                    }
                }
                String dump = SingleChronicleQueueTest.tidyDump((ChronicleQueue)queue);
                Assert.assertEquals((Object)before, (Object)dump);
                Assert.assertTrue((String)dump, (boolean)dump.contains("--- !!data #binary\nhello: world0\n--- !!data #binary\nhello: world1\n--- !!data #binary\nhello: world2\n--- !!data #binary\nhello: world3\n--- !!data #binary\nhello: world4"));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void rollbackTest() {
        Throwable throwable;
        File file = this.getTmpDir();
        try (SingleChronicleQueue sourceQueue = this.builder(file, this.wireType).testBlockSize().build();){
            throwable = null;
            try (ExcerptAppender excerptAppender = sourceQueue.createAppender();){
                try (DocumentContext dc = excerptAppender.writingDocument();){
                    dc.wire().write((CharSequence)"hello").text("world1");
                }
                dc = excerptAppender.writingDocument();
                var7_15 = null;
                try {
                    dc.wire().write((CharSequence)"hello2").text("world2");
                }
                catch (Throwable throwable2) {
                    var7_15 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc != null) {
                        if (var7_15 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                var7_15.addSuppressed(throwable3);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                dc = excerptAppender.writingDocument();
                var7_15 = null;
                try {
                    dc.wire().write((CharSequence)"hello3").text("world3");
                }
                catch (Throwable throwable4) {
                    var7_15 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dc != null) {
                        if (var7_15 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable5) {
                                var7_15.addSuppressed(throwable5);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
            }
            catch (Throwable dc) {
                throwable = dc;
                throw dc;
            }
        }
        var3_3 = null;
        try (SingleChronicleQueue queue = this.builder(file, this.wireType).testBlockSize().build();){
            throwable = null;
            try (ExcerptTailer tailer1 = queue.createTailer(this.named ? "named" : null);){
                StringBuilder sb = new StringBuilder();
                try (DocumentContext documentContext = tailer1.readingDocument();){
                    documentContext.wire().readEventName(sb);
                    Assert.assertEquals((Object)"hello", (Object)sb.toString());
                    documentContext.rollbackOnClose();
                }
                documentContext = tailer1.readingDocument();
                var8_20 = null;
                try {
                    documentContext.wire().readEventName(sb);
                    Assert.assertEquals((Object)"hello", (Object)sb.toString());
                }
                catch (Throwable throwable6) {
                    var8_20 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (documentContext != null) {
                        if (var8_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable7) {
                                var8_20.addSuppressed(throwable7);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
                documentContext = tailer1.readingDocument();
                var8_20 = null;
                try {
                    documentContext.wire().readEventName(sb);
                    documentContext.rollbackOnClose();
                    Assert.assertEquals((Object)"hello2", (Object)sb.toString());
                }
                catch (Throwable throwable8) {
                    var8_20 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (documentContext != null) {
                        if (var8_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable9) {
                                var8_20.addSuppressed(throwable9);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
                documentContext = tailer1.readingDocument();
                var8_20 = null;
                try {
                    Bytes bytes = documentContext.wire().bytes();
                    long rp = bytes.readPosition();
                    long wp = bytes.writePosition();
                    long wl = bytes.writeLimit();
                    try {
                        documentContext.wire().readEventName(sb);
                        Assert.assertEquals((Object)"hello2", (Object)sb.toString());
                        documentContext.rollbackOnClose();
                    }
                    finally {
                        ((Bytes)((Bytes)bytes.readPosition(rp)).writePosition(wp)).writeLimit(wl);
                    }
                }
                catch (Throwable throwable10) {
                    var8_20 = throwable10;
                    throw throwable10;
                }
                finally {
                    if (documentContext != null) {
                        if (var8_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable11) {
                                var8_20.addSuppressed(throwable11);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
                documentContext = tailer1.readingDocument();
                var8_20 = null;
                try {
                    documentContext.wire().readEventName(sb);
                    Assert.assertEquals((Object)"hello2", (Object)sb.toString());
                }
                catch (Throwable throwable12) {
                    var8_20 = throwable12;
                    throw throwable12;
                }
                finally {
                    if (documentContext != null) {
                        if (var8_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable13) {
                                var8_20.addSuppressed(throwable13);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
                documentContext = tailer1.readingDocument();
                var8_20 = null;
                try {
                    documentContext.wire().readEventName(sb);
                    Assert.assertEquals((Object)"hello3", (Object)sb.toString());
                    documentContext.rollbackOnClose();
                }
                catch (Throwable throwable14) {
                    var8_20 = throwable14;
                    throw throwable14;
                }
                finally {
                    if (documentContext != null) {
                        if (var8_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable15) {
                                var8_20.addSuppressed(throwable15);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
                documentContext = tailer1.readingDocument();
                var8_20 = null;
                try {
                    Assert.assertTrue((boolean)documentContext.isPresent());
                    documentContext.wire().readEventName(sb);
                    Assert.assertEquals((Object)"hello3", (Object)sb.toString());
                }
                catch (Throwable throwable16) {
                    var8_20 = throwable16;
                    throw throwable16;
                }
                finally {
                    if (documentContext != null) {
                        if (var8_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable17) {
                                var8_20.addSuppressed(throwable17);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
                documentContext = tailer1.readingDocument();
                var8_20 = null;
                try {
                    Assert.assertFalse((boolean)documentContext.isPresent());
                    documentContext.rollbackOnClose();
                }
                catch (Throwable throwable18) {
                    var8_20 = throwable18;
                    throw throwable18;
                }
                finally {
                    if (documentContext != null) {
                        if (var8_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable19) {
                                var8_20.addSuppressed(throwable19);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
                documentContext = tailer1.readingDocument();
                var8_20 = null;
                try {
                    Assert.assertFalse((boolean)documentContext.isPresent());
                }
                catch (Throwable throwable20) {
                    var8_20 = throwable20;
                    throw throwable20;
                }
                finally {
                    if (documentContext != null) {
                        if (var8_20 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable21) {
                                var8_20.addSuppressed(throwable21);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
            }
            catch (Throwable throwable22) {
                throwable = throwable22;
                throw throwable22;
            }
        }
        catch (Throwable throwable23) {
            var3_3 = throwable23;
            throw throwable23;
        }
    }

    private BytesWithIndex bytes(ExcerptTailer tailer) {
        try (DocumentContext dc = tailer.readingDocument();){
            if (!dc.isPresent()) {
                BytesWithIndex bytesWithIndex = null;
                return bytesWithIndex;
            }
            Bytes bytes = dc.wire().bytes();
            long index = dc.index();
            BytesWithIndex bytesWithIndex = new BytesWithIndex(bytes, index);
            return bytesWithIndex;
        }
    }

    @Test
    public void mappedSegmentsShouldBeUnmappedAsCycleRolls() throws IOException, InterruptedException {
        Assume.assumeTrue((String)"this test is slow and does not depend on wire type", (this.wireType == WireType.BINARY ? 1 : 0) != 0);
        long now = System.currentTimeMillis();
        long ONE_HOUR_IN_MILLIS = 3600000L;
        long ONE_DAY_IN_MILLIS = ONE_HOUR_IN_MILLIS * 24L;
        long midnight = now - now % ONE_DAY_IN_MILLIS;
        AtomicLong clock = new AtomicLong(now);
        StringBuilder builder = new StringBuilder();
        boolean passed = this.doMappedSegmentUnmappedRollTest(clock, builder);
        passed = passed && this.doMappedSegmentUnmappedRollTest(this.setTime(clock, midnight), builder);
        for (int i = 1; i < 3; ++i) {
            passed = passed && this.doMappedSegmentUnmappedRollTest(this.setTime(clock, midnight + (long)i * ONE_HOUR_IN_MILLIS), builder);
        }
        if (!passed) {
            Assert.fail((String)builder.toString());
        }
    }

    private AtomicLong setTime(AtomicLong clock, long newValue) {
        clock.set(newValue);
        return clock;
    }

    /*
     * Exception decompiling
     */
    private boolean doMappedSegmentUnmappedRollTest(AtomicLong clock, StringBuilder builder) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testReadUsingReadOnly() {
        Assume.assumeFalse((String)"Read-only mode is not supported on Windows", (boolean)OS.isWindows());
        Assume.assumeFalse((boolean)this.named);
        File tmpDir = this.getTmpDir();
        String expected = "hello world";
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)tmpDir).build();
             ExcerptAppender appender = out.createAppender();
             DocumentContext dc = appender.writingDocument();){
            dc.wire().getValueOut().text(expected);
        }
        out = SingleChronicleQueueBuilder.binary((File)tmpDir).readOnly(true).build();
        var4_4 = null;
        try {
            StringBuilder sb = new StringBuilder();
            try (DocumentContext dc = out.createTailer().readingDocument();){
                dc.wire().getValueIn().text(sb);
            }
            Assert.assertEquals((Object)expected, (Object)sb.toString());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var4_4 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    @Test
    public void lastIndexShouldReturnLastIndexForPopulatedQueue() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tmpDir).wireType(this.wireType).build();){
            long actualLastIndex;
            Assert.assertEquals((long)-1L, (long)queue.lastIndex());
            try (ExcerptAppender appender = queue.createAppender();){
                appender.writeText((CharSequence)"Hello!");
                actualLastIndex = appender.lastIndexAppended();
            }
            Assert.assertEquals((long)actualLastIndex, (long)queue.lastIndex());
        }
    }

    @Test
    public void lastIndexShouldReturnNegativeOneForEmptyQueue() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tmpDir).wireType(this.wireType).build();){
            Assert.assertEquals((long)-1L, (long)queue.lastIndex());
        }
    }

    @Test
    public void lastIndexShouldReturnNegativeOneForMetadataOnlyQueue() {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tmpDir).wireType(this.wireType).build();){
            try (ExcerptAppender appender = queue.createAppender();
                 DocumentContext documentContext = appender.writingDocument(true);){
                documentContext.wire().write().text("Hello!");
            }
            Assert.assertEquals((long)-1L, (long)queue.lastIndex());
        }
    }

    @Test
    public void shouldWaitForConditionWhenCreatingAppender() throws TimeoutException {
        File tmpDir = this.getTmpDir();
        AtomicBoolean gotAppender = new AtomicBoolean(false);
        ReentrantLock createAppenderLock = new ReentrantLock();
        Condition createAppenderCondition = createAppenderLock.newCondition();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tmpDir).wireType(this.wireType).createAppenderConditionCreator(q -> createAppenderCondition).build();){
            new Thread(() -> {
                createAppenderLock.lock();
                try (ExcerptAppender appender = queue.createAppender();){
                    gotAppender.set(true);
                }
            }).start();
            Jvm.pause((long)100L);
            Assert.assertFalse((boolean)gotAppender.get());
            createAppenderLock.lock();
            createAppenderCondition.signal();
            createAppenderLock.unlock();
            YieldingPauser pauser = new YieldingPauser(0);
            while (!gotAppender.get()) {
                pauser.pause(1L, TimeUnit.SECONDS);
            }
        }
    }

    private static /* synthetic */ boolean lambda$doMappedSegmentUnmappedRollTest$94(Path p) {
        return p.toString().endsWith(".cq4");
    }

    private static /* synthetic */ String lambda$doMappedSegmentUnmappedRollTest$93(String s) {
        return s + "\n";
    }

    private /* synthetic */ void lambda$testTailerSnappingRollWithNewAppender$91(File dir, RollCycle rollCycle, SetTimeProvider timeProvider) {
        try (SingleChronicleQueue queue2 = this.binary(dir).rollCycle(rollCycle).timeProvider((TimeProvider)timeProvider).build();
             ExcerptAppender appender = queue2.createAppender();){
            for (int i = 0; i < 5; ++i) {
                appender.writeText((CharSequence)"someText more");
                timeProvider.advanceMillis(400L);
            }
        }
    }

    private /* synthetic */ void lambda$testTailerSnappingRollWithNewAppender$90(File dir, RollCycle rollCycle, SetTimeProvider timeProvider) {
        Throwable throwable;
        ExcerptAppender appender;
        try (SingleChronicleQueue queue2 = this.binary(dir).rollCycle(rollCycle).timeProvider((TimeProvider)timeProvider).build();){
            appender = queue2.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"someText more");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        timeProvider.advanceMillis(1100L);
        queue2 = this.binary(dir).rollCycle(rollCycle).timeProvider((TimeProvider)timeProvider).build();
        var5_5 = null;
        try {
            appender = queue2.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"someText more");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var5_5 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue2 != null) {
                if (var5_5 != null) {
                    try {
                        queue2.close();
                    }
                    catch (Throwable throwable7) {
                        var5_5.addSuppressed(throwable7);
                    }
                } else {
                    queue2.close();
                }
            }
        }
    }

    private static /* synthetic */ void lambda$testWritingDocumentIsAtomic$87(ChronicleQueue queue, int[] nonAtomicCounter) {
        try (ExcerptAppender excerptAppender = queue.createAppender();){
            for (int j = 0; j < 4095; ++j) {
                try (DocumentContext dc = excerptAppender.writingDocument();){
                    int value;
                    nonAtomicCounter[0] = nonAtomicCounter[0] + 1;
                    dc.wire().write((CharSequence)"some key").int64((long)value);
                    continue;
                }
            }
        }
    }

    private /* synthetic */ void lambda$testRandomConcurrentReadWrite$86(ChronicleQueue q, String text) {
        try (ExcerptAppender appender = q.createAppender();
             ExcerptTailer tailer = q.createTailer();){
            this.doSomething(appender, tailer, text);
        }
    }

    private /* synthetic */ void lambda$testAppendedSkipToEndMultiThreaded$85(ChronicleQueue q, int sizePerThread, String text, CountDownLatch latch) {
        try (ExcerptAppender appender = q.createAppender();){
            for (int i = 0; i < sizePerThread; ++i) {
                this.writeTestDocument(appender, text);
            }
        }
        latch.countDown();
    }

    private static /* synthetic */ void lambda$testAppendAndReadAtIndex$28(int n, ChronicleQueue queue, WireIn r) throws IORuntimeException, InvalidMarshallableException {
        Assert.assertEquals((long)n, (long)queue.rollCycle().toSequenceNumber((long)r.read((WireKey)TestKey.test).int32()));
    }

    private /* synthetic */ void lambda$testReadAndAppend$10(CountDownLatch started, ChronicleQueue queue, int[] results) {
        try {
            started.countDown();
            ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
            int i = 0;
            while (i < 2) {
                boolean read = tailer.readDocument(r -> {
                    int result;
                    results[result] = result = r.read((WireKey)TestKey.test).int32();
                });
                if (read) {
                    ++i;
                    continue;
                }
                Jvm.pause((long)10L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"exception");
        }
    }

    private /* synthetic */ void lambda$testWriteWithDocumentReadBytesDifferentThreads$3(ChronicleQueue queue, BlockingQueue result) {
        OnHeapBytes b = Bytes.allocateElasticOnHeap((int)128);
        ExcerptTailer tailer = queue.createTailer(this.named ? "named" : null);
        tailer.readBytes((Bytes)b);
        if (b.readRemaining() == 0L) {
            return;
        }
        b.readPosition(0L);
        b.singleThreadedCheckReset();
        result.add(b);
        throw new RejectedExecutionException();
    }

    private static /* synthetic */ void lambda$testWriteWithDocumentReadBytesDifferentThreads$2(ChronicleQueue queue) {
        try (ExcerptAppender appender = queue.createAppender();
             DocumentContext dc = appender.writingDocument();){
            dc.wire().writeEventName((CharSequence)"key").text("some long message");
        }
    }

    private static class BytesWithIndex
    implements java.io.Closeable {
        private BytesStore<?, ?> bytes;
        private long index;

        public BytesWithIndex(Bytes<?> bytes, long index) {
            this.bytes = Bytes.allocateElasticDirect((long)bytes.readRemaining()).write(bytes);
            this.index = index;
        }

        @Override
        public void close() {
            this.bytes.releaseLast();
        }
    }

    static class MyMarshable
    extends SelfDescribingMarshallable
    implements Demarshallable {
        @UsedViaReflection
        String name;

        @UsedViaReflection
        public MyMarshable(@NotNull WireIn wire) {
            this.readMarshallable(wire);
        }

        public MyMarshable() {
        }
    }

    private static class MapWrapper
    extends SelfDescribingMarshallable {
        final Map<CharSequence, Double> map = new HashMap<CharSequence, Double>();

        private MapWrapper() {
        }
    }
}

