/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class SingleChronicleQueueBuilderTest
extends QueueTestCommon {
    private static final String TEST_QUEUE_FILE = "src/test/resources/tr2/20170320.cq4";
    static final String BASE_PATH = OS.getTarget() + "/singleChronicleQueueBuilderTest";

    @AfterClass
    public static void afterClass() {
        IOTools.deleteDirWithFiles((String)BASE_PATH, (int)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDetermineQueueDirectoryFromQueueFile() throws IOException {
        this.ignoreException("reading control code as text");
        this.ignoreException("Unable to copy TimedStoreRecovery safely");
        this.expectException("Queues should be configured with the queue directory, not a specific filename");
        this.ignoreException("Metadata file not found in readOnly mode");
        this.expectException("Unexpected field lastAcknowledgedIndexReplicated");
        Path path = Paths.get(TEST_QUEUE_FILE, new String[0]);
        Path metadata = Paths.get(path.getParent().toString(), "metadata.cq4t");
        if (metadata.toFile().exists()) {
            Files.delete(metadata);
        }
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)path).testBlockSize().readOnly(true).build();
             ExcerptTailer tailer = queue.createTailer();
             DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
        finally {
            IOTools.deleteDirWithFiles((File)path.toFile(), (int)20);
        }
        Assert.assertTrue((new File(TEST_QUEUE_FILE).length() < 0x100000L ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfQueuePathIsFileWithIncorrectExtension() throws IOException {
        File tempFile = File.createTempFile(SingleChronicleQueueBuilderTest.class.getSimpleName(), ".txt");
        tempFile.deleteOnExit();
        SingleChronicleQueueBuilder.binary((File)tempFile);
    }

    @Test
    public void setAllNullFields() {
        SingleChronicleQueueBuilder b1 = SingleChronicleQueueBuilder.builder();
        SingleChronicleQueueBuilder b2 = SingleChronicleQueueBuilder.builder();
        b1.blockSize(1234567);
        b2.bufferCapacity(98765L);
        b2.setAllNullFields(b1);
        Assert.assertEquals((long)1234567L, (long)b2.blockSize());
        Assert.assertEquals((long)98765L, (long)b2.bufferCapacity());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAllNullFieldsShouldFailWithDifferentHierarchy() {
        OneExtendedBuilder b1 = new OneExtendedBuilder();
        OtherExtendedBuilder b2 = new OtherExtendedBuilder();
        b2.bufferCapacity(98765L);
        b1.blockSize(1234567);
        b2.setAllNullFields(b1);
    }

    @Test
    public void testReadMarshallable() {
        this.expectException("Overriding roll epoch from existing metadata");
        String tmpDir = this.getTmpDir().toString();
        SingleChronicleQueueBuilder builder = (SingleChronicleQueueBuilder)Marshallable.fromString((CharSequence)("!net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder {\n  writeBufferMode: None,\n  readBufferMode: None,\n  wireType: BINARY_LIGHT,\n  path: " + tmpDir + ",\n  rollCycle: !net.openhft.chronicle.queue.rollcycles.LegacyRollCycles DAILY,\n  timeProvider: !net.openhft.chronicle.core.time.SystemTimeProvider INSTANCE,\n  rollTime: 17:02,\n  rollTimeZone: !java.time.ZoneRegion {\n    id: UTC\n  },}\n"));
        builder.build().close();
        Assert.assertEquals((long)61320000L, (long)builder.epoch());
        SingleChronicleQueueBuilder builder2 = (SingleChronicleQueueBuilder)Marshallable.fromString((CharSequence)builder.toString());
        builder2.build().close();
        Assert.assertEquals((long)61320000L, (long)builder2.epoch());
    }

    @Test
    public void testWriteMarshallableBinary() {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.single((String)BASE_PATH).rollCycle((RollCycle)LegacyRollCycles.HOURLY);
        builder.build().close();
        try (ScopedResource wireTl = Wires.acquireBinaryWireScoped();){
            Wire wire = (Wire)wireTl.get();
            wire.usePadding(true);
            wire.write().typedMarshallable((WriteMarshallable)builder);
            SingleChronicleQueueBuilder builder2 = (SingleChronicleQueueBuilder)wire.read().typedMarshallable();
            Assert.assertEquals((Object)builder, (Object)builder2);
            builder2.build().close();
        }
    }

    @Test
    public void testWriteMarshallable() {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.single((String)BASE_PATH).rollCycle((RollCycle)LegacyRollCycles.HOURLY);
        builder.build().close();
        String val = Marshallable.$toString((WriteMarshallable)builder);
        SingleChronicleQueueBuilder builder2 = (SingleChronicleQueueBuilder)Marshallable.fromString((CharSequence)val);
        Assert.assertEquals((Object)builder, (Object)builder2);
        builder2.build().close();
    }

    @Test
    public void tryOverrideSourceId() {
        this.expectException("Overriding sourceId from existing metadata");
        File tmpDir = this.getTmpDir();
        boolean firstSourceId = true;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tmpDir).sourceId(1).build();){
            Assert.assertNotNull((Object)queue);
        }
        var4_4 = null;
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.single((File)tmpDir).sourceId(2).build();){
            Assert.assertEquals((long)1L, (long)q.sourceId());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void buildWillNotSetCreateAppenderConditionWhenQueueIsReadOnly() {
        Assume.assumeFalse((boolean)OS.isWindows());
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tmpDir).build();){
            Assert.assertNotNull((Object)queue);
        }
        queue = SingleChronicleQueueBuilder.single((File)tmpDir).createAppenderConditionCreator(q -> {
            Assert.fail((String)"This should never be called");
            return null;
        }).readOnly(true).build();
        var3_3 = null;
        try {
            Assert.assertNotNull((Object)queue);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void drainerPriorityIsSetByDefault() {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.single();
        Assert.assertNotNull((Object)builder.drainerPriority());
    }

    static class OtherExtendedBuilder
    extends SingleChronicleQueueBuilder {
        OtherExtendedBuilder() {
        }
    }

    static class OneExtendedBuilder
    extends SingleChronicleQueueBuilder {
        OneExtendedBuilder() {
        }
    }
}

