/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollingCycleTest
extends QueueTestCommon {
    protected final boolean named;

    public RollingCycleTest(boolean named) {
        this.named = named;
    }

    @Parameterized.Parameters(name="named={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testRollCycle() {
        SetTimeProvider stp = new SetTimeProvider();
        long start = 1646697600000L;
        stp.currentTimeMillis(start);
        String basePath = OS.getTarget() + "/testRollCycle" + Time.uniqueId();
        Assume.assumeFalse((String)"Ignored on hugetlbfs as byte offsets will be different due to page size", (boolean)PageUtil.isHugePage((String)basePath));
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((String)basePath).blockSize(65536).timeoutMS(5L).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).timeProvider((TimeProvider)stp).build();
             ExcerptAppender appender = queue.createAppender();){
            for (int h = 0; h < 3; ++h) {
                stp.currentTimeMillis(start + TimeUnit.DAYS.toMillis(h));
                for (int i = 0; i < 3; ++i) {
                    appender.writeBytes((WriteBytesMarshallable)new TestBytesMarshallable(i));
                }
            }
            String expected = "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    sourceId: 0\n  }\n}\n# position: 152, header: 0\n--- !!data #binary\nlisting.highestCycle: 19061\n# position: 192, header: 1\n--- !!data #binary\nlisting.lowestCycle: 19059\n# position: 232, header: 2\n--- !!data #binary\nlisting.modCount: 11\n# position: 264, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 304, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 344, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 392, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n# position: 448, header: 7\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n" + (this.named ? "# position: 496, header: 8\n--- !!data #binary\nindex.named: 81866371629059\n# position: 528, header: 9\n--- !!data #binary\nindex.named2: 81866371629059\n...\n# 130508 bytes remaining\n" : "...\n# 130572 bytes remaining\n") + "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    496,\n    2130303778818\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 3\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 304, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  400,\n  448,\n  496,\n  0, 0, 0, 0, 0\n]\n# position: 400, header: 0\n--- !!data #binary\n00000190             10 6e 61 6d  65 5f 2d 31 31 35 35 34     \u00b7nam e_-11554\n000001a0 38 34 35 37 36 7a cb 93  3d 38 51 d9 d4 f6 c9 2d 84576z\u00b7\u00b7 =8Q\u00b7\u00b7\u00b7\u00b7-\n000001b0 a3 bd 70 39 9b b7 70 e9  8c 39 f0 1d 4f          \u00b7\u00b7p9\u00b7\u00b7p\u00b7 \u00b79\u00b7\u00b7O   \n# position: 448, header: 1\n--- !!data #binary\n000001c0             10 6e 61 6d  65 5f 2d 31 31 35 35 38     \u00b7nam e_-11558\n000001d0 36 39 33 32 35 6f 0e fb  68 d8 9c b8 19 fc cc 2c 69325o\u00b7\u00b7 h\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7,\n000001e0 35 92 f9 4d 68 e5 f1 2c  55 f0 b8 46 09          5\u00b7\u00b7Mh\u00b7\u00b7, U\u00b7\u00b7F\u00b7   \n# position: 496, header: 2\n--- !!data #binary\n000001f0             10 6e 61 6d  65 5f 2d 31 31 35 34 37     \u00b7nam e_-11547\n00000200 31 35 30 37 39 90 45 c5  e6 f7 b9 1a 4b ea c3 2f 15079\u00b7E\u00b7 \u00b7\u00b7\u00b7\u00b7K\u00b7\u00b7/\n00000210 7f 17 5f 10 01 5c 6e 62  fc cc 5e cc da          \u00b7\u00b7_\u00b7\u00b7\\nb \u00b7\u00b7^\u00b7\u00b7   \n# position: 544, header: 2 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130524 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    496,\n    2130303778818\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 3\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 304, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  400,\n  448,\n  496,\n  0, 0, 0, 0, 0\n]\n# position: 400, header: 0\n--- !!data #binary\n00000190             10 6e 61 6d  65 5f 2d 31 31 35 35 34     \u00b7nam e_-11554\n000001a0 38 34 35 37 36 7a cb 93  3d 38 51 d9 d4 f6 c9 2d 84576z\u00b7\u00b7 =8Q\u00b7\u00b7\u00b7\u00b7-\n000001b0 a3 bd 70 39 9b b7 70 e9  8c 39 f0 1d 4f          \u00b7\u00b7p9\u00b7\u00b7p\u00b7 \u00b79\u00b7\u00b7O   \n# position: 448, header: 1\n--- !!data #binary\n000001c0             10 6e 61 6d  65 5f 2d 31 31 35 35 38     \u00b7nam e_-11558\n000001d0 36 39 33 32 35 6f 0e fb  68 d8 9c b8 19 fc cc 2c 69325o\u00b7\u00b7 h\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7,\n000001e0 35 92 f9 4d 68 e5 f1 2c  55 f0 b8 46 09          5\u00b7\u00b7Mh\u00b7\u00b7, U\u00b7\u00b7F\u00b7   \n# position: 496, header: 2\n--- !!data #binary\n000001f0             10 6e 61 6d  65 5f 2d 31 31 35 34 37     \u00b7nam e_-11547\n00000200 31 35 30 37 39 90 45 c5  e6 f7 b9 1a 4b ea c3 2f 15079\u00b7E\u00b7 \u00b7\u00b7\u00b7\u00b7K\u00b7\u00b7/\n00000210 7f 17 5f 10 01 5c 6e 62  fc cc 5e cc da          \u00b7\u00b7_\u00b7\u00b7\\nb \u00b7\u00b7^\u00b7\u00b7   \n# position: 544, header: 2 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130524 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    496,\n    2130303778818\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 3\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 304, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  400,\n  448,\n  496,\n  0, 0, 0, 0, 0\n]\n# position: 400, header: 0\n--- !!data #binary\n00000190             10 6e 61 6d  65 5f 2d 31 31 35 35 34     \u00b7nam e_-11554\n000001a0 38 34 35 37 36 7a cb 93  3d 38 51 d9 d4 f6 c9 2d 84576z\u00b7\u00b7 =8Q\u00b7\u00b7\u00b7\u00b7-\n000001b0 a3 bd 70 39 9b b7 70 e9  8c 39 f0 1d 4f          \u00b7\u00b7p9\u00b7\u00b7p\u00b7 \u00b79\u00b7\u00b7O   \n# position: 448, header: 1\n--- !!data #binary\n000001c0             10 6e 61 6d  65 5f 2d 31 31 35 35 38     \u00b7nam e_-11558\n000001d0 36 39 33 32 35 6f 0e fb  68 d8 9c b8 19 fc cc 2c 69325o\u00b7\u00b7 h\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7,\n000001e0 35 92 f9 4d 68 e5 f1 2c  55 f0 b8 46 09          5\u00b7\u00b7Mh\u00b7\u00b7, U\u00b7\u00b7F\u00b7   \n# position: 496, header: 2\n--- !!data #binary\n000001f0             10 6e 61 6d  65 5f 2d 31 31 35 34 37     \u00b7nam e_-11547\n00000200 31 35 30 37 39 90 45 c5  e6 f7 b9 1a 4b ea c3 2f 15079\u00b7E\u00b7 \u00b7\u00b7\u00b7\u00b7K\u00b7\u00b7/\n00000210 7f 17 5f 10 01 5c 6e 62  fc cc 5e cc da          \u00b7\u00b7_\u00b7\u00b7\\nb \u00b7\u00b7^\u00b7\u00b7   \n...\n# 130524 bytes remaining\n";
            long numRead = 0L;
            TestBytesMarshallable reusableData = new TestBytesMarshallable(0);
            ExcerptTailer currentPosTailer = queue.createTailer(this.named ? "named" : null).toStart();
            ExcerptTailer endPosTailer = queue.createTailer(this.named ? "named2" : null).toEnd();
            while (currentPosTailer.index() < endPosTailer.index()) {
                try {
                    Assert.assertTrue((boolean)currentPosTailer.readBytes((ReadBytesMarshallable)reusableData));
                }
                catch (AssertionError e) {
                    System.err.println("Could not read data at index: " + numRead + " " + Long.toHexString(currentPosTailer.cycle()) + " " + Long.toHexString(currentPosTailer.index()) + " " + ((Throwable)((Object)e)).getMessage() + " " + e);
                    throw e;
                }
                ++numRead;
            }
            Assert.assertFalse((boolean)currentPosTailer.readBytes((ReadBytesMarshallable)reusableData));
            String dump = queue.dump();
            if (dump.contains("\n4 bytes remaining")) {
                expected = expected.replaceAll("\\n\\d+ bytes remaining", "\n4 bytes remaining");
            }
            Assert.assertEquals((Object)expected, (Object)dump);
            try {
                IOTools.deleteDirWithFiles((String)basePath, (int)2);
            }
            catch (IORuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    private static class TestBytesMarshallable
    implements WriteBytesMarshallable,
    ReadBytesMarshallable {
        @Nullable
        String _name;
        long _value1;
        long _value2;
        long _value3;

        public TestBytesMarshallable(int i) {
            Random rand = new Random(i);
            this._name = "name_" + rand.nextInt();
            this._value1 = rand.nextLong();
            this._value2 = rand.nextLong();
            this._value3 = rand.nextLong();
        }

        public void writeMarshallable(@NotNull BytesOut<?> bytes) {
            bytes.writeUtf8(this._name);
            bytes.writeLong(this._value1);
            bytes.writeLong(this._value2);
            bytes.writeLong(this._value3);
        }

        public void readMarshallable(@NotNull BytesIn<?> bytes) throws IORuntimeException {
            this._name = bytes.readUtf8();
            this._value1 = bytes.readLong();
            this._value2 = bytes.readLong();
            this._value3 = bytes.readLong();
        }
    }
}

