/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueSystemProperties;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PartialUpdateTest
extends QueueTestCommon {
    private static final long LAST_INDEX = RollCycles.FAST_DAILY.toIndex(2, 2L);
    private final PartialQueueCreator queueCreator;
    private Path queuePath;
    private SetTimeProvider setTimeProvider;
    private static boolean originalCheckIndexValue;

    public PartialUpdateTest(PartialQueueCreator queueCreator) {
        this.queueCreator = queueCreator;
    }

    @Parameterized.Parameters(name="state={0}")
    public static PartialQueueCreator[] params() {
        return PartialQueueCreator.values();
    }

    @Before
    public void setUp() {
        this.queuePath = IOTools.createTempDirectory((String)"partialUpdate");
        this.setTimeProvider = new SetTimeProvider();
        this.queueCreator.createQueue(this.setTimeProvider, this.queuePath);
    }

    @Override
    @After
    public void tearDown() {
        IOTools.deleteDirWithFiles((File)this.queuePath.toFile());
    }

    @BeforeClass
    public static void disableCheckIndexAssertions() {
        originalCheckIndexValue = QueueSystemProperties.CHECK_INDEX;
        QueueSystemProperties.CHECK_INDEX = false;
    }

    @AfterClass
    public static void restoreCheckIndexAssertions() {
        QueueSystemProperties.CHECK_INDEX = originalCheckIndexValue;
    }

    @Test
    public void testBackwardsToEndArrivesAtCorrectPosition() {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(this.setTimeProvider, this.queuePath);
             ExcerptTailer tailer = queue.createTailer();){
            tailer.direction(TailerDirection.BACKWARD).toEnd();
            Assert.assertEquals((Object)"Six", (Object)tailer.readText());
        }
    }

    @Test
    public void testBackwardsToEndReportsCorrectIndex() {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(this.setTimeProvider, this.queuePath);
             ExcerptTailer tailer = queue.createTailer();){
            tailer.direction(TailerDirection.BACKWARD).toEnd();
            Assert.assertEquals((long)LAST_INDEX, (long)tailer.index());
        }
    }

    @Test
    public void testForwardsToEndArrivesAtCorrectPosition() {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(this.setTimeProvider, this.queuePath);
             ExcerptTailer tailer = queue.createTailer();){
            tailer.toEnd();
            Assert.assertNull((Object)tailer.readText());
        }
    }

    @Test
    public void testForwardsToEndReportsCorrectIndex() {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(this.setTimeProvider, this.queuePath);
             ExcerptTailer tailer = queue.createTailer();){
            tailer.toEnd();
            Assert.assertEquals((long)(LAST_INDEX + 1L), (long)tailer.index());
        }
    }

    @Test
    public void testLastIndexIsCorrect() {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(this.setTimeProvider, this.queuePath);){
            Assert.assertEquals((long)LAST_INDEX, (long)queue.lastIndex());
        }
    }

    @Test
    public void testAppendReturnsCorrectLastAppendedIndex() {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(this.setTimeProvider, this.queuePath);
             ExcerptAppender appender = queue.createAppender();){
            appender.writeText((CharSequence)"Seven");
            Assert.assertEquals((long)(LAST_INDEX + 1L), (long)appender.lastIndexAppended());
        }
    }

    private static void createQueueWithConsistentButStaleWritePositionAndSequence(SetTimeProvider setTimeProvider, Path path) {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(setTimeProvider, path);
             ExcerptAppender appender = queue.createAppender();
             StoreTailer tailer = (StoreTailer)queue.createTailer();){
            appender.writeText((CharSequence)"One");
            appender.writeText((CharSequence)"Two");
            appender.writeText((CharSequence)"Three");
            setTimeProvider.advanceMillis(TimeUnit.HOURS.toMillis(2L));
            appender.writeText((CharSequence)"Four");
            appender.writeText((CharSequence)"Five");
            int currentCycle = RollCycles.FAST_DAILY.toCycle(appender.lastIndexAppended());
            try (SingleChronicleQueueStore secondRollCycle = queue.storeForCycle(currentCycle, 0L, false, null);){
                Assert.assertNotNull((Object)secondRollCycle);
                long previousWritePosition = secondRollCycle.writePosition();
                long previousSequence = secondRollCycle.lastSequenceNumber((ExcerptContext)tailer);
                PartialUpdateTest.printLastWritePositionAndSequence("before append last excerpt", tailer, secondRollCycle);
                Assert.assertEquals((long)1L, (long)previousSequence);
                appender.writeText((CharSequence)"Six");
                PartialUpdateTest.printLastWritePositionAndSequence("after append last excerpt", tailer, secondRollCycle);
                PartialUpdateTest.forceUpdateWritePositionAndSequence(tailer, secondRollCycle, previousWritePosition, previousSequence);
                PartialUpdateTest.printLastWritePositionAndSequence("after over-writing write position & seq", tailer, secondRollCycle);
            }
            catch (StreamCorruptedException e) {
                throw new RuntimeException("Error reading last sequence number", e);
            }
        }
    }

    private static void createQueueWithInconsistentWritePositionAndSequence(SetTimeProvider setTimeProvider, Path path) {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(setTimeProvider, path);
             ExcerptAppender appender = queue.createAppender();
             StoreTailer tailer = (StoreTailer)queue.createTailer();){
            appender.writeText((CharSequence)"One");
            appender.writeText((CharSequence)"Two");
            appender.writeText((CharSequence)"Three");
            setTimeProvider.advanceMillis(TimeUnit.HOURS.toMillis(2L));
            appender.writeText((CharSequence)"Four");
            appender.writeText((CharSequence)"Five");
            int currentCycle = RollCycles.FAST_DAILY.toCycle(appender.lastIndexAppended());
            try (SingleChronicleQueueStore secondRollCycle = queue.storeForCycle(currentCycle, 0L, false, null);){
                Assert.assertNotNull((Object)secondRollCycle);
                long previousWritePosition = secondRollCycle.writePosition();
                long previousSequence = secondRollCycle.lastSequenceNumber((ExcerptContext)tailer);
                PartialUpdateTest.printLastWritePositionAndSequence("before append last excerpt", tailer, secondRollCycle);
                Assert.assertEquals((long)1L, (long)previousSequence);
                appender.writeText((CharSequence)"Six");
                PartialUpdateTest.printLastWritePositionAndSequence("after append last excerpt", tailer, secondRollCycle);
                PartialUpdateTest.forceUpdateWritePosition(secondRollCycle, previousWritePosition);
                PartialUpdateTest.printLastWritePositionAndSequence("after over-writing write position", tailer, secondRollCycle);
            }
            catch (StreamCorruptedException e) {
                throw new RuntimeException("Error reading last sequence number", e);
            }
        }
    }

    private static void printLastWritePositionAndSequence(String description, StoreTailer context, SingleChronicleQueueStore store) {
        try {
            context.toStart();
            long writePosition = store.writePosition();
            long lastSequenceNumber = store.lastSequenceNumber((ExcerptContext)context);
            Jvm.startup().on(PartialUpdateTest.class, String.format("Last wp/seq = %x/%d (%s)", writePosition, lastSequenceNumber, description));
        }
        catch (StreamCorruptedException e) {
            throw new RuntimeException("Error reading last sequence number", e);
        }
    }

    private static void createAFullyConsistentQueue(SetTimeProvider setTimeProvider, Path path) {
        try (SingleChronicleQueue queue = PartialUpdateTest.createQueue(setTimeProvider, path);
             ExcerptAppender appender = queue.createAppender();){
            appender.writeText((CharSequence)"One");
            appender.writeText((CharSequence)"Two");
            appender.writeText((CharSequence)"Three");
            setTimeProvider.advanceMillis(TimeUnit.HOURS.toMillis(2L));
            appender.writeText((CharSequence)"Four");
            appender.writeText((CharSequence)"Five");
            appender.writeText((CharSequence)"Six");
        }
    }

    private static void forceUpdateWritePositionAndSequence(StoreTailer storeTailer, SingleChronicleQueueStore store, long newWritePosition, long newSequence) {
        try {
            PartialUpdateTest.forceUpdateWritePosition(store, newWritePosition);
            store.setPositionForSequenceNumber((ExcerptContext)storeTailer, newSequence, newWritePosition);
        }
        catch (StreamCorruptedException e) {
            throw new RuntimeException("Error setting position for sequence");
        }
    }

    private static void forceUpdateWritePosition(SingleChronicleQueueStore store, long newWritePosition) {
        try {
            Field wpField = store.getClass().getDeclaredField("writePosition");
            wpField.setAccessible(true);
            LongValue writePosition = (LongValue)wpField.get(store);
            writePosition.setValue(newWritePosition);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set write position/sequence", e);
        }
    }

    @NotNull
    private static SingleChronicleQueue createQueue(SetTimeProvider setTimeProvider, Path queuePath) {
        return SingleChronicleQueueBuilder.binary((Path)queuePath).timeProvider((TimeProvider)setTimeProvider).testBlockSize().rollCycle((RollCycle)RollCycles.FAST_HOURLY).build();
    }

    static enum PartialQueueCreator {
        CONSISTENT_BUT_STALE_WP_SEQ{

            @Override
            void createQueue(SetTimeProvider timeProvider, Path path) {
                PartialUpdateTest.createQueueWithConsistentButStaleWritePositionAndSequence(timeProvider, path);
            }
        }
        ,
        INCONSISTENT_WP_SEQ{

            @Override
            void createQueue(SetTimeProvider timeProvider, Path path) {
                PartialUpdateTest.createQueueWithInconsistentWritePositionAndSequence(timeProvider, path);
            }
        }
        ,
        FULLY_CONSISTENT{

            @Override
            void createQueue(SetTimeProvider timeProvider, Path path) {
                PartialUpdateTest.createAFullyConsistentQueue(timeProvider, path);
            }
        };


        abstract void createQueue(SetTimeProvider var1, Path var2);
    }
}

