/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.time.Duration;
import java.util.Objects;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

class MetadataDeletionTests
extends QueueTestCommon {
    MetadataDeletionTests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void singleCycleFile() {
        File queuePath = this.getTmpDir();
        try {
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)queuePath).build();
                 ExcerptAppender appender = queue.createAppender();){
                appender.writeText((CharSequence)"hello world");
            }
            finally {
                BackgroundResourceReleaser.releasePendingResources();
            }
            boolean delete = new File(queuePath, "metadata.cq4t").delete();
            Assertions.assertTrue((boolean)delete, (String)"metadata file should be deleted");
            Assertions.assertFalse((boolean)new File(queuePath, "metadata.cq4t").exists(), (String)"metadata file should not exist");
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)queuePath).build();
                 ExcerptTailer tailer = queue.createTailer();){
                Assertions.assertEquals((Object)"hello world", (Object)tailer.readText());
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void multipleCycleFiles() {
        File queuePath = this.getTmpDir();
        try {
            SetTimeProvider setTimeProvider = new SetTimeProvider();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)queuePath).timeProvider((TimeProvider)setTimeProvider).build();
                 ExcerptAppender appender = queue.createAppender();){
                appender.writeText((CharSequence)"1");
                setTimeProvider.advanceMillis(Duration.ofDays(1L).toMillis());
                appender.writeText((CharSequence)"2");
                setTimeProvider.advanceMillis(Duration.ofDays(1L).toMillis());
                appender.writeText((CharSequence)"3");
                setTimeProvider.advanceMillis(Duration.ofDays(1L).toMillis());
                appender.writeText((CharSequence)"4");
            }
            finally {
                BackgroundResourceReleaser.releasePendingResources();
            }
            boolean delete = new File(queuePath, "metadata.cq4t").delete();
            Assertions.assertTrue((boolean)delete, (String)"metadata file should be deleted");
            Assertions.assertFalse((boolean)new File(queuePath, "metadata.cq4t").exists(), (String)"metadata file should not exist");
            Assertions.assertEquals((int)Objects.requireNonNull(queuePath.listFiles((dir, name) -> name.endsWith(".cq4"))).length, (int)4, (String)"There should be 4 cycle files");
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)queuePath).timeProvider((TimeProvider)setTimeProvider).build();
                 ExcerptTailer tailer = queue.createTailer();){
                Assertions.assertEquals((Object)"1", (Object)tailer.readText());
                Assertions.assertEquals((int)0, (int)tailer.cycle());
                Assertions.assertEquals((Object)"2", (Object)tailer.readText());
                Assertions.assertEquals((int)1, (int)tailer.cycle());
                Assertions.assertEquals((Object)"3", (Object)tailer.readText());
                Assertions.assertEquals((int)2, (int)tailer.cycle());
                Assertions.assertEquals((Object)"4", (Object)tailer.readText());
                Assertions.assertEquals((int)3, (int)tailer.cycle());
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void multipleCycleFiles_deleteMetaDataWhilstTailing() {
        Assumptions.assumeFalse((boolean)OS.isWindows(), (String)"Skip this test on Windows because we can't delete the metadata file while it's open.");
        File queuePath = this.getTmpDir();
        try {
            Throwable throwable;
            SetTimeProvider setTimeProvider = new SetTimeProvider();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)queuePath).timeProvider((TimeProvider)setTimeProvider).build();){
                throwable = null;
                try (ExcerptAppender appender = queue.createAppender();){
                    appender.writeText((CharSequence)"1");
                    setTimeProvider.advanceMillis(Duration.ofDays(1L).toMillis());
                    appender.writeText((CharSequence)"2");
                    setTimeProvider.advanceMillis(Duration.ofDays(1L).toMillis());
                    appender.writeText((CharSequence)"3");
                    setTimeProvider.advanceMillis(Duration.ofDays(1L).toMillis());
                    appender.writeText((CharSequence)"4");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            queue = SingleChronicleQueueBuilder.binary((File)queuePath).timeProvider((TimeProvider)setTimeProvider).build();
            var4_4 = null;
            try {
                throwable = null;
                try (ExcerptTailer tailer = queue.createTailer();){
                    Assertions.assertEquals((Object)"1", (Object)tailer.readText());
                    Assertions.assertEquals((int)0, (int)tailer.cycle());
                    Assertions.assertEquals((Object)"2", (Object)tailer.readText());
                    Assertions.assertEquals((int)1, (int)tailer.cycle());
                    boolean delete = new File(queuePath, "metadata.cq4t").delete();
                    Assertions.assertTrue((boolean)delete, (String)"metadata file should be deleted");
                    Assertions.assertFalse((boolean)new File(queuePath, "metadata.cq4t").exists(), (String)"metadata file should not exist");
                    Assertions.assertEquals((int)Objects.requireNonNull(queuePath.listFiles((dir, name) -> name.endsWith(".cq4"))).length, (int)4, (String)"There should be 4 cycle files");
                    Assertions.assertEquals((Object)"3", (Object)tailer.readText());
                    Assertions.assertEquals((int)2, (int)tailer.cycle());
                    Assertions.assertEquals((Object)"4", (Object)tailer.readText());
                    Assertions.assertEquals((int)3, (int)tailer.cycle());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var4_4 = throwable4;
                throw throwable4;
            }
            finally {
                if (queue != null) {
                    if (var4_4 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable5) {
                            var4_4.addSuppressed(throwable5);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }
}

