/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;

public enum RunLargeQueueMain {

    private static final int FILE_SIZE = Integer.getInteger("file.size", 1024);
    private static final int MSG_SIZE = Integer.getInteger("msg.size", 1024);

    public static void main(String[] args) {
        System.out.printf("Configured file size: %d GB%n", FILE_SIZE);
        System.out.printf("Configured message size: %d B%n", MSG_SIZE);
        String queuePath = args.length > 0 ? args[0] : "/data/tmp/cq";
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((String)queuePath).blockSize((long)MSG_SIZE << 30).syncMode(SyncMode.SYNC).build();
             ExcerptAppender appender = queue.createAppender();
             ExcerptTailer tailer = queue.createTailer();){
            BytesStore writeBuffer = BytesStore.nativeStore((long)MSG_SIZE);
            VanillaBytes readBuffer = Bytes.allocateDirect((long)MSG_SIZE);
            for (int t = 1; t <= FILE_SIZE; ++t) {
                long writeStart = System.currentTimeMillis();
                for (int i = 0; i < 1000000000; i += MSG_SIZE) {
                    appender.writeBytes(writeBuffer);
                }
                appender.sync();
                long writeEnd = System.currentTimeMillis();
                for (int i = 0; i < 1000000000; i += MSG_SIZE) {
                    readBuffer.clear();
                    tailer.readBytes((Bytes)readBuffer);
                }
                long readEnd = System.currentTimeMillis();
                System.out.printf("%d: Took %.3f seconds to write and %.3f seconds to read 1 GB%n", t, (double)(writeEnd - writeStart) / 1000.0, (double)(readEnd - writeEnd) / 1000.0);
            }
        }
    }
}

