/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DefaultCycleCalculator;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollCyclesTest
extends QueueTestCommon {
    private static final long NO_EPOCH_OFFSET = 0L;
    private static final long SOME_EPOCH_OFFSET = 629L;
    private static List<Instant> incrementalTimes;
    private final RollCycle cycle;
    private final AtomicLong clock = new AtomicLong();
    private final TimeProvider timeProvider = this.clock::get;

    public RollCyclesTest(String cycleName, RollCycle cycle) {
        this.cycle = cycle;
    }

    @BeforeClass
    public static void generateTimes() {
        incrementalTimes = RollCyclesTest.generateIncrementalTimes();
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (RollCycle testDatum : RollCycles.all()) {
            data.add(new Object[]{((Enum)testDatum).name(), testDatum});
        }
        return data;
    }

    private static TimeProvider withDelta(TimeProvider delegate, long deltaMillis) {
        return () -> delegate.currentTimeMillis() + deltaMillis;
    }

    private static TimeProvider plusOneMillisecond(TimeProvider delegate) {
        return () -> delegate.currentTimeMillis() + 1L;
    }

    private static TimeProvider minusOneMillisecond(TimeProvider delegate) {
        return () -> delegate.currentTimeMillis() - 1L;
    }

    @Test
    public void shouldBe32bitShifted() {
        long factor = (long)this.cycle.defaultIndexCount() * (long)this.cycle.defaultIndexCount() * (long)this.cycle.defaultIndexSpacing();
        if (factor < 0x100000000L) {
            factor = 0x100000000L;
        }
        Assert.assertEquals((long)factor, (long)this.cycle.toIndex(1, 0L));
    }

    @Test
    public void shouldDetermineCurrentCycle() {
        this.assertCycleRollTimes(0L, RollCyclesTest.withDelta(this.timeProvider, 0L));
    }

    @Test
    public void shouldTakeEpochIntoAccoutWhenCalculatingCurrentCycle() {
        this.assertCycleRollTimes(629L, RollCyclesTest.withDelta(this.timeProvider, 629L));
    }

    @Test
    public void shouldHandleReasonableDateRange() {
        int currentCycle = DefaultCycleCalculator.INSTANCE.currentCycle(this.cycle, this.timeProvider, 0L);
        for (long nowMillis = 1500000000000L; nowMillis < 2000000000000L; nowMillis += 30000000000L) {
            this.clock.set(nowMillis);
            long index = this.cycle.toIndex(currentCycle, 0L);
            Assert.assertEquals((long)currentCycle, (long)this.cycle.toCycle(index));
        }
    }

    private void assertCycleRollTimes(long epochOffset, TimeProvider timeProvider) {
        long currentTime = System.currentTimeMillis();
        long currentTimeAtStartOfCycle = currentTime - currentTime % (long)this.cycle.lengthInMillis();
        this.clock.set(currentTimeAtStartOfCycle);
        int startCycle = this.cycle.current(timeProvider, epochOffset);
        this.clock.addAndGet(this.cycle.lengthInMillis());
        Assert.assertEquals((long)(startCycle + 1), (long)this.cycle.current(timeProvider, epochOffset));
        Assert.assertEquals((long)(startCycle + 1), (long)this.cycle.current(RollCyclesTest.plusOneMillisecond(timeProvider), epochOffset));
        Assert.assertEquals((long)startCycle, (long)this.cycle.current(RollCyclesTest.minusOneMillisecond(timeProvider), epochOffset));
        this.clock.addAndGet(this.cycle.lengthInMillis());
        Assert.assertEquals((long)(startCycle + 2), (long)this.cycle.current(timeProvider, epochOffset));
        Assert.assertEquals((long)(startCycle + 2), (long)this.cycle.current(RollCyclesTest.plusOneMillisecond(timeProvider), epochOffset));
        Assert.assertEquals((long)(startCycle + 1), (long)this.cycle.current(RollCyclesTest.minusOneMillisecond(timeProvider), epochOffset));
    }

    @Test
    public void lexicographicOrderShouldCorrelateToChronologicalOrder() {
        String lastName = null;
        Instant lastDate = null;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.cycle.format()).withZone(ZoneId.of("UTC"));
        for (Instant currentDate : incrementalTimes) {
            String currentName = formatter.format(currentDate);
            if (lastName != null && lastName.compareTo(currentName) > 0) {
                throw new AssertionError((Object)String.format("RollCycle.%s name for %s is lexicographically greater than that for %s, this breaks the contract (%s > %s)", this.cycle, lastDate, currentDate, lastName, currentName));
            }
            lastName = currentName;
            lastDate = currentDate;
        }
    }

    private static List<Instant> generateIncrementalTimes() {
        ArrayList<Instant> times = new ArrayList<Instant>();
        Instant currentTime = Instant.ofEpochMilli(1634334361895L);
        times.add(currentTime);
        currentTime = RollCyclesTest.addNext(times, currentTime, 30, ChronoUnit.SECONDS, 2);
        currentTime = RollCyclesTest.addNext(times, currentTime, 45, ChronoUnit.MINUTES, 2);
        currentTime = RollCyclesTest.addNext(times, currentTime, 24, ChronoUnit.HOURS, 2);
        RollCyclesTest.addNext(times, currentTime, 100, ChronoUnit.DAYS, 4);
        return times;
    }

    private static Instant addNext(List<Instant> allTimes, Instant startTime, int count, TemporalUnit unit, int stride) {
        for (int i = 0; i < count; ++i) {
            startTime = startTime.plus((long)stride, unit);
            allTimes.add(startTime);
        }
        return startTime;
    }
}

