/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class LastAcknowledgedTest
extends QueueTestCommon {
    @Test
    public void testLastAcknowledge() {
        long lastIndexAppended;
        String name = OS.getTarget() + "/testLastAcknowledge-" + Time.uniqueId();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.single((String)name).testBlockSize().build();
             ExcerptAppender excerptAppender = q.createAppender();){
            excerptAppender.writeText((CharSequence)"Hello World");
            lastIndexAppended = excerptAppender.lastIndexAppended();
            ExcerptTailer tailer = q.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isData());
                Assert.assertEquals((long)lastIndexAppended, (long)tailer.index());
            }
            ExcerptTailer tailer2 = q.createTailer();
            tailer2.readAfterReplicaAcknowledged(true);
            try (DocumentContext dc = tailer2.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
        }
        q = SingleChronicleQueueBuilder.single((String)name).testBlockSize().build();
        var5_3 = null;
        try {
            Assert.assertEquals((long)-1L, (long)q.lastAcknowledgedIndexReplicated());
            q.lastAcknowledgedIndexReplicated(lastIndexAppended - 1L);
            ExcerptTailer tailer2 = q.createTailer();
            tailer2.readAfterReplicaAcknowledged(true);
            try (DocumentContext dc = tailer2.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
            q.lastAcknowledgedIndexReplicated(lastIndexAppended);
            dc = tailer2.readingDocument();
            var8_11 = null;
            try {
                Assert.assertTrue((boolean)dc.isData());
                Assert.assertEquals((long)lastIndexAppended, (long)tailer2.index());
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_11 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (q != null) {
                if (var5_3 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    q.close();
                }
            }
        }
        IOTools.deleteDirWithFiles((String[])new String[]{name});
    }

    @Test
    public void testReadBeforeAcknowledgment() throws IOException {
        String pathName = "target" + System.nanoTime();
        Path tempDirectory = Files.createTempDirectory(pathName, new FileAttribute[0]);
        try (ChronicleQueue queue = ChronicleQueue.single((String)tempDirectory.toFile().getAbsolutePath());){
            LongValue lastAcknowledgedIndexReplicatedLongValue = (LongValue)Jvm.getValue((Object)queue, (String)"lastAcknowledgedIndexReplicated");
            ExcerptAppender appender = queue.createAppender();
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertFalse((boolean)tailer.readAfterReplicaAcknowledged());
            tailer.acknowledgedIndexReplicatedCheck((index, lastSequenceAck) -> index <= lastSequenceAck);
            Assert.assertTrue((boolean)tailer.readAfterReplicaAcknowledged());
            appender.writeText((CharSequence)"hello1");
            Assert.assertEquals(null, (Object)tailer.readText());
            lastAcknowledgedIndexReplicatedLongValue.setVolatileValue(appender.lastIndexAppended());
            Assert.assertEquals((Object)"hello1", (Object)tailer.readText());
            Assert.assertEquals(null, (Object)tailer.readText());
            int tolerateNumberOfUnAckedMessages = 1;
            tailer.acknowledgedIndexReplicatedCheck((index, lastSequenceAck) -> index <= lastSequenceAck + (long)tolerateNumberOfUnAckedMessages);
            appender.writeText((CharSequence)"hello2");
            lastAcknowledgedIndexReplicatedLongValue.setVolatileValue(appender.lastIndexAppended());
            appender.writeText((CharSequence)"hello3");
            Assert.assertEquals((Object)"hello2", (Object)tailer.readText());
            Assert.assertEquals((Object)"hello3", (Object)tailer.readText());
            Assert.assertEquals(null, (Object)tailer.readText());
            tolerateNumberOfUnAckedMessages = 2;
            tailer.acknowledgedIndexReplicatedCheck((index, lastSequenceAck) -> index <= lastSequenceAck + (long)tolerateNumberOfUnAckedMessages);
            appender.writeText((CharSequence)"hello4");
            lastAcknowledgedIndexReplicatedLongValue.setVolatileValue(appender.lastIndexAppended());
            appender.writeText((CharSequence)"hello5");
            appender.writeText((CharSequence)"hello6");
            Assert.assertEquals((Object)"hello4", (Object)tailer.readText());
            Assert.assertEquals((Object)"hello5", (Object)tailer.readText());
            Assert.assertEquals((Object)"hello6", (Object)tailer.readText());
            Assert.assertEquals(null, (Object)tailer.readText());
        }
    }

    @Test
    public void testReadBeforeAcknowledgmentOnRoll() throws IOException {
        String pathName = "target" + System.nanoTime();
        Path tempDirectory = Files.createTempDirectory(pathName, new FileAttribute[0]);
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((String)tempDirectory.toFile().getAbsolutePath()).timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();){
            LongValue lastAcknowledgedIndexReplicatedLongValue = (LongValue)Jvm.getValue((Object)queue, (String)"lastAcknowledgedIndexReplicated");
            ExcerptAppender appender = queue.createAppender();
            timeProvider.set(1L);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertFalse((boolean)tailer.readAfterReplicaAcknowledged());
            tailer.acknowledgedIndexReplicatedCheck((index, lastSequenceAck) -> index <= lastSequenceAck);
            Assert.assertTrue((boolean)tailer.readAfterReplicaAcknowledged());
            timeProvider.set(1L);
            appender.writeText((CharSequence)"hello1");
            appender.writeText((CharSequence)"hello2");
            Assert.assertEquals(null, (Object)tailer.readText());
            lastAcknowledgedIndexReplicatedLongValue.setVolatileValue(appender.lastIndexAppended());
            Assert.assertEquals((Object)"hello1", (Object)tailer.readText());
            Assert.assertEquals((Object)"hello2", (Object)tailer.readText());
            Assert.assertEquals(null, (Object)tailer.readText());
            timeProvider.set(2L);
            appender.writeText((CharSequence)"hello3");
            lastAcknowledgedIndexReplicatedLongValue.setVolatileValue(appender.lastIndexAppended());
            appender.writeText((CharSequence)"hello4");
            timeProvider.set(1002L);
            Assert.assertEquals((Object)"hello3", (Object)tailer.readText());
            Assert.assertEquals(null, (Object)tailer.readText());
        }
    }
}

