/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.main.DumpMain;
import org.junit.Assert;
import org.junit.Test;

public class DumpQueueMainTest
extends QueueTestCommon {
    @Test
    public void shouldBeAbleToDumpReadOnlyQueueFile() throws IOException {
        if (OS.isWindows()) {
            return;
        }
        File dataDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dataDir).build();
             ExcerptAppender excerptAppender = queue.createAppender();){
            excerptAppender.writeText((CharSequence)"first");
            excerptAppender.writeText((CharSequence)"last");
            try (Stream<Path> list = Files.list(dataDir.toPath());){
                Path queueFile = list.filter(p -> p.toString().endsWith(".cq4")).findFirst().orElseThrow(() -> new AssertionError((Object)("Could not find queue file in directory " + dataDir)));
                Assert.assertTrue((boolean)queueFile.toFile().setWritable(false));
                CountingOutputStream countingOutputStream = new CountingOutputStream();
                DumpMain.dump((File)queueFile.toFile(), (PrintStream)new PrintStream(countingOutputStream), (long)Long.MAX_VALUE);
                Assert.assertNotEquals((long)0L, (long)countingOutputStream.bytes);
            }
        }
    }

    @Test
    public void shouldDumpDirectoryListing() {
        File dataDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dataDir).build();
             ExcerptAppender excerptAppender = queue.createAppender();){
            excerptAppender.writeText((CharSequence)"first");
            excerptAppender.writeText((CharSequence)"last");
            ByteArrayOutputStream capture = new ByteArrayOutputStream();
            DumpMain.dump((File)dataDir, (PrintStream)new PrintStream(capture), (long)Long.MAX_VALUE);
            String capturedOutput = new String(capture.toByteArray());
            Assert.assertTrue((boolean)capturedOutput.contains("listing.highestCycle"));
            Assert.assertTrue((boolean)capturedOutput.contains("listing.lowestCycle"));
        }
    }

    private static final class CountingOutputStream
    extends OutputStream {
        private long bytes;

        private CountingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.bytes;
        }
    }
}

