/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ChunkCountTest
extends QueueTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void chunks() {
        File tempFile = IOTools.createTempFile((String)"chunks");
        Assume.assumeFalse((String)"Ignored on hugetlbfs as chunk count will vary under huge pages", (boolean)PageUtil.isHugePage((String)tempFile.getAbsolutePath()));
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((File)tempFile).testBlockSize().rollCycle((RollCycle)LegacyRollCycles.DAILY);
        try (SingleChronicleQueue queue = builder.build();
             ExcerptAppender appender = queue.createAppender();){
            Assert.assertEquals((long)0L, (long)queue.chunkCount());
            appender.writeText((CharSequence)"Hello");
            Assert.assertEquals((long)1L, (long)queue.chunkCount());
            for (int i = 0; i < 100; ++i) {
                long pos;
                try (DocumentContext dc = appender.writingDocument();){
                    pos = dc.wire().bytes().writePosition();
                    dc.wire().bytes().writeSkip(16000L);
                }
                long expected = 1L + (pos >> 18);
                Assert.assertEquals((String)("i: " + i), (long)expected, (long)queue.chunkCount());
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)tempFile);
        }
    }
}

