/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ChronicleQueueIndexTest
extends QueueTestCommon {
    @Test
    public void checkTheEOFisWrittenToPreQueueFileWritingDocumentMetadata() {
        Consumer<InternalAppender> writer = appender -> {
            try (DocumentContext wd = appender.writingDocument(true);){
                wd.wire().write((CharSequence)"key").writeDouble(1.0);
            }
        };
        this.checkTheEOFisWrittenToPreQueueFileInner(writer, (tp, rollCycle) -> tp.advanceMillis((long)(2 * rollCycle.lengthInMillis())), writer);
    }

    @Test
    public void checkTheEOFisWrittenToPreQueueFileWritingDocument() {
        Consumer<InternalAppender> writer = appender -> {
            try (DocumentContext wd = appender.writingDocument();){
                wd.wire().write((CharSequence)"key").writeDouble(1.0);
            }
        };
        this.checkTheEOFisWrittenToPreQueueFileInner(writer, (tp, rollCycle) -> tp.advanceMillis((long)(2 * rollCycle.lengthInMillis())), writer);
    }

    private void checkTheEOFisWrittenToPreQueueFileInner(Consumer<InternalAppender> writer1, BiConsumer<SetTimeProvider, RollCycle> tpConsumer, Consumer<InternalAppender> writer2) {
        Throwable throwable;
        InternalAppender appender;
        SetTimeProvider tp = new SetTimeProvider(1000000000L);
        File file1 = this.getTmpDir();
        RollCycles rollCycle = RollCycles.DEFAULT;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)tp).testBlockSize().build();){
            appender = (InternalAppender)queue.createAppender();
            throwable = null;
            try {
                writer1.accept(appender);
                Assert.assertFalse((boolean)this.hasEOFAtEndOfFile(file1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        tpConsumer.accept(tp, (RollCycle)rollCycle);
        queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)tp).testBlockSize().build();
        var8_8 = null;
        try {
            appender = (InternalAppender)queue.createAppender();
            throwable = null;
            try {
                writer2.accept(appender);
                Assert.assertTrue((boolean)this.hasEOFAtEndOfFile(file1));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var8_8 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var8_8 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var8_8.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    protected boolean hasEOFAtEndOfFile(File file) {
        try (SingleChronicleQueue queue123 = SingleChronicleQueueBuilder.builder().path(file).build();){
            String dump = queue123.dump();
            boolean bl = dump.contains(" EOF") && dump.contains("--- !!not-ready-meta-data");
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexQueue() {
        Bytes hello_world2;
        Throwable throwable;
        InternalAppender appender;
        File file1 = this.getTmpDir();
        file1.deleteOnExit();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)RollCycles.DEFAULT).build();){
            appender = (InternalAppender)queue.createAppender();
            throwable = null;
            try {
                hello_world2 = Bytes.from((String)"Hello World 1");
                appender.writeBytes(RollCycles.DEFAULT.toIndex(18264, 0L), (BytesStore)hello_world2);
                hello_world2.releaseLast();
                hello_world2 = Bytes.from((String)"Hello World 2");
                appender.writeBytes(RollCycles.DEFAULT.toIndex(18264, 1L), (BytesStore)hello_world2);
                hello_world2.releaseLast();
            }
            catch (Throwable hello_world2) {
                throwable = hello_world2;
                throw hello_world2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable hello_world2) {
                            throwable.addSuppressed(hello_world2);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)RollCycles.DEFAULT).build();
        var3_3 = null;
        try {
            appender = (InternalAppender)queue.createAppender();
            throwable = null;
            try {
                hello_world2 = Bytes.from((String)"Hello World 3");
                appender.writeBytes(RollCycles.DEFAULT.toIndex(18265, 0L), (BytesStore)hello_world2);
                hello_world2.releaseLast();
                ExcerptTailer tailer = queue.createTailer();
                Bytes forRead = Bytes.elasticByteBuffer();
                try {
                    ArrayList<String> results = new ArrayList<String>();
                    while (tailer.readBytes(forRead)) {
                        results.add(forRead.to8bitString());
                        forRead.clear();
                    }
                    Assert.assertTrue((String)((Object)results).toString(), (boolean)results.contains("Hello World 1"));
                    Assert.assertTrue((boolean)results.contains("Hello World 2"));
                    Assert.assertTrue((boolean)results.contains("Hello World 3"));
                }
                finally {
                    forRead.releaseLast();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable5) {
                        var3_3.addSuppressed(throwable5);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void read5thMessageTest() {
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(SystemTimeProvider.CLOCK.currentTimeMillis());
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();
             ExcerptAppender appender = queue.createAppender();){
            int cycle;
            int i = 0;
            String msg = "world ";
            for (int j = 0; j < 8; ++j) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().write((CharSequence)"hello").text(msg + i++);
                }
                stp.advanceMillis(1500L);
            }
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext documentContext = tailer.readingDocument();){
                long index = documentContext.index();
                cycle = queue.rollCycle().toCycle(index + 1L);
            }
            long index = queue.rollCycle().toIndex(cycle, 5L);
            Assert.assertFalse((boolean)tailer.moveToIndex(index));
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
            long index0 = queue.rollCycle().toIndex(cycle, 0L);
            Assert.assertTrue((boolean)tailer.moveToIndex(index0));
            for (int j = 0; j < 4; ++j) {
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertTrue((boolean)dc.isPresent());
                    String hello = dc.wire().read("hello").text();
                    System.out.println(hello);
                    continue;
                }
            }
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                String s5 = dc.wire().read("hello").text();
                Assert.assertEquals((Object)(msg + 4), (Object)s5);
            }
        }
    }

    @Test
    public void writeReadMetadata() {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).testBlockSize().build();
             ExcerptAppender appender = queue.createAppender();){
            ExcerptTailer tailer = queue.createTailer();
            boolean metadata = true;
            try (DocumentContext dc = appender.writingDocument(metadata);){
                dc.wire().write((CharSequence)"a").text("hello");
            }
            dc = tailer.readingDocument(metadata);
            var8_12 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    private void driver0(String[] strings, boolean[] meta, SetTimeProvider stp, long millis) {
        assert (strings.length == meta.length);
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)stp).testBlockSize().build();
             ExcerptAppender appender = queue.createAppender();){
            for (int i2 = 0; i2 < strings.length; ++i2) {
                try (DocumentContext dc = appender.writingDocument(meta[i2]);){
                    dc.wire().write((CharSequence)"key").text(strings[i2]);
                }
                stp.advanceMillis(millis);
            }
            List<String> allReads = this.readKeyed((ChronicleQueue)queue, true);
            Assert.assertEquals(Arrays.asList(strings), allReads);
            List<String> dataReads = this.readKeyed((ChronicleQueue)queue, false);
            List expectedData = IntStream.range(0, strings.length).filter(i -> !meta[i]).mapToObj(i -> strings[i]).collect(Collectors.toList());
            Assert.assertEquals(expectedData, dataReads);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<String> readKeyed(ChronicleQueue queue, boolean includeMetaData) {
        try (ExcerptTailer tailer = queue.createTailer();){
            ArrayList<String> allReads = new ArrayList<String>();
            while (true) {
                Throwable throwable2;
                DocumentContext dc;
                block30: {
                    ArrayList<String> arrayList;
                    block31: {
                        dc = tailer.readingDocument(includeMetaData);
                        throwable2 = null;
                        if (dc.isPresent()) break block30;
                        arrayList = allReads;
                        if (dc == null) return arrayList;
                        if (throwable2 == null) break block31;
                        try {
                            dc.close();
                            return arrayList;
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                            return arrayList;
                        }
                    }
                    dc.close();
                    return arrayList;
                }
                try {
                    Wire wire = dc.wire();
                    String key = (String)wire.readEvent(String.class);
                    if (!key.equals("key")) continue;
                    String str = wire.getValueIn().text();
                    allReads.add(str);
                    continue;
                }
                catch (Throwable throwable4) {
                    throwable2 = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable2 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }
    }

    private void driver(String[] strings, boolean[] meta) {
        SetTimeProvider stp = new SetTimeProvider(1000000000L);
        this.driver0(strings, meta, stp, 0L);
        this.driver0(strings, meta, stp, 1500L);
    }

    @Test
    public void D() {
        this.driver(new String[]{"data-1"}, new boolean[]{false});
    }

    @Test
    public void M() {
        this.driver(new String[]{"data-1"}, new boolean[]{true});
    }

    @Test
    public void DDD() {
        this.driver(new String[]{"data-1", "data-2", "data-3"}, new boolean[]{false, false, false});
    }

    @Test
    public void DDM() {
        this.driver(new String[]{"data-1", "data-2", "meta-1"}, new boolean[]{false, false, true});
    }

    @Test
    public void DMD() {
        this.driver(new String[]{"data-1", "meta-1", "data-2"}, new boolean[]{false, true, false});
    }

    @Test
    public void DMM() {
        this.driver(new String[]{"data-1", "meta-1", "meta-2"}, new boolean[]{false, true, true});
    }

    @Test
    public void MMM() {
        this.driver(new String[]{"meta-1", "meta-2", "meta-3"}, new boolean[]{true, true, true});
    }

    @Test
    public void MMD() {
        this.driver(new String[]{"meta-1", "meta-2", "data-1"}, new boolean[]{true, true, false});
    }

    @Test
    public void MDM() {
        this.driver(new String[]{"meta-1", "data-1", "meta-2"}, new boolean[]{true, false, true});
    }

    @Test
    public void MDD() {
        this.driver(new String[]{"meta-1", "data-1", "data-2"}, new boolean[]{true, false, false});
    }
}

