/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.ref.BinaryBooleanReference;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.BinaryTwoLongReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.LicenceCheck;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.AbstractAnyWire;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.CSVWire;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.ReadAnyWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlWire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum WireType implements Function<Bytes<?>, Wire>,
LicenceCheck
{
    TEXT{
        private final boolean TEXT_AS_YAML = Jvm.getBoolean("wire.testAsYaml");

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            if (this.TEXT_AS_YAML) {
                return (Wire)YAML.apply(bytes);
            }
            TextWire wire = new TextWire(bytes).useBinaryDocuments();
            wire.usePadding(true);
            return wire;
        }

        @Override
        public Supplier<LongValue> newLongReference() {
            return TextLongReference::new;
        }

        @Override
        public Supplier<LongArrayValues> newLongArrayReference() {
            return TextLongArrayReference::new;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public <T> T fromString(Class<T> tClass, @NotNull CharSequence cs) throws InvalidMarshallableException {
            NativeBytes<Void> bytes = Bytes.allocateElasticDirect(cs.length());
            try {
                bytes.appendUtf8(cs);
                @NotNull Wire wire = this.apply((Bytes<?>)bytes);
                wire.consumePadding();
                if (!this.TEXT_AS_YAML) {
                    ((TextWire)wire).consumeDocumentStart();
                }
                T t = wire.getValueIn().object(tClass);
                return t;
            }
            finally {
                bytes.releaseLast();
            }
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    BINARY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return BinaryWire.binaryOnly(bytes);
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) throws InvalidMarshallableException {
            return this.fromHexString(cs);
        }
    }
    ,
    BINARY_LIGHT{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return BinaryWire.binaryOnly(bytes);
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) throws InvalidMarshallableException {
            return this.fromHexString(cs);
        }
    }
    ,
    FIELDLESS_BINARY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new BinaryWire(bytes, false, false, true, Integer.MAX_VALUE, "binary");
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) throws InvalidMarshallableException {
            return this.fromHexString(cs);
        }
    }
    ,
    COMPRESSED_BINARY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new BinaryWire(bytes, false, false, false, COMPRESSED_SIZE, "lzw");
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) throws InvalidMarshallableException {
            return this.fromHexString(cs);
        }
    }
    ,
    JSON{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            JSONWire wire = new JSONWire(bytes);
            wire.useBinaryDocuments();
            wire.usePadding(true);
            return wire;
        }

        @Override
        public boolean isText() {
            return true;
        }

        @Override
        public String asString(Object marshallable) {
            return this.asUtf8String(marshallable);
        }
    }
    ,
    JSON_ONLY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return ((TextWire)new JSONWire(bytes).useTypes(true).trimFirstCurly(false)).useTextDocuments();
        }

        @Override
        public boolean isText() {
            return true;
        }

        @Override
        public String asString(Object marshallable) {
            return this.asUtf8String(marshallable);
        }
    }
    ,
    YAML{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            YamlWire wire = new YamlWire(bytes).useBinaryDocuments();
            wire.usePadding(true);
            return wire;
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    YAML_ONLY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new YamlWire(bytes).useTextDocuments();
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    RAW{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new RawWire(bytes);
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) throws InvalidMarshallableException {
            return this.fromHexString(cs);
        }
    }
    ,
    CSV{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new CSVWire(bytes);
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    READ_ANY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new ReadAnyWire(bytes);
        }
    };

    private static final int COMPRESSED_SIZE;

    /*
     * Loose catch block
     */
    @NotNull
    protected String asUtf8String(Object marshallable) {
        ValidatableUtil.startValidateDisabled();
        try {
            try (ScopedResource<Bytes<Void>> stlBytes = Wires.acquireBytesScoped();){
                Bytes<Void> bytes = stlBytes.get();
                this.asBytes(marshallable, bytes);
                String string = bytes.toUtf8String();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ValidatableUtil.endValidateDisabled();
        }
    }

    @Nullable
    public static WireType valueOf(@Nullable Wire wire) {
        if (wire == null) {
            return null;
        }
        if (wire instanceof AbstractAnyWire) {
            wire = ((AbstractAnyWire)wire).underlyingWire();
        }
        if (wire instanceof YamlWire) {
            return YAML;
        }
        if (wire instanceof JSONWire) {
            return JSON;
        }
        if (wire instanceof TextWire) {
            return TEXT;
        }
        if (wire instanceof BinaryWire) {
            @NotNull BinaryWire binaryWire = (BinaryWire)wire;
            return binaryWire.fieldLess() ? FIELDLESS_BINARY : BINARY;
        }
        if (wire instanceof RawWire) {
            return RAW;
        }
        throw new IllegalStateException("unknown type");
    }

    public Supplier<IntValue> newIntReference() {
        return BinaryIntReference::new;
    }

    public Supplier<BooleanValue> newBooleanReference() {
        return BinaryBooleanReference::new;
    }

    public Supplier<LongValue> newLongReference() {
        return BinaryLongReference::new;
    }

    public Supplier<TwoLongValue> newTwoLongReference() {
        return BinaryTwoLongReference::new;
    }

    public Supplier<LongArrayValues> newLongArrayReference() {
        return BinaryLongArrayReference::new;
    }

    /*
     * Loose catch block
     */
    public String asString(Object marshallable) {
        ValidatableUtil.startValidateDisabled();
        try {
            try (ScopedResource<Bytes<Void>> stlBytes = Wires.acquireBytesScoped();){
                Bytes<Void> bytes = stlBytes.get();
                this.asBytes(marshallable, bytes);
                String string = bytes.toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ValidatableUtil.endValidateDisabled();
        }
    }

    @NotNull
    private void asBytes(Object marshallable, Bytes<?> bytes) throws InvalidMarshallableException {
        Wire wire;
        wire.usePadding((wire = (Wire)this.apply(bytes)).isBinary() && AbstractWire.DEFAULT_USE_PADDING);
        @NotNull ValueOut valueOut = wire.getValueOut();
        if (marshallable instanceof WriteMarshallable) {
            valueOut.typedMarshallable((WriteMarshallable)marshallable);
        } else if (marshallable instanceof Map) {
            wire.getValueOut().marshallable((Map)marshallable, Object.class, Object.class, false);
        } else if (marshallable instanceof Iterable) {
            wire.getValueOut().sequence((Iterable)marshallable);
        } else if (marshallable instanceof Serializable) {
            valueOut.typedMarshallable((Serializable)marshallable);
        } else {
            valueOut.typedMarshallable(Wires.typeNameFor(marshallable), w -> Wires.writeMarshallable(marshallable, w));
        }
    }

    @Nullable
    public <T> T fromString(@NotNull CharSequence cs) throws InvalidMarshallableException {
        return this.fromString(null, cs);
    }

    public <T> T fromString(Class<T> tClass, @NotNull CharSequence cs) throws InvalidMarshallableException {
        if (cs.length() == 0) {
            throw new IllegalArgumentException("cannot deserialize an empty string");
        }
        try (ScopedResource<Bytes<Void>> stlBytes = Wires.acquireBytesScoped();){
            Bytes<Void> bytes = stlBytes.get();
            bytes.appendUtf8(cs);
            Wire wire = (Wire)this.apply(bytes);
            T object = wire.getValueIn().object(tClass);
            this.cleanNullCollections(object);
            T t = object;
            return t;
        }
    }

    private void cleanNullCollections(Object object) {
        if (object == null) {
            return;
        }
        Field[] declaredFields = object.getClass().getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field field = declaredFields[i];
            if (!Collection.class.isAssignableFrom(field.getType())) continue;
            try {
                Collection collection;
                field.setAccessible(true);
                Object fieldValue = field.get(object);
                if (!(fieldValue instanceof Collection) || (collection = (Collection)fieldValue).size() != 1 || collection.iterator().next() != null) continue;
                field.set(object, null);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new InvalidMarshallableException("Failed cleaning null collection during processing field: " + field.getName());
            }
        }
    }

    @NotNull
    public <T> T fromFile(String filename) throws IOException, InvalidMarshallableException {
        return (T)this.fromFile(Marshallable.class, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T fromFile(@NotNull Class<T> expectedType, String filename) throws IOException, InvalidMarshallableException {
        Bytes<byte[]> bytes;
        File file = new File(filename);
        URL url = null;
        if (!file.exists()) {
            url = IOTools.urlFor(expectedType, filename);
            file = new File(url.getFile());
        }
        if ((bytes = Bytes.wrapForRead(IOTools.readAsBytes(url == null ? new FileInputStream(file) : IOTools.open(url)))).readRemaining() == 0L) {
            throw new IOException("File " + file + " was empty");
        }
        try {
            T t = ((Wire)this.apply(bytes)).getValueIn().object(expectedType);
            return t;
        }
        finally {
            bytes.releaseLast();
        }
    }

    @NotNull
    public <T> Stream<T> streamFromFile(String filename) throws IOException {
        return this.streamFromFile(Marshallable.class, filename);
    }

    @NotNull
    public <T> Stream<T> streamFromFile(@NotNull Class<T> expectedType, String filename) throws IOException {
        Bytes<?> b = BytesUtil.readFile(filename);
        return this.streamFromBytes(expectedType, b);
    }

    @NotNull
    public <T> Stream<T> streamFromBytes(final @NotNull Class<T> expectedType, Bytes<?> b) {
        final Wire wire = (Wire)this.apply(b);
        final ValueIn valueIn = wire.getValueIn();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){

            @Override
            public boolean tryAdvance(@NotNull Consumer<? super T> action) {
                Bytes<?> bytes = wire.bytes();
                if (valueIn.hasNext()) {
                    action.accept(valueIn.object(expectedType));
                    if (wire instanceof TextWire) {
                        wire.consumePadding();
                        if (bytes.peekUnsignedByte() == 45 && bytes.peekUnsignedByte(bytes.readPosition() + 1L) == 45 && bytes.peekUnsignedByte(bytes.readPosition() + 2L) == 45) {
                            bytes.readSkip(3L);
                            while (bytes.peekUnsignedByte() == 45) {
                                bytes.readSkip(1L);
                            }
                        }
                    }
                    return true;
                }
                if (bytes.refCount() > 0) {
                    bytes.releaseLast();
                }
                return false;
            }
        }, false);
    }

    public void toFile(@NotNull String filename, WriteMarshallable marshallable) throws IOException, InvalidMarshallableException {
        String tempFilename = IOTools.tempName(filename);
        try (ScopedResource<Bytes<Void>> stlBytes = Wires.acquireBytesScoped();){
            Bytes<Void> bytes = stlBytes.get();
            Wire wire = (Wire)this.apply(bytes);
            wire.getValueOut().typedMarshallable(marshallable);
            IOTools.writeFile(tempFilename, bytes.toByteArray());
        }
        @NotNull File file2 = new File(tempFilename);
        if (!file2.renameTo(new File(filename))) {
            file2.delete();
            throw new IOException("Failed to rename " + tempFilename + " to " + filename);
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    String asHexString(Object marshallable) {
        ValidatableUtil.startValidateDisabled();
        try {
            try (ScopedResource<Bytes<Void>> stlBytes = Wires.acquireBytesScoped();){
                Bytes<Void> bytes = stlBytes.get();
                this.asBytes(marshallable, bytes);
                String string = bytes.toHexString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ValidatableUtil.endValidateDisabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <T> T fromHexString(@NotNull CharSequence s) throws InvalidMarshallableException {
        Bytes<?> bytes = Bytes.fromHexString(s.toString());
        try {
            Wire wire = (Wire)this.apply(bytes);
            Object t = wire.getValueIn().typedMarshallable();
            return t;
        }
        finally {
            bytes.releaseLast();
        }
    }

    @Nullable
    public Map<String, Object> asMap(@NotNull CharSequence cs) throws InvalidMarshallableException {
        try (ScopedResource<Bytes<Void>> stlBytes = Wires.acquireBytesScoped();){
            Bytes<Void> bytes = stlBytes.get();
            bytes.appendUtf8(cs);
            Wire wire = (Wire)this.apply(bytes);
            Map<String, Object> map = wire.getValueIn().marshallableAsMap(String.class, Object.class);
            return map;
        }
    }

    @Override
    public void licenceCheck() {
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    static {
        COMPRESSED_SIZE = Integer.getInteger("WireType.compressedSize", 128);
    }
}

