/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader.queueentryreaders;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.reader.MessageConsumer;
import net.openhft.chronicle.queue.reader.QueueEntryReader;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;

public final class MethodReaderQueueEntryReader
implements QueueEntryReader {
    private final ExcerptTailer tailer;
    private final MessageConsumer messageConsumer;
    private final MethodReader methodReader;
    private final Bytes<ByteBuffer> bytes;

    public MethodReaderQueueEntryReader(ExcerptTailer tailer, MessageConsumer messageConsumer, WireType wireType, Class<?> methodReaderInterface, boolean showMessageHistory) {
        this.tailer = tailer;
        this.messageConsumer = messageConsumer;
        this.bytes = Bytes.elasticHeapByteBuffer(256);
        Wire wire = (Wire)wireType.apply(this.bytes);
        if (wire instanceof TextWire) {
            ((TextWire)wire).useTextDocuments();
        }
        MethodWriterBuilder<?> mwb = wire.methodWriterBuilder(methodReaderInterface);
        if (showMessageHistory) {
            mwb.updateInterceptor((methodName, t) -> {
                MessageHistory messageHistory = MessageHistory.get();
                if (messageHistory.sources() != 1 || messageHistory.timings() != 1) {
                    this.bytes.append(messageHistory + System.lineSeparator());
                }
                return true;
            });
        }
        this.methodReader = tailer.methodReader(mwb.build());
    }

    @Override
    public boolean read() {
        if (!this.methodReader.readOne()) {
            return false;
        }
        if (this.bytes.isEmpty()) {
            return false;
        }
        this.messageConsumer.consume(this.tailer.lastReadIndex(), this.bytes.toString());
        this.bytes.clear();
        return true;
    }
}

