/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListing;

final class FileSystemDirectoryListing
extends SimpleCloseable
implements DirectoryListing {
    private final File queueDir;
    private final ToIntFunction<String> fileNameToCycleFunction;
    private final TimeProvider time;
    private int minCreatedCycle = Integer.MAX_VALUE;
    private int maxCreatedCycle = Integer.MIN_VALUE;
    private long lastRefreshTimeMS;

    FileSystemDirectoryListing(File queueDir, ToIntFunction<String> fileNameToCycleFunction, TimeProvider time) {
        this.queueDir = queueDir;
        this.fileNameToCycleFunction = fileNameToCycleFunction;
        this.time = time;
    }

    @Override
    public void onFileCreated(File file, int cycle) {
        this.onRoll(cycle);
    }

    @Override
    public void refresh(boolean force) {
        this.lastRefreshTimeMS = this.time.currentTimeMillis();
        String[] fileNamesList = this.queueDir.list();
        String minFilename = TableDirectoryListing.INITIAL_MIN_FILENAME;
        String maxFilename = TableDirectoryListing.INITIAL_MAX_FILENAME;
        if (fileNamesList != null) {
            for (String fileName : fileNamesList) {
                if (!fileName.endsWith(".cq4")) continue;
                if (minFilename.compareTo(fileName) > 0) {
                    minFilename = fileName;
                }
                if (maxFilename.compareTo(fileName) >= 0) continue;
                maxFilename = fileName;
            }
        }
        int min = Integer.MAX_VALUE;
        if (!TableDirectoryListing.INITIAL_MIN_FILENAME.equals(minFilename)) {
            min = this.fileNameToCycleFunction.applyAsInt(minFilename);
        }
        int max = Integer.MIN_VALUE;
        if (!TableDirectoryListing.INITIAL_MAX_FILENAME.equals(maxFilename)) {
            max = this.fileNameToCycleFunction.applyAsInt(maxFilename);
        }
        this.minCreatedCycle = min;
        this.maxCreatedCycle = max;
    }

    @Override
    public long lastRefreshTimeMS() {
        return this.lastRefreshTimeMS;
    }

    @Override
    public int getMinCreatedCycle() {
        return this.minCreatedCycle;
    }

    @Override
    public int getMaxCreatedCycle() {
        return this.maxCreatedCycle;
    }

    @Override
    public long modCount() {
        return -1L;
    }

    @Override
    public void onRoll(int cycle) {
        this.minCreatedCycle = Math.min(this.minCreatedCycle, cycle);
        this.maxCreatedCycle = Math.max(this.maxCreatedCycle, cycle);
    }
}

