/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.ChronicleInit;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.internal.AnnotationFinder;
import net.openhft.chronicle.core.internal.Bootstrap;
import net.openhft.chronicle.core.internal.ClassUtil;
import net.openhft.chronicle.core.internal.CpuClass;
import net.openhft.chronicle.core.internal.PackageNameUtil;
import net.openhft.chronicle.core.internal.util.DirectBufferUtil;
import net.openhft.chronicle.core.internal.util.MapUtil;
import net.openhft.chronicle.core.onoes.ChainedExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.onoes.NullExceptionHandler;
import net.openhft.chronicle.core.onoes.RecordingExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.onoes.ThreadLocalisedExceptionHandler;
import net.openhft.chronicle.core.util.ClassMetrics;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import net.openhft.posix.PosixAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.Unsafe;

public final class Jvm {
    public static final String JAVA_CLASS_PATH = "java.class.path";
    public static final String SYSTEM_PROPERTIES = "system.properties";
    private static final ExceptionHandler DEFAULT_ERROR_EXCEPTION_HANDLER;
    private static final ExceptionHandler DEFAULT_WARN_EXCEPTION_HANDLER;
    private static final ExceptionHandler DEFAULT_PERF_EXCEPTION_HANDLER;
    private static final ExceptionHandler DEFAULT_DEBUG_EXCEPTION_HANDLER;
    private static final String PROC = "/proc";
    private static final List<String> INPUT_ARGUMENTS;
    private static final String INPUT_ARGUMENTS2;
    private static final boolean IS_DEBUG;
    private static final boolean IS_FLIGHT_RECORDER;
    private static final boolean IS_COVERAGE;
    private static final int COMPILE_THRESHOLD;
    private static final boolean REPORT_UNOPTIMISED;
    private static final Supplier<Long> reservedMemory;
    private static final boolean DISABLE_DEBUG;
    @NotNull
    private static final ThreadLocalisedExceptionHandler ERROR;
    @NotNull
    private static final ThreadLocalisedExceptionHandler WARN;
    @NotNull
    private static final ThreadLocalisedExceptionHandler PERF;
    @NotNull
    private static final ExceptionHandler DEBUG;
    private static final long MAX_DIRECT_MEMORY;
    private static final boolean SAFEPOINT_ENABLED;
    private static final Map<Class<?>, ClassMetrics> CLASS_METRICS_MAP;
    private static final Map<Class<?>, Integer> PRIMITIVE_SIZE;
    private static final MethodHandle onSpinWaitMH;
    private static final ChainedSignalHandler signalHandlerGlobal;
    private static boolean RESOURCE_TRACING;
    private static final boolean PROC_EXISTS;
    private static volatile Thread s_blackHole;

    private static MethodHandle getOnSpinWait() {
        MethodType voidType = MethodType.methodType(Void.TYPE);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            if (Jvm.isJava9Plus()) {
                return lookup.findStatic(Thread.class, "onSpinWait", voidType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return lookup.findStatic(Safepoint.class, "force", voidType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Jvm() {
    }

    public static void reportUnoptimised() {
        if (!REPORT_UNOPTIMISED) {
            return;
        }
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stes.length && !stes[i++].getMethodName().equals("reportUnoptimised")) {
        }
        while (i < stes.length && !stes[i++].getMethodName().equals("<clinit>")) {
        }
        Jvm.warn().on(Jvm.class, "Reporting usage of unoptimised method " + stes[i]);
    }

    private static void findAndLoadSystemProperties() {
        String systemProperties = Jvm.getProperty(SYSTEM_PROPERTIES);
        boolean wasSet = true;
        if (systemProperties == null) {
            if (new File(SYSTEM_PROPERTIES).exists()) {
                systemProperties = SYSTEM_PROPERTIES;
            } else if (new File("../system.properties").exists()) {
                systemProperties = "../system.properties";
            } else {
                systemProperties = SYSTEM_PROPERTIES;
                wasSet = false;
            }
        }
        Jvm.loadSystemProperties(systemProperties, wasSet);
    }

    public static void init() {
        ChronicleInit.init();
    }

    private static void loadSystemProperties(String name, boolean wasSet) {
        try {
            File file;
            InputStream is0;
            ClassLoader classLoader = Jvm.class.getClassLoader();
            InputStream inputStream = is0 = classLoader == null ? null : classLoader.getResourceAsStream(name);
            if (is0 == null && (file = new File(name)).exists()) {
                is0 = new FileInputStream(file);
            }
            try (InputStream is = is0;){
                if (is == null) {
                    (wasSet ? Slf4jExceptionHandler.WARN : Slf4jExceptionHandler.DEBUG).on(Jvm.class, "No " + name + " file found");
                } else {
                    Properties prop = new Properties();
                    prop.load(is);
                    prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o, o2) -> System.getProperties().putIfAbsent(o, o2)));
                    Slf4jExceptionHandler.DEBUG.on(Jvm.class, "Loaded " + name + " with " + prop);
                }
            }
        }
        catch (Exception e) {
            Slf4jExceptionHandler.WARN.on(Jvm.class, "Error loading " + name, (Throwable)e);
        }
    }

    private static int getCompileThreshold0() {
        for (String inputArgument : INPUT_ARGUMENTS) {
            String prefix = "-XX:CompileThreshold=";
            if (!inputArgument.startsWith("-XX:CompileThreshold=")) continue;
            try {
                return Integer.parseInt(inputArgument.substring("-XX:CompileThreshold=".length()));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 10000;
    }

    public static int compileThreshold() {
        return COMPILE_THRESHOLD;
    }

    public static int majorVersion() {
        return Bootstrap.getJvmJavaMajorVersion();
    }

    public static boolean isJava9Plus() {
        return Bootstrap.isJava9Plus();
    }

    public static boolean isJava12Plus() {
        return Bootstrap.isJava12Plus();
    }

    public static boolean isJava14Plus() {
        return Bootstrap.isJava14Plus();
    }

    public static boolean isJava15Plus() {
        return Bootstrap.isJava15Plus();
    }

    public static boolean isJava19Plus() {
        return Bootstrap.isJava19Plus();
    }

    public static boolean isJava20Plus() {
        return Bootstrap.isJava20Plus();
    }

    public static boolean isJava21Plus() {
        return Bootstrap.isJava21Plus();
    }

    public static int getProcessId() {
        return Bootstrap.PROCESS_ID;
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid != null) {
            try {
                return Integer.parseInt(pid);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int rpid = 1;
        System.err.println(Jvm.class.getName() + ": Unable to determine PID, picked 1 as a PID");
        return rpid;
    }

    @NotNull
    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void trimStackTrace(@NotNull StringBuilder stringBuilder, StackTraceElement ... stackTraceElements) {
        int first = Jvm.trimFirst(stackTraceElements);
        int last = Jvm.trimLast(first, stackTraceElements);
        for (int i = first; i <= last; ++i) {
            stringBuilder.append("\n\tat ").append(stackTraceElements[i]);
        }
    }

    static int trimFirst(@NotNull StackTraceElement[] stes) {
        int first;
        if (stes.length > 2 && stes[1].getMethodName().endsWith("afepoint")) {
            return 2;
        }
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        return Math.max(0, first - 2);
    }

    public static int trimLast(int first, @NotNull StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    static boolean isInternal(@NotNull String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static boolean isFlightRecorder() {
        return IS_FLIGHT_RECORDER;
    }

    public static boolean isCodeCoverage() {
        return IS_COVERAGE;
    }

    public static void pause(long durationMs) {
        if (durationMs <= 0L) {
            Thread.yield();
            return;
        }
        try {
            Thread.sleep(durationMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void nanoPause() {
        try {
            if (onSpinWaitMH != null) {
                onSpinWaitMH.invokeExact();
            }
        }
        catch (Throwable throwable) {
            Jvm.rethrow(throwable);
        }
    }

    public static void busyWaitMicros(long durationUs) {
        Jvm.busyWaitUntil(System.nanoTime() + durationUs * 1000L);
    }

    public static void busyWaitUntil(long waitUntilNs) {
        while (waitUntilNs > System.nanoTime()) {
            Jvm.nanoPause();
        }
    }

    @NotNull
    public static Field getField(@NotNull Class<?> clazz, @NotNull String fieldName) {
        return ClassUtil.getField0(clazz, fieldName, true);
    }

    @Nullable
    public static Field getFieldOrNull(@NotNull Class<?> clazz, @NotNull String fieldName) {
        return ClassUtil.getField0(clazz, fieldName, false);
    }

    @NotNull
    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... argTypes) {
        return ClassUtil.getMethod0(clazz, methodName, argTypes, true);
    }

    public static void setAccessible(@NotNull AccessibleObject accessibleObject) {
        ClassUtil.setAccessible(accessibleObject);
    }

    @Nullable
    public static <V> V getValue(@NotNull Object target, @NotNull String fieldName) {
        Class<?> aClass = target.getClass();
        for (String n : fieldName.split("/")) {
            Field f = Jvm.getField(aClass, n);
            try {
                target = f.get(target);
                if (target == null) {
                    return null;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            aClass = target.getClass();
        }
        return (V)Jvm.uncheckedCast(target);
    }

    public static String lockWithStack(@NotNull ReentrantLock lock) {
        Thread t = (Thread)Jvm.getValue(lock, "sync/exclusiveOwnerThread");
        if (t == null) {
            return lock.toString();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(lock).append(" running at");
        Jvm.trimStackTrace(ret, t.getStackTrace());
        return ret.toString();
    }

    public static long fieldOffset(Class<?> clazz, String fieldName) {
        try {
            return UnsafeMemory.UNSAFE.objectFieldOffset(clazz.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long usedDirectMemory() {
        return reservedMemory.get();
    }

    public static long usedNativeMemory() {
        return UnsafeMemory.INSTANCE.nativeMemoryUsed();
    }

    public static long maxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }

    public static boolean is64bit() {
        return Bootstrap.IS_64BIT;
    }

    public static void resetExceptionHandlers() {
        Jvm.setErrorExceptionHandler(DEFAULT_ERROR_EXCEPTION_HANDLER);
        Jvm.setWarnExceptionHandler(DEFAULT_WARN_EXCEPTION_HANDLER);
        Jvm.setDebugExceptionHandler(DEFAULT_DEBUG_EXCEPTION_HANDLER);
        Jvm.setPerfExceptionHandler(DEFAULT_PERF_EXCEPTION_HANDLER);
    }

    public static void setErrorExceptionHandler(ExceptionHandler exceptionHandler) {
        ERROR.defaultHandler(exceptionHandler).resetThreadLocalHandler();
    }

    public static void setWarnExceptionHandler(ExceptionHandler exceptionHandler) {
        WARN.defaultHandler(exceptionHandler).resetThreadLocalHandler();
    }

    public static void setDebugExceptionHandler(ExceptionHandler exceptionHandler) {
        if (DEBUG instanceof ThreadLocalisedExceptionHandler) {
            ((ThreadLocalisedExceptionHandler)DEBUG).defaultHandler(exceptionHandler).resetThreadLocalHandler();
        }
    }

    public static void setPerfExceptionHandler(ExceptionHandler exceptionHandler) {
        PERF.defaultHandler(exceptionHandler).resetThreadLocalHandler();
    }

    public static void disableDebugHandler() {
        Jvm.setDebugExceptionHandler(null);
    }

    public static void disablePerfHandler() {
        Jvm.setPerfExceptionHandler(null);
    }

    public static void disableWarnHandler() {
        Jvm.setWarnExceptionHandler(null);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions() {
        return Jvm.recordExceptions(true);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug) {
        return Jvm.recordExceptions(debug, false);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug, boolean exceptionsOnly) {
        return Jvm.recordExceptions(debug, exceptionsOnly, true);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug, boolean exceptionsOnly, boolean logToSlf4j) {
        Map<ExceptionKey, Integer> map = Collections.synchronizedMap(new LinkedHashMap());
        Jvm.setErrorExceptionHandler(Jvm.recordingExceptionHandler(LogLevel.ERROR, map, exceptionsOnly, logToSlf4j));
        Jvm.setWarnExceptionHandler(Jvm.recordingExceptionHandler(LogLevel.WARN, map, exceptionsOnly, logToSlf4j));
        Jvm.setPerfExceptionHandler((ExceptionHandler)(debug ? Jvm.recordingExceptionHandler(LogLevel.PERF, map, exceptionsOnly, logToSlf4j) : (logToSlf4j ? Slf4jExceptionHandler.PERF : NullExceptionHandler.NOTHING)));
        Jvm.setDebugExceptionHandler((ExceptionHandler)(debug ? Jvm.recordingExceptionHandler(LogLevel.DEBUG, map, exceptionsOnly, logToSlf4j) : (logToSlf4j ? Slf4jExceptionHandler.DEBUG : NullExceptionHandler.NOTHING)));
        return map;
    }

    private static ExceptionHandler recordingExceptionHandler(LogLevel logLevel, Map<ExceptionKey, Integer> map, boolean exceptionsOnly, boolean logToSlf4j) {
        RecordingExceptionHandler eh = new RecordingExceptionHandler(logLevel, map, exceptionsOnly);
        if (logToSlf4j) {
            return new ChainedExceptionHandler(eh, Slf4jExceptionHandler.valueOf(logLevel));
        }
        return eh;
    }

    public static boolean hasException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        for (ExceptionKey k : exceptions.keySet()) {
            if (k.level() == LogLevel.DEBUG || k.level() == LogLevel.PERF) continue;
            return true;
        }
        return false;
    }

    public static void setExceptionHandlers(@Nullable ExceptionHandler error, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        ERROR.defaultHandler(error);
        WARN.defaultHandler(warn);
        if (DEBUG instanceof ThreadLocalisedExceptionHandler) {
            ((ThreadLocalisedExceptionHandler)DEBUG).defaultHandler(debug);
        }
    }

    public static void setExceptionHandlers(@Nullable ExceptionHandler error, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug, @Nullable ExceptionHandler perf) {
        Jvm.setExceptionHandlers(error, warn, debug);
        PERF.defaultHandler(perf);
    }

    public static void setThreadLocalExceptionHandlers(@Nullable ExceptionHandler error, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        ERROR.threadLocalHandler(error);
        WARN.threadLocalHandler(warn);
        if (DEBUG instanceof ThreadLocalisedExceptionHandler) {
            ((ThreadLocalisedExceptionHandler)DEBUG).threadLocalHandler(debug);
        }
    }

    public static void setThreadLocalExceptionHandlers(@Nullable ExceptionHandler error, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug, @Nullable ExceptionHandler perf) {
        Jvm.setThreadLocalExceptionHandlers(error, warn, debug);
        PERF.threadLocalHandler(perf);
    }

    @NotNull
    public static ExceptionHandler error() {
        return ERROR;
    }

    @NotNull
    public static ExceptionHandler warn() {
        return WARN;
    }

    @NotNull
    public static ExceptionHandler startup() {
        return PERF;
    }

    @NotNull
    public static ExceptionHandler perf() {
        return PERF;
    }

    @NotNull
    public static ExceptionHandler debug() {
        return DEBUG;
    }

    public static void dumpException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        Slf4jExceptionHandler warn = Slf4jExceptionHandler.WARN;
        for (Map.Entry<ExceptionKey, Integer> entry : exceptions.entrySet()) {
            ExceptionKey key = entry.getKey();
            warn.on(Jvm.class, (Object)((Object)key.level()) + " " + key.clazz().getSimpleName() + " " + key.message(), key.throwable());
            Integer value = entry.getValue();
            if (value <= 1) continue;
            warn.on(Jvm.class, "Repeated " + value + " times");
        }
        Jvm.resetExceptionHandlers();
    }

    public static boolean isDebugEnabled(Class<?> aClass) {
        return DEBUG.isEnabled(aClass);
    }

    public static boolean isPerfEnabled(Class<?> aClass) {
        return PERF.isEnabled(aClass);
    }

    private static long maxDirectMemory0() {
        try {
            Class<?> clz = Jvm.isJava9Plus() ? Class.forName("jdk.internal.misc.VM") : Class.forName("sun.misc.VM");
            Field f = Jvm.getField(clz, "directMemory");
            return f.getLong(null);
        }
        catch (Exception exception) {
            System.err.println(Jvm.class.getName() + ": Unable to determine max direct memory");
            return 0L;
        }
    }

    public static void addSignalHandler(SignalHandler signalHandler) {
        SignalHandler signalHandler2 = signal -> {
            Jvm.warn().on(signalHandler.getClass(), "Signal " + signal + " triggered for " + signalHandler);
            signalHandler.handle(signal);
        };
        Jvm.signalHandlerGlobal.handlers2.add(signalHandler2);
        InitSignalHandlers.init();
    }

    public static void safepoint() {
        if (SAFEPOINT_ENABLED) {
            if (Jvm.isAzulZing()) {
                s_blackHole = Thread.currentThread();
            }
            Safepoint.force();
        }
    }

    public static boolean areOptionalSafepointsEnabled() {
        return SAFEPOINT_ENABLED;
    }

    public static boolean stackTraceEndsWith(String endsWith, int maxDepth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = maxDepth + 2; i < stackTrace.length; ++i) {
            if (!stackTrace[i].getClassName().endsWith(endsWith)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArm() {
        return Bootstrap.IS_ARM;
    }

    public static boolean isMacArm() {
        return Bootstrap.IS_MAC_ARM;
    }

    @NotNull
    public static ClassMetrics classMetrics(Class<?> clazz) throws IllegalArgumentException {
        return CLASS_METRICS_MAP.computeIfAbsent(clazz, Jvm::getClassMetrics);
    }

    private static ClassMetrics getClassMetrics(Class<?> c) {
        assert (!c.isArray());
        Class<?> superclass = c.getSuperclass();
        int start = Integer.MAX_VALUE;
        int end = 0;
        for (Field f : c.getDeclaredFields()) {
            if ((f.getModifiers() & 0x88) != 0 || !f.getType().isPrimitive()) continue;
            int start0 = Math.toIntExact(UnsafeMemory.unsafeObjectFieldOffset(f));
            int size = PRIMITIVE_SIZE.get(f.getType());
            start = Math.min(start0, start);
            end = Math.max(start0 + size, end);
        }
        if (superclass != null && superclass != Object.class) {
            ClassMetrics cm0 = Jvm.getClassMetrics(superclass);
            start = Math.min(cm0.offset(), start);
            end = Math.max(cm0.offset() + cm0.length(), end);
            Jvm.validateClassMetrics(superclass, start, end);
        }
        Jvm.validateClassMetrics(c, start, end);
        return new ClassMetrics(start, end - start);
    }

    private static void validateClassMetrics(Class<?> c, int start, int end) {
        for (Field f : c.getDeclaredFields()) {
            int start0;
            if ((f.getModifiers() & 8) != 0 || f.getType().isPrimitive() || start > (start0 = Math.toIntExact(UnsafeMemory.unsafeObjectFieldOffset(f))) || start0 >= end) continue;
            Jvm.rethrow(new IllegalArgumentException(c + " is not suitable for raw copies due to " + f));
        }
    }

    @NotNull
    public static String userHome() {
        return System.getProperty("user.home", ".");
    }

    public static boolean dontChain(Class<?> tClass) {
        return tClass.getAnnotation(DontChain.class) != null || tClass.getName().startsWith("java");
    }

    public static boolean isResourceTracing() {
        return RESOURCE_TRACING;
    }

    public static void setResourceTracing(boolean resourceTracing) {
        RESOURCE_TRACING = resourceTracing;
    }

    public static String getProperty(String systemPropertyKey) {
        Jvm.init();
        return System.getProperty(systemPropertyKey);
    }

    public static String getProperty(String systemPropertyKey, String defaultValue) {
        Jvm.init();
        return System.getProperty(systemPropertyKey, defaultValue);
    }

    public static Long getLong(String systemPropertyKey, Long defVal) {
        Jvm.init();
        return Long.getLong(systemPropertyKey, defVal);
    }

    public static Integer getInteger(String systemPropertyKey, Integer defVal) {
        Jvm.init();
        return Integer.getInteger(systemPropertyKey, defVal);
    }

    public static boolean getBoolean(String systemPropertyKey) {
        return Jvm.getBoolean(systemPropertyKey, false);
    }

    public static boolean getBoolean(String systemPropertyKey, boolean defaultValue) {
        String value = Jvm.getProperty(systemPropertyKey);
        if (value == null) {
            return defaultValue;
        }
        if (value.isEmpty()) {
            return true;
        }
        String trim = value.trim();
        return defaultValue ? !ObjectUtils.isFalse(trim) : ObjectUtils.isTrue(trim);
    }

    public static long parseSize(@NotNull String value) throws IllegalArgumentException {
        long factor = 1L;
        if (value.length() > 1) {
            char last = value.charAt(value.length() - 1);
            if (last == 'b' || last == 'B') {
                value = value.substring(0, value.length() - 1);
                last = value.charAt(value.length() - 1);
            }
            if (last == 'i') {
                value = value.substring(0, value.length() - 1);
                last = value.charAt(value.length() - 1);
            }
            if (Character.isLetter(last)) {
                switch (last) {
                    case 'T': 
                    case 't': {
                        factor = 0x10000000000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        factor = 0x40000000L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        factor = 0x100000L;
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        factor = 1024L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognised suffix for size " + value);
                    }
                }
                value = value.substring(0, value.length() - 1);
            }
        }
        double number = Double.parseDouble(value.trim());
        return Math.round((double)factor * number);
    }

    public static long getSize(String property, long defaultValue) {
        String value = Jvm.getProperty(property);
        if (value == null || value.length() <= 0) {
            return defaultValue;
        }
        try {
            return Jvm.parseSize(value);
        }
        catch (IllegalArgumentException iae) {
            Jvm.warn().on(Jvm.class, "Unable to parse the property " + property + " as a size " + iae.getMessage() + " using " + defaultValue);
            return defaultValue;
        }
    }

    public static long address(@NotNull ByteBuffer byteBuffer) {
        return DirectBufferUtil.addressOrThrow(byteBuffer);
    }

    public static int arrayByteBaseOffset() {
        return Unsafe.ARRAY_BYTE_BASE_OFFSET;
    }

    public static void doNotCloseOnInterrupt(Class<?> clazz, FileChannel fc) {
        if (Jvm.isJava9Plus()) {
            Jvm.doNotCloseOnInterrupt9(clazz, fc);
        } else {
            Jvm.doNotCloseOnInterrupt8(clazz, fc);
        }
    }

    private static void doNotCloseOnInterrupt8(Class<?> clazz, FileChannel fc) {
        try {
            Field field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            ClassUtil.setAccessible(field);
            CommonInterruptible ci = new CommonInterruptible(clazz, fc);
            field.set(fc, thread -> ci.interrupt());
        }
        catch (Throwable e) {
            Jvm.warn().on(clazz, "Couldn't disable close on interrupt", e);
        }
    }

    private static void doNotCloseOnInterrupt9(Class<?> clazz, FileChannel fc) {
        try {
            Field field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            Class<?> interruptibleClass = field.getType();
            ClassUtil.setAccessible(field);
            CommonInterruptible ci = new CommonInterruptible(clazz, fc);
            Class[] interfaces = new Class[]{interruptibleClass};
            field.set(fc, Proxy.newProxyInstance(interruptibleClass.getClassLoader(), interfaces, (p, m, a) -> {
                if (m.getDeclaringClass() != Object.class) {
                    ci.interrupt();
                }
                return ObjectUtils.defaultValue(m.getReturnType());
            }));
        }
        catch (Throwable e) {
            Jvm.warn().on(clazz, "Couldn't disable close on interrupt", e);
        }
    }

    public static void addToClassPath(@NotNull Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (!(cl instanceof URLClassLoader)) {
            return;
        }
        String property = Jvm.getProperty(JAVA_CLASS_PATH);
        LinkedHashSet jcp = new LinkedHashSet();
        Collections.addAll(jcp, property.split(File.pathSeparator));
        jcp.addAll(jcp.stream().map(f -> new File((String)f).getAbsolutePath()).collect(Collectors.toList()));
        URLClassLoader ucl = (URLClassLoader)cl;
        StringBuilder classpath = new StringBuilder(property);
        for (URL url : ucl.getURLs()) {
            try {
                String path = Paths.get(url.toURI()).toString();
                if (jcp.contains(path)) continue;
                if (Jvm.isDebugEnabled(Jvm.class)) {
                    Jvm.debug().on(Jvm.class, "Adding " + path + " to the classpath");
                }
                classpath.append(File.pathSeparator).append(path);
            }
            catch (Throwable e) {
                Jvm.debug().on(Jvm.class, "Could not add URL " + url + " to classpath");
            }
        }
        System.setProperty(JAVA_CLASS_PATH, classpath.toString());
    }

    public static double getDouble(String systemPropertyKey, double defaultValue) {
        String value = Jvm.getProperty(systemPropertyKey);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                Jvm.debug().on(Jvm.class, "Unable to parse property " + systemPropertyKey + " as a double " + e);
            }
        }
        return defaultValue;
    }

    public static boolean isProcessAlive(long pid) {
        if (OS.isWindows()) {
            String command = "cmd /c tasklist /FI \"PID eq " + pid + "\"";
            return Jvm.isProcessAlive0(pid, command);
        }
        if (OS.isLinux() && PROC_EXISTS) {
            return new File("/proc/" + pid).exists();
        }
        if (OS.isMacOSX() || OS.isLinux()) {
            String command = "ps -p " + pid;
            return Jvm.isProcessAlive0(pid, command);
        }
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    private static boolean isProcessAlive0(long pid, String command) {
        try {
            String strLine;
            InputStreamReader isReader = new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream());
            BufferedReader bReader = new BufferedReader(isReader);
            while ((strLine = bReader.readLine()) != null) {
                if (!strLine.contains(" " + pid + " ") && !strLine.startsWith(pid + " ")) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public static boolean isAzulZing() {
        return Bootstrap.IS_AZUL_ZING;
    }

    public static boolean isAzulZulu() {
        return Bootstrap.IS_AZUL_ZULU;
    }

    public static String getCpuClass() {
        return CpuClass.getCpuModel();
    }

    public static boolean isAssertEnabled() {
        return Bootstrap.ASSERT_ENABLED;
    }

    public static boolean supportThread() {
        String name = Thread.currentThread().getName();
        return "Finalizer".equals(name) || name.contains("~");
    }

    public static void park() {
        while (!Thread.currentThread().isInterrupted()) {
            LockSupport.park();
        }
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return AnnotationFinder.findAnnotation(annotatedElement, annotationType);
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        if (!clazz.isSynthetic()) {
            return false;
        }
        return clazz.getName().contains("$$Lambda");
    }

    public static <T> T uncheckedCast(Object o) {
        return (T)o;
    }

    public static <T> T[] uncheckedCast(Object[] o) {
        return o;
    }

    public static <T> Class<T> uncheckedCast(Class<?> o) {
        return o;
    }

    public static long currentThreadId() {
        return Thread.currentThread().getId();
    }

    public static String getPackageName(Class clazz) {
        return PackageNameUtil.getPackageName(clazz);
    }

    private static boolean isJUnitTest0() {
        for (StackTraceElement[] stackTrace : Thread.getAllStackTraces().values()) {
            for (StackTraceElement element : stackTrace) {
                if (!element.getClassName().contains(".junit")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Supplier<Long> reservedMemoryGetter;
        DEFAULT_ERROR_EXCEPTION_HANDLER = Slf4jExceptionHandler.ERROR;
        DEFAULT_WARN_EXCEPTION_HANDLER = Slf4jExceptionHandler.WARN;
        DEFAULT_PERF_EXCEPTION_HANDLER = Slf4jExceptionHandler.PERF;
        DEFAULT_DEBUG_EXCEPTION_HANDLER = Slf4jExceptionHandler.DEBUG;
        INPUT_ARGUMENTS = ManagementFactory.getRuntimeMXBean().getInputArguments();
        INPUT_ARGUMENTS2 = " " + String.join((CharSequence)" ", INPUT_ARGUMENTS);
        IS_DEBUG = Jvm.getBoolean("debug", INPUT_ARGUMENTS2.contains("jdwp"));
        IS_FLIGHT_RECORDER = Jvm.getBoolean("jfr", INPUT_ARGUMENTS2.contains(" -XX:+FlightRecorder"));
        IS_COVERAGE = INPUT_ARGUMENTS2.contains("coverage");
        COMPILE_THRESHOLD = Jvm.getCompileThreshold0();
        DISABLE_DEBUG = Jvm.getBoolean("disable.debug.info");
        ERROR = new ThreadLocalisedExceptionHandler(DEFAULT_ERROR_EXCEPTION_HANDLER);
        WARN = new ThreadLocalisedExceptionHandler(DEFAULT_WARN_EXCEPTION_HANDLER);
        PERF = new ThreadLocalisedExceptionHandler(DEFAULT_PERF_EXCEPTION_HANDLER);
        CLASS_METRICS_MAP = new ConcurrentHashMap();
        PRIMITIVE_SIZE = MapUtil.ofUnmodifiable(MapUtil.entry(Boolean.TYPE, 1), MapUtil.entry(Byte.TYPE, 1), MapUtil.entry(Character.TYPE, 2), MapUtil.entry(Short.TYPE, 2), MapUtil.entry(Integer.TYPE, 4), MapUtil.entry(Float.TYPE, 4), MapUtil.entry(Long.TYPE, 8), MapUtil.entry(Double.TYPE, 8));
        PROC_EXISTS = new File(PROC).exists();
        Logger logger = LoggerFactory.getLogger(Jvm.class);
        if (!Jvm.isJUnitTest0()) {
            try {
                PosixAPI.posix();
            }
            catch (Error e) {
                logger.debug("Unable to load PosixAPI ", e);
            }
            try {
                Class.forName("net.openhft.affinity.Affinity");
            }
            catch (ClassNotFoundException e) {
                logger.trace("Unable to load Affinity", e);
            }
        }
        DEBUG = DISABLE_DEBUG ? NullExceptionHandler.NOTHING : new ThreadLocalisedExceptionHandler(DEFAULT_DEBUG_EXCEPTION_HANDLER);
        Jvm.findAndLoadSystemProperties();
        MAX_DIRECT_MEMORY = Jvm.maxDirectMemory0();
        try {
            Field f;
            Class<?> bitsClass = Class.forName("java.nio.Bits");
            Field firstTry = Jvm.getFieldOrNull(bitsClass, "reservedMemory");
            Field field = f = firstTry != null ? firstTry : Jvm.getField(bitsClass, "RESERVED_MEMORY");
            if (f.getType() == AtomicLong.class) {
                AtomicLong reservedMemory = (AtomicLong)f.get(null);
                reservedMemoryGetter = reservedMemory::get;
            } else {
                reservedMemoryGetter = ThrowingSupplier.asSupplier(() -> f.getLong(null));
            }
        }
        catch (Exception e) {
            System.err.println(Jvm.class.getName() + ": Unable to determine the reservedMemory value, will always report 0");
            reservedMemoryGetter = () -> 0L;
        }
        reservedMemory = reservedMemoryGetter;
        signalHandlerGlobal = new ChainedSignalHandler();
        onSpinWaitMH = Jvm.getOnSpinWait();
        boolean disablePerfInfo = Jvm.getBoolean("disable.perf.info");
        if (disablePerfInfo) {
            PERF.defaultHandler(NullExceptionHandler.NOTHING);
        }
        SAFEPOINT_ENABLED = Jvm.getBoolean("jvm.safepoint.enabled");
        RESOURCE_TRACING = Jvm.getBoolean("jvm.resource.tracing");
        if (DISABLE_DEBUG) {
            logger.info("-Ddisable.debug.info turned of debug logging");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Chronicle core loaded from " + Jvm.class.getProtectionDomain().getCodeSource().getLocation());
        }
        if (RESOURCE_TRACING && !Jvm.getBoolean("disable.resource.warning")) {
            logger.warn("Resource tracing is turned on. If you are performance testing or running in PROD you probably don't want this");
        }
        REPORT_UNOPTIMISED = Jvm.getBoolean("report.unoptimised");
        ChronicleInit.postInit();
    }

    static final class ChainedSignalHandler
    implements sun.misc.SignalHandler {
        final List<sun.misc.SignalHandler> handlers = new CopyOnWriteArrayList<sun.misc.SignalHandler>();
        final List<SignalHandler> handlers2 = new CopyOnWriteArrayList<SignalHandler>();

        ChainedSignalHandler() {
        }

        @Override
        public void handle(Signal signal) {
            for (sun.misc.SignalHandler signalHandler : this.handlers) {
                try {
                    if (signalHandler == null) continue;
                    signalHandler.handle(signal);
                }
                catch (Throwable t) {
                    Jvm.warn().on(this.getClass(), "Problem handling signal", t);
                }
            }
            for (SignalHandler signalHandler : this.handlers2) {
                try {
                    if (signalHandler == null) continue;
                    signalHandler.handle(signal.getName());
                }
                catch (Throwable t) {
                    Jvm.warn().on(this.getClass(), "Problem handling signal", t);
                }
            }
        }
    }

    static final class InitSignalHandlers {
        private InitSignalHandlers() {
        }

        static void init() {
        }

        private static void addSignalHandler(String sig, sun.misc.SignalHandler signalHandler) {
            try {
                Signal.handle(new Signal(sig), signalHandler);
            }
            catch (IllegalArgumentException e) {
                Jvm.warn().on(signalHandler.getClass(), "Unable add a signal handler", (Throwable)e);
            }
        }

        static {
            if (!OS.isWindows()) {
                InitSignalHandlers.addSignalHandler("HUP", signalHandlerGlobal);
            }
            InitSignalHandlers.addSignalHandler("INT", signalHandlerGlobal);
            InitSignalHandlers.addSignalHandler("TERM", signalHandlerGlobal);
        }
    }

    static final class Safepoint {
        private static volatile int one = 1;

        private Safepoint() {
        }

        public static void force() {
            for (int i = 0; i < one; ++i) {
            }
        }
    }

    static final class CommonInterruptible {
        static final ThreadLocal<AtomicBoolean> insideTL = ThreadLocal.withInitial(AtomicBoolean::new);
        private final Class<?> clazz;
        private final FileChannel fc;

        CommonInterruptible(Class<?> clazz, FileChannel fc) {
            this.clazz = clazz;
            this.fc = fc;
        }

        public void interrupt() {
            AtomicBoolean inside = insideTL.get();
            if (inside.get()) {
                return;
            }
            inside.set(true);
            boolean interrupted = Thread.currentThread().isInterrupted();
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.clazz, this.fc + " not closed on interrupt, interrupted= " + interrupted);
            }
            inside.set(false);
        }
    }

    public static interface SignalHandler {
        public void handle(String var1);
    }
}

