/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.UnsafeCloseable;
import org.jetbrains.annotations.NotNull;

public class UncheckedLongReference
extends UnsafeCloseable
implements LongReference,
ReferenceOwner {
    private BytesStore<?, ?> bytes;

    @NotNull
    public static LongReference create(@NotNull BytesStore<?, ?> bytesStore, @NonNegative long offset, @NonNegative int size) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IllegalStateException {
        @NotNull AbstractCloseable ref = Jvm.isDebug() ? new BinaryLongReference() : new UncheckedLongReference();
        ref.bytesStore(bytesStore, offset, size);
        return ref;
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException, IllegalArgumentException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        if (this.bytes != bytes) {
            if (this.bytes != null) {
                this.bytes.release(this);
            }
            this.bytes = bytes;
            bytes.reserve(this);
        }
        this.address(bytes.addressForRead(offset));
    }

    @Override
    @NotNull
    public BytesStore<?, ?> bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.address;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.address == 0L) {
            return "addressForRead is 0";
        }
        try {
            return "value: " + this.getValue();
        }
        catch (Throwable e) {
            return "value: " + e;
        }
    }

    @Override
    public long getValue() throws IllegalStateException {
        return this.getLong();
    }

    @Override
    public void setValue(long value) throws IllegalStateException {
        this.setLong(value);
    }

    @Override
    public long getVolatileValue() throws IllegalStateException {
        return this.getVolatileLong();
    }

    @Override
    public void setVolatileValue(long value) throws IllegalStateException {
        this.setVolatileLong(value);
    }

    @Override
    public long getVolatileValue(long closedValue) {
        return this.getVolatileLong(closedValue);
    }

    @Override
    public void setOrderedValue(long value) throws IllegalStateException {
        this.setOrderedLong(value);
    }

    @Override
    public long addValue(long delta) throws IllegalStateException {
        return this.addLong(delta);
    }

    @Override
    public long addAtomicValue(long delta) throws IllegalStateException {
        return this.addAtomicLong(delta);
    }

    @Override
    public boolean compareAndSwapValue(long expected, long value) throws IllegalStateException {
        return this.compareAndSwapLong(expected, value);
    }

    @Override
    protected void performClose() throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release(this);
        }
        this.bytes = null;
        super.performClose();
    }
}

