/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Reader;
import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.internal.ByteStringReader;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ByteStringParser<B extends ByteStringParser<B>>
extends StreamingDataInput<B> {
    @NotNull
    default public Reader reader() {
        return new ByteStringReader(this);
    }

    @Nullable
    default public Boolean parseBoolean(@NotNull StopCharTester tester) throws BufferUnderflowException, ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.parseBoolean(this, tester);
    }

    @Nullable
    default public Boolean parseBoolean() throws BufferUnderflowException, ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.parseBoolean(this, StopCharTesters.NON_ALPHA_DIGIT);
    }

    @NotNull
    default public String parseUtf8(@NotNull StopCharTester stopCharTester) throws ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.parseUtf8(this, stopCharTester);
    }

    default public void parseUtf8(@NotNull Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException, ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.parseUtf8((StreamingDataInput)this, buffer, stopCharTester);
    }

    default public void parseUtf8(@NotNull Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, IORuntimeException, ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.parseUtf8((StreamingDataInput)this, buffer, stopCharsTester);
    }

    default public void parse8bit(Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException, BufferOverflowException, ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (buffer instanceof StringBuilder) {
            BytesInternal.parse8bit((StreamingDataInput)this, (StringBuilder)buffer, stopCharTester);
        } else {
            BytesInternal.parse8bit((StreamingDataInput)this, (Bytes)buffer, stopCharTester);
        }
    }

    default public String parse8bit(@NotNull StopCharTester stopCharTester) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.parse8bit(this, stopCharTester);
    }

    default public void parse8bit(Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, BufferOverflowException, ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (buffer instanceof StringBuilder) {
            BytesInternal.parse8bit((StreamingDataInput)this, (StringBuilder)buffer, stopCharsTester);
        } else {
            BytesInternal.parse8bit((StreamingDataInput)this, (Bytes)buffer, stopCharsTester);
        }
    }

    default public void parse8bit(Bytes<?> buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, BufferOverflowException, ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.parse8bit((StreamingDataInput)this, buffer, stopCharsTester);
    }

    default public void parse8bit(StringBuilder buffer, @NotNull StopCharsTester stopCharsTester) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.parse8bit((StreamingDataInput)this, buffer, stopCharsTester);
    }

    default public int parseInt() throws BufferUnderflowException, ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return Maths.toInt32(BytesInternal.parseLong(this));
    }

    default public long parseLong() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.parseLong(this);
    }

    default public long parseFlexibleLong() throws BufferUnderflowException, IORuntimeException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.parseFlexibleLong(this);
    }

    default public float parseFloat() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return (float)BytesInternal.parseDouble(this);
    }

    default public double parseDouble() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.parseDouble(this);
    }

    default public long parseLongDecimal() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.parseLongDecimal(this);
    }

    public int lastDecimalPlaces();

    public void lastDecimalPlaces(int var1);

    public boolean lastNumberHadDigits();

    public void lastNumberHadDigits(boolean var1);

    default public boolean skipTo(@NotNull StopCharTester tester) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        return BytesInternal.skipTo(this, tester);
    }

    @NotNull
    default public BigDecimal parseBigDecimal() throws ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return new BigDecimal(this.parseUtf8(StopCharTesters.NUMBER_END));
    }
}

