/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FieldlessMethodReaderTest
extends QueueTestCommon {
    private final CustomEnumType enumType;
    private final AtomicInteger msgCounter = new AtomicInteger();

    public FieldlessMethodReaderTest(CustomEnumType enumType) {
        this.enumType = enumType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws InterruptedException {
        File path = new File(this.getTmpDir(), "enum_test_" + (Object)((Object)this.enumType));
        try (SingleChronicleQueue chronicle = SingleChronicleQueueBuilder.builder().path(path).wireType(WireType.FIELDLESS_BINARY).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).build();){
            EntityListener writer = (EntityListener)chronicle.methodWriter(EntityListener.class, new Class[0]);
            MethodReader methodReader = chronicle.createTailer().toEnd().methodReader(new Object[]{value -> this.msgCounter.incrementAndGet()});
            CustomEntity entity = new CustomEntity();
            IntStream.range(0, 2).forEach(i -> writer.onMessage(entity.enumType(this.enumType)));
            while (methodReader.readOne()) {
            }
            Assert.assertEquals((long)2L, (long)this.msgCounter.get());
        }
        finally {
            IOTools.deleteDirWithFilesOrWait((long)1000L, (File)path);
        }
    }

    @Parameterized.Parameters
    public static Collection<CustomEnumType> enums() {
        return Stream.concat(Stream.of((CustomEnumType)null), Arrays.stream(CustomEnumType.values())).collect(Collectors.toList());
    }

    static interface EntityListener {
        public void onMessage(CustomEntity var1);
    }

    static class CustomEntity
    extends SelfDescribingMarshallable {
        private CustomEnumType enumType;

        CustomEntity() {
        }

        public CustomEntity enumType(CustomEnumType enumType) {
            this.enumType = enumType;
            return this;
        }
    }

    public static enum CustomEnumType {
        A,
        AA,
        AAA,
        AAAA,
        AAAAA,
        AAAAAA,
        AAAAAAA;

    }
}

