/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.stress.backwardstailer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class BackwardsTailerBoundaryTest
extends QueueTestCommon {
    private static final Logger log = LoggerFactory.getLogger(BackwardsTailerBoundaryTest.class);
    private SetTimeProvider timeProvider;
    private final RollCycle rollCycle;

    public BackwardsTailerBoundaryTest(RollCycle rollCycle) {
        this.rollCycle = rollCycle;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{TestRollCycles.TEST4_DAILY});
        return data;
    }

    @Before
    public void before() {
        this.timeProvider = new SetTimeProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyConsistency() {
        @NotNull File path = this.getTmpDir();
        IOTools.deleteDirWithFiles((File)path);
        try (SingleChronicleQueue queue = this.createQueue(path, this.rollCycle);
             ExcerptAppender appender = queue.createAppender();
             ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD);){
            Assert.assertEquals((String)"Backwards tailer should start at index 0 when no queue data", (long)0L, (long)tailer.index());
            long messagesPerCycle = (long)this.rollCycle.defaultIndexSpacing() * (long)this.rollCycle.defaultIndexCount() * 5L;
            int i = 0;
            while ((long)i < messagesPerCycle * 5L) {
                this.advanceTimeBeforeRollCycleFills(i, messagesPerCycle, queue);
                long lastIndexAppended = BackwardsTailerBoundaryTest.writeDataToQueue(appender, i, queue);
                tailer.toEnd();
                Assert.assertEquals((long)lastIndexAppended, (long)tailer.index());
                tailer.moveToIndex(0L);
                ++i;
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)path);
        }
    }

    private static long writeDataToQueue(ExcerptAppender appender, int i, SingleChronicleQueue queue) {
        appender.writeText((CharSequence)Integer.toString(i));
        long lastIndexAppended = appender.lastIndexAppended();
        int cycle = queue.rollCycle().toCycle(lastIndexAppended);
        long sequenceNumber = queue.rollCycle().toSequenceNumber(lastIndexAppended);
        log.debug("cycle={}, sequenceNumber={}", (Object)cycle, (Object)sequenceNumber);
        return lastIndexAppended;
    }

    private void advanceTimeBeforeRollCycleFills(int i, long messagesPerCycle, SingleChronicleQueue queue) {
        if (i > 0 && (long)i % messagesPerCycle == 0L) {
            log.info("Advancing time to move to next cycle. Current cycle={}", (Object)queue.cycle());
            this.timeProvider.advanceMillis((long)this.rollCycle.lengthInMillis());
        }
    }

    @NotNull
    private SingleChronicleQueue createQueue(File path, RollCycle rollCycle) {
        return SingleChronicleQueueBuilder.builder().timeProvider((TimeProvider)this.timeProvider).path(path).rollCycle(rollCycle).build();
    }
}

