/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MicroToucherTest
extends QueueTestCommon {
    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @Test
    public void touchPageTestBlockSize() {
        this.touchPage(b -> b.blockSize(0x4000000), 66561);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchPage(Consumer<SingleChronicleQueueBuilder> configure, int pagesExpected) {
        long start = System.nanoTime();
        String path = OS.getTarget() + "/touchPage-" + System.nanoTime();
        int pages = 0;
        SingleChronicleQueueBuilder builder = ChronicleQueue.singleBuilder((String)path);
        configure.accept(builder);
        try {
            try (SingleChronicleQueue q = builder.build();
                 StoreAppender appender = (StoreAppender)q.createAppender();){
                Thread msync = new Thread(() -> {
                    try {
                        while (true) {
                            appender.bgMicroTouch();
                            Jvm.pause((long)25L);
                        }
                    }
                    catch (ClosedIllegalStateException closedIllegalStateException) {
                        return;
                    }
                });
                msync.setDaemon(true);
                msync.start();
                long lastPage = 0L;
                for (int i = 0; i < 0x100000; ++i) {
                    try (DocumentContext dc = appender.writingDocument();){
                        dc.wire().bytes().writeSkip(256L);
                    }
                    long page = appender.lastPosition + 4095L & 0xFFFFFFFFFFFFF000L;
                    boolean touch = page != lastPage && appender.wire().bytes().bytesStore().inside(page, 8L);
                    lastPage = page;
                    if (touch != appender.microTouch()) {
                        Assert.assertEquals((String)("i: " + i), (Object)touch, (Object)appender.microTouch());
                    }
                    if (!touch) continue;
                    ++pages;
                }
            }
            System.out.println("pages = " + pages);
            System.out.println("Time = " + (double)((System.nanoTime() - start) / 1000000L) / 1000.0);
        }
        catch (Throwable throwable) {
            System.out.println("pages = " + pages);
            System.out.println("Time = " + (double)((System.nanoTime() - start) / 1000000L) / 1000.0);
            IOTools.deleteDirWithFiles((String[])new String[]{path});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{path});
    }
}

