/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.Indexing;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class IndexingTestCommon
extends QueueTestCommon {
    protected SetTimeProvider timeProvider;
    protected SingleChronicleQueue queue;
    protected StoreAppender appender;
    protected List<Closeable> closeables;
    protected ExcerptTailer tailer;
    protected File queuePath;

    @BeforeEach
    public void before() {
        this.closeables = new ArrayList<Closeable>();
        this.timeProvider = new SetTimeProvider();
        this.queuePath = this.getTmpDir();
        IOTools.deleteDirWithFiles((File)this.queuePath);
        this.queue = this.createQueueInstance();
        this.appender = (StoreAppender)this.queue.createAppender();
        this.tailer = this.queue.createTailer();
    }

    @AfterEach
    public void after() {
        this.closeables.forEach(Closeable::closeQuietly);
        Closeable.closeQuietly((Object[])new Object[]{this.appender, this.tailer, this.queue});
        IOTools.deleteDirWithFiles((File)this.queuePath);
    }

    protected SingleChronicleQueue createQueueInstance() {
        return SingleChronicleQueueBuilder.builder().path(this.queuePath).timeProvider((TimeProvider)this.timeProvider).rollCycle(this.rollCycle()).build();
    }

    protected RollCycle rollCycle() {
        return TestRollCycles.TEST_SECONDLY;
    }

    public Indexing indexing(SingleChronicleQueue queue) {
        SingleChronicleQueueStore store = this.store(queue);
        return store.indexing;
    }

    public SingleChronicleQueueStore store(SingleChronicleQueue queue) {
        SingleChronicleQueueStore store = queue.storeForCycle(queue.lastCycle(), queue.epoch(), false, null);
        this.closeables.add((Closeable)store);
        return store;
    }
}

