/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.StreamCorruptedException;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.Indexing;
import net.openhft.chronicle.queue.impl.single.IndexingTestCommon;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IndexingLastSequenceNumberTest
extends IndexingTestCommon {
    IndexingLastSequenceNumberTest() {
    }

    @Test
    void checkIndexingSpacing() {
        this.appender.writeText((CharSequence)"test");
        Assertions.assertEquals((int)this.rollCycle().defaultIndexSpacing(), (int)this.indexing(this.queue).indexSpacing());
    }

    @Test
    void singleCycleOneEntryApproximateLookup() throws StreamCorruptedException {
        this.appender.writeText((CharSequence)"hello");
        Indexing indexing = this.indexing(this.queue);
        int linearScanByPositionCountStart = indexing.linearScanByPositionCount();
        Assertions.assertEquals((int)0, (int)linearScanByPositionCountStart);
        long lastSequenceNumber = indexing.lastSequenceNumber((ExcerptContext)this.appender);
        Assertions.assertEquals((long)0L, (long)lastSequenceNumber);
        Assertions.assertEquals((int)1, (int)indexing.linearScanByPositionCount());
    }

    @Test
    void singleCycleOneEntryPreciseLookup() throws StreamCorruptedException {
        this.appender.writeText((CharSequence)"hello");
        Indexing indexing = this.indexing(this.queue);
        int linearScanByPositionCountStart = indexing.linearScanByPositionCount();
        Assertions.assertEquals((int)0, (int)linearScanByPositionCountStart);
        long lastSequenceNumber = indexing.lastSequenceNumber((ExcerptContext)this.appender);
        Assertions.assertEquals((long)0L, (long)lastSequenceNumber);
        Assertions.assertEquals((int)1, (int)indexing.linearScanByPositionCount());
    }

    @Test
    void singleCycleTwoEntries() throws StreamCorruptedException {
        this.appender.writeText((CharSequence)"hello");
        this.appender.writeText((CharSequence)"world");
        Indexing indexing = this.indexing(this.queue);
        long lastSequenceNumber = indexing.lastSequenceNumber((ExcerptContext)this.appender);
        Assertions.assertEquals((long)1L, (long)lastSequenceNumber);
        Assertions.assertEquals((int)1, (int)indexing.linearScanByPositionCount());
    }

    @Test
    void multipleCycleFilesFirstEntry() throws StreamCorruptedException {
        this.appender.writeText((CharSequence)"a");
        this.timeProvider.advanceMillis(1001L);
        this.appender.writeText((CharSequence)"b");
        this.timeProvider.advanceMillis(1001L);
        this.appender.writeText((CharSequence)"c");
        long lastSequenceNumber = this.indexing(this.queue).lastSequenceNumber((ExcerptContext)this.appender);
        Assertions.assertEquals((long)0L, (long)lastSequenceNumber);
    }

    @Test
    void multipleCycleFilesSecondEntry() throws StreamCorruptedException {
        this.appender.writeText((CharSequence)"a");
        this.timeProvider.advanceMillis(1001L);
        this.appender.writeText((CharSequence)"b");
        this.timeProvider.advanceMillis(1001L);
        this.appender.writeText((CharSequence)"c");
        this.appender.writeText((CharSequence)"d");
        long lastSequenceNumber = this.indexing(this.queue).lastSequenceNumber((ExcerptContext)this.appender);
        Assertions.assertEquals((long)1L, (long)lastSequenceNumber);
    }
}

