/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.QueueTestCommon;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public final class FileModificationTimeTest
extends QueueTestCommon {
    private final AtomicInteger fileCount = new AtomicInteger();

    private static void waitForDiff(long a, LongSupplier b) {
        long timeout = System.currentTimeMillis() + 15000L;
        while (!Thread.currentThread().isInterrupted() && System.currentTimeMillis() < timeout) {
            if (a != b.getAsLong()) {
                return;
            }
            Jvm.pause((long)1000L);
        }
        Assert.fail((String)"Values did not become different");
    }

    @Test
    public void shouldUpdateDirectoryModificationTime() {
        File dir = this.getTmpDir();
        Assume.assumeFalse((boolean)PageUtil.isHugePage((String)dir.getAbsolutePath()));
        dir.mkdirs();
        long startModTime = dir.lastModified();
        this.modifyDirectoryContentsUntilVisible(dir, startModTime);
        long afterOneFile = dir.lastModified();
        this.modifyDirectoryContentsUntilVisible(dir, afterOneFile);
    }

    private void modifyDirectoryContentsUntilVisible(File dir, long startTime) {
        FileModificationTimeTest.waitForDiff(startTime, () -> {
            this.createFile(dir, this.fileCount.getAndIncrement() + ".txt");
            return dir.lastModified();
        });
    }

    private void createFile(File dir, String filename) {
        File file = new File(dir, filename);
        try (FileWriter writer = new FileWriter(file);){
            writer.append("foo");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

