/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class WeeklyRollCycleTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWeekly() {
        @NotNull String tmpDir = OS.getTarget() + "/testWeekly";
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)tmpDir).rollCycle((RollCycle)RollCycles.WEEKLY).build();){
            Assert.assertEquals((long)4L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/01T00:00:00")));
            Assert.assertEquals((long)4L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/02T00:00:00")));
            Assert.assertEquals((long)4L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/03T00:00:00")));
            Assert.assertEquals((long)4L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/04T00:00:00")));
            Assert.assertEquals((long)4L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/05T00:00:00")));
            Assert.assertEquals((long)4L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/06T00:00:00")));
            Assert.assertEquals((long)4L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/07T00:00:00")));
            Assert.assertEquals((long)4L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/07T23:59:59")));
            Assert.assertEquals((long)5L, (long)queue.cycle((TimeProvider)new SetTimeProvider("1970/02/08T00:00:00")));
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{tmpDir});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{tmpDir});
    }
}

