/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.ValueStringArray;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.junit.Assert;
import org.junit.Test;

public class ValueStringArrayTest
extends QueueTestCommon {
    private static final String EXPECTED = "hello world";
    private final ValueStringArray using = new ValueStringArray();

    @Test
    public void test() {
        this.expectException("BytesMarshallable found in field which is not matching exactly");
        ValueStringArray value = new ValueStringArray();
        value.setCsArrItem(1, EXPECTED);
        File dataDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dataDir).build();
             ExcerptAppender excerptAppender = queue.createAppender();){
            try (DocumentContext dc = excerptAppender.writingDocument();){
                dc.wire().write((CharSequence)"data").marshallable((WriteMarshallable)value);
            }
            dc = queue.createTailer().readingDocument();
            var8_12 = null;
            try {
                dc.wire().read("data").marshallable((ReadMarshallable)this.using);
                CharSequence actual = this.using.getCsArr().getCharSequenceWrapperAt(1).getCharSequence();
                Assert.assertEquals((Object)EXPECTED, (Object)actual.toString());
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }
}

