/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class NoDataIsSkippedWithInterruptTest
extends QueueTestCommon {
    private static final String EXPECTED = "Hello World";

    @After
    public void clearInterrupt() {
        Thread.interrupted();
    }

    @Test
    public void test() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.single((File)DirectoryUtils.tempDir(".")).rollCycle((RollCycle)LegacyRollCycles.MINUTELY).timeProvider((TimeProvider)timeProvider).testBlockSize().build();
             ExcerptAppender excerptAppender = q.createAppender();
             ExcerptTailer tailer = q.createTailer();){
            Thread.currentThread().interrupt();
            excerptAppender.writeText((CharSequence)EXPECTED);
            Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
            timeProvider.advanceMillis(60000L);
            excerptAppender.writeText((CharSequence)EXPECTED);
            Assert.assertEquals((Object)EXPECTED, (Object)tailer.readText());
            Assert.assertEquals((Object)EXPECTED, (Object)tailer.readText());
        }
    }
}

