/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.util;

import java.io.File;
import java.nio.file.Paths;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.Jvm;
import org.junit.rules.TestName;

public final class HugetlbfsTestUtil {
    public static final String HUGETLBFS_PATH_PROPERTY = "chronicle.queue.tests.hugetlbfsPath";
    public static final String HUGETLBFS_PATH = Jvm.getProperty((String)"chronicle.queue.tests.hugetlbfsPath", (String)"/mnt/huge");

    private HugetlbfsTestUtil() {
    }

    public static boolean isHugetlbfsAvailable() {
        String hugetlbfsPath = HugetlbfsTestUtil.hugetlbfsPath();
        if (hugetlbfsPath != null) {
            return PageUtil.isHugePage((String)hugetlbfsPath);
        }
        return false;
    }

    public static String hugetlbfsPath() {
        if (new File(HUGETLBFS_PATH).exists()) {
            return HUGETLBFS_PATH;
        }
        return null;
    }

    public static String getHugetlbfsQueueDirectory(TestName testName) {
        String hugetlbfsPath = HugetlbfsTestUtil.hugetlbfsPath();
        if (hugetlbfsPath == null || !HugetlbfsTestUtil.isHugetlbfsAvailable()) {
            throw new IllegalStateException("hugetlbfs is not available");
        }
        return Paths.get(hugetlbfsPath, testName.getMethodName()).toString();
    }
}

