/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.namedtailer;

import java.io.File;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.NamedTailerNotAvailableException;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class NamedTailerPreconditionTest
extends QueueTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canCreateNonReplicatedNamedTailerOnSink() {
        File queuePath = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(queuePath).build();){
            this.setQueueAsSink(queue);
            try (ExcerptTailer tailer = queue.createTailer("named_1");){
                Assert.assertEquals((long)0L, (long)tailer.index());
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cannotCreateNonReplicatedNamedTailerOnSink() {
        File queuePath = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(queuePath).build();){
            this.setQueueAsSink(queue);
            NamedTailerNotAvailableException exception = (NamedTailerNotAvailableException)Assert.assertThrows(NamedTailerNotAvailableException.class, () -> queue.createTailer("replicated:named_1"));
            Assert.assertEquals((Object)"replicated:named_1", (Object)exception.tailerName());
            Assert.assertEquals((Object)NamedTailerNotAvailableException.Reason.NOT_AVAILABLE_ON_SINK, (Object)exception.reason());
            Assertions.assertTrue((boolean)exception.getMessage().contains("Replicated named tailers cannot be instantiated on a replication sink"));
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }

    private void setQueueAsSink(SingleChronicleQueue queue) {
        queue.appendLock().lock();
    }
}

