/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.method;

import java.util.ArrayList;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.ThreadLocalAppender;
import org.junit.Assert;
import org.junit.Test;

public class BrokenChainTest
extends QueueTestCommon {
    @Test
    public void brokenChainQueue() {
        try (ChronicleQueue queue = ChronicleQueue.single((String)(OS.getTarget() + "/brokernChain-" + System.nanoTime()));
             ExcerptAppender appender = ThreadLocalAppender.acquireThreadLocalAppender((ChronicleQueue)queue);
             ExcerptTailer tailer = queue.createTailer();){
            First writer = (First)appender.methodWriter(First.class, new Class[0]);
            Assert.assertTrue((boolean)appender.writingIsComplete());
            ArrayList list = new ArrayList();
            First first = pre -> msg -> list.add("pre: " + pre + ", msg: " + msg);
            MethodReader reader = tailer.methodReader(new Object[]{first});
            Assert.assertFalse((boolean)reader.readOne());
            appender.rollbackIfNotComplete();
            Assert.assertFalse((boolean)reader.readOne());
            Second second = writer.pre("pre");
            Assert.assertFalse((boolean)appender.writingIsComplete());
            second.msg("msg");
            Assert.assertTrue((boolean)appender.writingIsComplete());
            appender.rollbackIfNotComplete();
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertFalse((boolean)reader.readOne());
            Assert.assertEquals((Object)"[pre: pre, msg: msg]", (Object)((Object)list).toString());
            list.clear();
            Second secondB = writer.pre("bad-pre");
            Assert.assertFalse((boolean)appender.writingIsComplete());
            appender.rollbackIfNotComplete();
            Assert.assertTrue((boolean)appender.writingIsComplete());
            Assert.assertFalse((boolean)reader.readOne());
            Assert.assertEquals((Object)"[]", (Object)((Object)list).toString());
            Second secondC = writer.pre("pre-C");
            Assert.assertFalse((boolean)appender.writingIsComplete());
            secondC.msg("msg-C");
            Assert.assertTrue((boolean)appender.writingIsComplete());
            appender.rollbackIfNotComplete();
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertFalse((boolean)reader.readOne());
            Assert.assertEquals((Object)"[pre: pre-C, msg: msg-C]", (Object)((Object)list).toString());
        }
    }

    static interface Second {
        public void msg(String var1);
    }

    static interface First {
        public Second pre(String var1);
    }
}

