/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.reader.ChronicleReader;
import net.openhft.chronicle.wire.BytesInBinaryMarshallable;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ChronicleMethodReaderTest
extends QueueTestCommon {
    private final Queue<String> capturedOutput = new ConcurrentLinkedQueue<String>();
    private Path dataDir;

    @Before
    public void before() {
        this.dataDir = this.getTmpDir().toPath();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)this.dataDir).sourceId(1).testBlockSize().build();){
            VanillaMethodWriterBuilder methodWriterBuilder = queue.methodWriterBuilder(All.class);
            All events = (All)methodWriterBuilder.build();
            for (int i = 0; i < 24; ++i) {
                Method1Type m1 = new Method1Type();
                m1.text = "hello";
                m1.value = i;
                m1.number = i;
                events.method1(m1);
                Method2Type m2 = new Method2Type();
                m2.text = "goodbye";
                m2.value = ++i;
                m2.number = i;
                events.method2(m2);
            }
        }
        this.ignoreException("Overriding sourceId from existing metadata, was 0, overriding to");
    }

    @Test
    public void shouldNotFailOnEmptyQueue() {
        if (!OS.isWindows()) {
            this.expectException("Failback to readonly tablestore");
        }
        Path path = this.getTmpDir().toPath();
        path.toFile().mkdirs();
        this.basicReader(path).execute();
        Assert.assertTrue((boolean)this.capturedOutput.isEmpty());
    }

    @NotNull
    private ChronicleReader basicReader(Path path) {
        if (OS.isWindows() && !this.testName.getMethodName().startsWith("shouldThrowExceptionIfInputDirectoryDoesNotExist")) {
            this.expectException("Read-only mode is not supported on Windows");
        }
        return new ChronicleReader().withBasePath(path).withMessageSink(this.capturedOutput::add);
    }

    @NotNull
    private ChronicleReader basicReaderMethodReader(Path path) {
        return this.basicReader(path).asMethodReader(All.class.getName());
    }

    @Test
    public void shouldNotFailWhenNoMetadata() throws IOException {
        if (!OS.isWindows()) {
            this.expectException("Failback to readonly tablestore");
        }
        Files.list(this.dataDir).filter(f -> f.getFileName().toString().endsWith(".cq4t")).findFirst().ifPresent(path -> path.toFile().delete());
        this.basicReader().execute();
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("history:")));
    }

    @Test
    public void shouldIncludeMessageHistoryByDefault() {
        this.basicReader().execute();
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("history:")));
    }

    @Test
    public void shouldApplyIncludeRegexToHistoryMessagesAndBusinessMessages() {
        this.basicReader().withInclusionRegex("goodbye").asMethodReader("").execute();
        Assert.assertFalse((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("history:")));
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("method2")));
    }

    @Test
    public void shouldBeAbleToReadFromReadOnlyFile() throws IOException {
        Assume.assumeFalse((String)"#460 read-only not supported on Windows", (boolean)OS.isWindows());
        Path queueFile = Files.list(this.dataDir).filter(f -> f.getFileName().toString().endsWith(".cq4")).findFirst().orElseThrow(() -> new AssertionError((Object)("Could not find queue file in directory " + this.dataDir)));
        Assert.assertTrue((boolean)queueFile.toFile().setWritable(false));
        this.basicReader().execute();
    }

    @Test
    public void shouldConvertEntriesToTextMethodReader() {
        this.basicReaderMethodReader().execute();
        long msgCount = this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).count();
        Assert.assertEquals((long)24L, (long)msgCount);
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("hello")));
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("method1")));
    }

    @Test
    public void shouldNotConvertEntriesToText() {
        this.basicReader().execute();
        long msgCount = this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).count();
        Assert.assertEquals((long)24L, (long)msgCount);
        Assert.assertTrue((boolean)this.capturedOutput.stream().anyMatch(msg -> msg.contains("  5,\n  104,\n  101,\n  108,\n  108,\n  111,")));
    }

    @Test
    public void shouldFilterByInclusionRegex() {
        this.basicReader().withInclusionRegex(".*good.*").execute();
        Assert.assertEquals((long)24L, (long)this.capturedOutput.size());
        this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).forEach(msg -> MatcherAssert.assertThat((Object)msg, (Matcher)CoreMatchers.containsString((String)"goodbye")));
    }

    @Test
    public void shouldFilterByMultipleInclusionRegex() {
        this.basicReader().withInclusionRegex(".*bye.*").withInclusionRegex(".*o.*").execute();
        Assert.assertEquals((long)24L, (long)this.capturedOutput.size());
        this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).forEach(msg -> MatcherAssert.assertThat((Object)msg, (Matcher)CoreMatchers.containsString((String)"goodbye")));
        this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).forEach(msg -> MatcherAssert.assertThat((Object)msg, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"hello"))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfInputDirectoryDoesNotExist() {
        this.basicReader().withBasePath(Paths.get("/does/not/exist", new String[0])).execute();
    }

    @Test
    public void shouldFilterByExclusionRegex() {
        this.basicReader().withExclusionRegex(".*good.*").execute();
        long msgCount = this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).count();
        Assert.assertEquals((long)12L, (long)msgCount);
        this.capturedOutput.forEach(msg -> MatcherAssert.assertThat((Object)msg, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"goodbye"))));
    }

    @Ignore(value="https://github.com/OpenHFT/Chronicle-Queue/issues/1150")
    @Test
    public void shouldFilterByMultipleExclusionRegex() {
        this.basicReaderMethodReader().withExclusionRegex(".*bye$").withExclusionRegex(".*ell.*").execute();
        Assert.assertEquals((long)0L, (long)this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).count());
    }

    @Test
    public void shouldReturnNoMoreThanTheSpecifiedNumberOfMaxRecords() {
        this.basicReaderMethodReader().historyRecords(5L).execute();
        Assert.assertEquals((long)5L, (long)this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).count());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfSpecifiedIndexIsBeforeFirstIndex() {
        this.basicReader().withStartIndex(1L).execute();
    }

    @Test
    public void shouldNotRewindPastStartOfQueueWhenDisplayingHistory() {
        this.basicReader().historyRecords(Long.MAX_VALUE).execute();
        Assert.assertEquals((long)24L, (long)this.capturedOutput.stream().filter(msg -> !msg.startsWith("0x")).count());
    }

    private ChronicleReader basicReader() {
        return this.basicReader(this.dataDir);
    }

    private ChronicleReader basicReaderMethodReader() {
        return this.basicReaderMethodReader(this.dataDir);
    }

    @After
    public void clearInterrupt() {
        Thread.interrupted();
    }

    static class Method2Type
    extends SelfDescribingMarshallable {
        String text;
        long value;
        double number;

        Method2Type() {
        }
    }

    static class Method1Type
    extends BytesInBinaryMarshallable {
        String text;
        long value;
        double number;

        Method1Type() {
        }
    }

    static interface All
    extends Method1,
    Method2 {
    }

    static interface Method2 {
        public void method2(Method2Type var1);
    }

    static interface Method1 {
        @MethodId(value=1L)
        public void method1(Method1Type var1);
    }
}

