/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class StoreAppenderInternalWriteBytesTest
extends QueueTestCommon {
    private static final int MESSAGES_TO_WRITE = 200;

    @Before
    public void check64bit() {
        Assume.assumeTrue((boolean)Jvm.is64bit());
    }

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @Test
    public void internalWriteBytesShouldBeIdempotentUnderConcurrentUpdates() throws InterruptedException {
        this.testInternalWriteBytes(5, true);
    }

    @Test
    public void internalWriteBytesShouldBeIdempotent() throws InterruptedException {
        this.testInternalWriteBytes(5, false);
    }

    public void testInternalWriteBytes(int numCopiers, boolean concurrent) throws InterruptedException {
        Path sourceDir = IOTools.createTempDirectory((String)"sourceQueue");
        Path destinationDir = IOTools.createTempDirectory((String)"destinationQueue");
        this.populateSourceQueue(sourceDir);
        this.copySourceToDestination(numCopiers, concurrent, sourceDir, destinationDir);
        this.assertQueueContentsAreTheSame(sourceDir, destinationDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySourceToDestination(int numCopiers, boolean concurrent, Path sourceDir, Path destinationDir) throws InterruptedException {
        ExecutorService es = Executors.newFixedThreadPool(concurrent ? numCopiers : 1);
        try {
            ArrayList copierFutures = new ArrayList();
            for (int i = 0; i < numCopiers; ++i) {
                copierFutures.add(es.submit(new QueueCopier(sourceDir, destinationDir, i)));
            }
            copierFutures.forEach(future -> {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            es.shutdown();
            assert (es.awaitTermination(30L, TimeUnit.SECONDS)) : "Copier threads didn't stop";
        }
    }

    private void assertQueueContentsAreTheSame(Path sourceDir, Path destinationDir) {
        try (SingleChronicleQueue sourceQueue = this.createQueue(sourceDir, null);
             SingleChronicleQueue destinationQueue = this.createQueue(destinationDir);){
            try (ExcerptAppender appender = destinationQueue.createAppender();){
                appender.normaliseEOFs();
            }
            var8_12 = null;
            try (ExcerptTailer sourceTailer = sourceQueue.createTailer();
                 ExcerptTailer destinationTailer = destinationQueue.createTailer();){
                OnHeapBytes sourceBuffer = Bytes.allocateElasticOnHeap((int)1024);
                OnHeapBytes destinationBuffer = Bytes.allocateElasticOnHeap((int)1024);
                for (int i = 0; i < 200; ++i) {
                    sourceBuffer.clear();
                    destinationBuffer.clear();
                    long sourceIndex = sourceTailer.index();
                    long destinationIndex = destinationTailer.index();
                    assert (sourceTailer.readBytes((Bytes)sourceBuffer)) : "Source queue is shorter than expected";
                    assert (destinationTailer.readBytes((Bytes)destinationBuffer)) : "Destination queue is shorter than expected";
                    String s = destinationBuffer.toString();
                    Assert.assertEquals((String)String.format("Mismatch at index %s/%s was %s", Long.toHexString(sourceIndex), Long.toHexString(destinationIndex), s), (Object)sourceBuffer.toString(), (Object)s.replaceAll(" - .*", ""));
                }
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
        }
    }

    private void populateSourceQueue(Path queueDir) {
        Jvm.debug().on(this.getClass(), "Populating source queue...");
        try (SingleChronicleQueue queue = this.createQueue(queueDir);
             ExcerptAppender appender = queue.createAppender();){
            OnHeapBytes buffer = Bytes.allocateElasticOnHeap((int)1024);
            for (int i = 0; i < 200; ++i) {
                if (i == 66 || i == 133) {
                    Jvm.pause((long)1000L);
                }
                buffer.clear();
                buffer.write(this.messageForIndex(i));
                appender.writeBytes((Bytes)buffer);
            }
        }
        Jvm.debug().on(this.getClass(), "Populated source queue");
    }

    private byte[] messageForIndex(long index) {
        return String.format("Message %d", index).getBytes(StandardCharsets.UTF_8);
    }

    private SingleChronicleQueue createQueue(Path queueDir) {
        return this.createQueue(queueDir, null);
    }

    @NotNull
    private SingleChronicleQueue createQueue(Path queueDir, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.binary((Path)queueDir).rollCycle((RollCycle)TestRollCycles.TEST4_SECONDLY).timeProvider(timeProvider).testBlockSize().build();
    }

    static /* synthetic */ SingleChronicleQueue access$000(StoreAppenderInternalWriteBytesTest x0, Path x1, TimeProvider x2) {
        return x0.createQueue(x1, x2);
    }

    private class QueueCopier
    implements Runnable {
        private final Path sourceDir;
        private final Path destinationDir;
        private final int copyId;

        public QueueCopier(Path sourceDir, Path destinationDir, int copyId) {
            this.sourceDir = sourceDir;
            this.destinationDir = destinationDir;
            this.copyId = copyId;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block97: {
                sourceQueue = StoreAppenderInternalWriteBytesTest.access$000(StoreAppenderInternalWriteBytesTest.this, this.sourceDir, null);
                var2_2 = null;
                try {
                    destinationQueue = StoreAppenderInternalWriteBytesTest.access$000(StoreAppenderInternalWriteBytesTest.this, this.destinationDir, null);
                    var4_6 = null;
                    try {
                        sourceTailer = sourceQueue.createTailer();
                        var6_10 = null;
                        try {
                            destinationTailer = destinationQueue.createTailer();
                            var8_14 = null;
                            try {
                                destinationAppender = destinationQueue.createAppender();
                                var10_18 = null;
                                try {
                                    buffer = Bytes.allocateElasticOnHeap((int)1024);
                                    prev = Bytes.allocateElasticOnHeap((int)1024);
                                    while (true) lbl-1000:
                                    // 7 sources

                                    {
                                        buffer.clear();
                                        index = sourceTailer.index();
                                        if (!sourceTailer.readBytes((Bytes)buffer)) {
                                            break block97;
                                        }
                                        index = sourceTailer.lastReadIndex();
                                        if (prev.contentEquals((BytesStore)buffer)) {
                                            Assert.fail((String)("duplicate " + buffer));
                                        }
                                        ((Bytes)buffer.append((CharSequence)" - ")).append(this.copyId);
                                        ((InternalAppender)destinationAppender).writeBytes(index, (BytesStore)buffer);
                                        dc = destinationTailer.readingDocument();
                                        var16_25 = null;
                                        try {
                                            if (!dc.isPresent()) {
                                                Assert.fail((String)("no write " + buffer));
                                            }
                                            if ((dtIndex = destinationTailer.index()) != index) {
                                                Assert.assertEquals((Object)Long.toHexString(index), (Object)Long.toHexString(dtIndex));
                                            }
                                        }
                                        catch (Throwable dtIndex) {
                                            var16_25 = dtIndex;
                                            throw dtIndex;
                                        }
                                        finally {
                                            if (dc != null) {
                                                if (var16_25 != null) {
                                                    try {
                                                        dc.close();
                                                    }
                                                    catch (Throwable dtIndex) {
                                                        var16_25.addSuppressed(dtIndex);
                                                    }
                                                } else {
                                                    dc.close();
                                                }
                                            }
                                        }
                                        prev.clear().append((CharSequence)buffer);
                                        dq = StoreAppenderInternalWriteBytesTest.access$000(StoreAppenderInternalWriteBytesTest.this, this.destinationDir, null);
                                        var16_25 = null;
                                        try {
                                            da = dq.createAppender();
                                            var18_32 = null;
                                            try {
                                                Assume.assumeNotNull((Object[])new Object[]{dq});
                                                Assume.assumeNotNull((Object[])new Object[]{da});
                                            }
                                            catch (Throwable var19_35) {
                                                var18_32 = var19_35;
                                                throw var19_35;
                                            }
                                            finally {
                                                if (da == null) ** GOTO lbl-1000
                                                if (var18_32 != null) {
                                                    try {
                                                        da.close();
                                                    }
                                                    catch (Throwable var19_33) {
                                                        var18_32.addSuppressed(var19_33);
                                                    }
                                                }
                                                da.close();
                                            }
                                        }
                                        catch (Throwable var17_31) {
                                            var16_25 = var17_31;
                                            throw var17_31;
                                        }
                                        finally {
                                            if (dq == null) continue;
                                            if (var16_25 != null) {
                                                try {
                                                    dq.close();
                                                }
                                                catch (Throwable var17_30) {
                                                    var16_25.addSuppressed(var17_30);
                                                }
                                                continue;
                                            }
                                            dq.close();
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable var11_21) {
                                    var10_18 = var11_21;
                                    throw var11_21;
                                }
                                finally {
                                    if (destinationAppender != null) {
                                        if (var10_18 != null) {
                                            try {
                                                destinationAppender.close();
                                            }
                                            catch (Throwable var11_20) {
                                                var10_18.addSuppressed(var11_20);
                                            }
                                        } else {
                                            destinationAppender.close();
                                        }
                                    }
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var9_17) {
                                var8_14 = var9_17;
                                throw var9_17;
                            }
                            finally {
                                if (destinationTailer != null) {
                                    if (var8_14 != null) {
                                        try {
                                            destinationTailer.close();
                                        }
                                        catch (Throwable var9_16) {
                                            var8_14.addSuppressed(var9_16);
                                        }
                                    } else {
                                        destinationTailer.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable var7_13) {
                            var6_10 = var7_13;
                            throw var7_13;
                        }
                        finally {
                            if (sourceTailer != null) {
                                if (var6_10 != null) {
                                    try {
                                        sourceTailer.close();
                                    }
                                    catch (Throwable var7_12) {
                                        var6_10.addSuppressed(var7_12);
                                    }
                                } else {
                                    sourceTailer.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var5_9) {
                        var4_6 = var5_9;
                        throw var5_9;
                    }
                    finally {
                        if (destinationQueue != null) {
                            if (var4_6 != null) {
                                try {
                                    destinationQueue.close();
                                }
                                catch (Throwable var5_8) {
                                    var4_6.addSuppressed(var5_8);
                                }
                            } else {
                                destinationQueue.close();
                            }
                        }
                    }
                }
                catch (Throwable var3_5) {
                    var2_2 = var3_5;
                    throw var3_5;
                }
                finally {
                    if (sourceQueue != null) {
                        if (var2_2 != null) {
                            try {
                                sourceQueue.close();
                            }
                            catch (Throwable var3_4) {
                                var2_2.addSuppressed(var3_4);
                            }
                        } else {
                            sourceQueue.close();
                        }
                    }
                }
            }
        }
    }
}

