/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueueLockTest
extends QueueTestCommon {
    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @Test
    public void testTimeout() throws InterruptedException {
        this.expectException("queue.dont.recover.lock.timeout property is deprecated and will be removed");
        this.check(true);
    }

    @Test
    public void testRecover() throws InterruptedException {
        System.setProperty("queue.force.unlock.mode", "ALWAYS");
        try {
            this.check(false);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("overwritten? Expected:"));
        }
        finally {
            System.clearProperty("queue.force.unlock.mode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(boolean shouldThrowException) throws InterruptedException {
        this.finishedNormally = false;
        this.ignoreException("Couldn't acquire write lock");
        if (!shouldThrowException) {
            this.expectException("Forced unlock for the lock");
        }
        try {
            System.setProperty("queue.dont.recover.lock.timeout", Boolean.toString(shouldThrowException));
            long timeoutMs = 2000L;
            File queueDir = DirectoryUtils.tempDir("check");
            try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)queueDir).timeoutMS(2000L).build();
                 ExcerptAppender excerptAppender = queue.createAppender();
                 DocumentContext dc = excerptAppender.writingDocument();){
                Assert.assertNotNull((Object)dc);
                CountDownLatch started = new CountDownLatch(1);
                CountDownLatch finished = new CountDownLatch(1);
                AtomicBoolean recoveredAndAcquiredTheLock = new AtomicBoolean();
                AtomicBoolean threwException = new AtomicBoolean();
                Thread otherWriter = new Thread(() -> {
                    try (SingleChronicleQueue queue2 = ChronicleQueue.singleBuilder((File)queueDir).timeoutMS(2000L).build();){
                        started.countDown();
                        try (ExcerptAppender queue2Appender = queue2.createAppender();
                             DocumentContext context = queue2Appender.writingDocument();){
                            Assert.assertNotNull((Object)context);
                            recoveredAndAcquiredTheLock.set(true);
                            System.out.println("Done");
                        }
                        catch (UnrecoverableTimeoutException e) {
                            e.printStackTrace();
                            threwException.set(true);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                        finally {
                            System.out.println("finished");
                            finished.countDown();
                        }
                    }
                }, "Test thread");
                otherWriter.start();
                long startTime = System.currentTimeMillis();
                started.await(1L, TimeUnit.SECONDS);
                finished.await(10L, TimeUnit.SECONDS);
                long endTime = System.currentTimeMillis();
                long time = endTime - startTime;
                Assert.assertEquals((Object)shouldThrowException, (Object)threwException.get());
                Assert.assertEquals((Object)shouldThrowException, (Object)(!recoveredAndAcquiredTheLock.get() ? 1 : 0));
                Assert.assertTrue((String)("timeout, time: " + time), (time >= 2000L ? 1 : 0) != 0);
            }
            this.finishedNormally = true;
        }
        finally {
            System.clearProperty("queue.dont.recover.lock.timeout");
        }
    }
}

