/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.junit.Assert;
import org.junit.Test;

public class CycleOverflowTest
extends QueueTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void overflowingMaxMessagesInCycleShouldThrowException() {
        File path = this.getTmpDir();
        TestRollCycles rollCycle = TestRollCycles.TEST_DAILY;
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.set(System.currentTimeMillis());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)rollCycle).path(path).build();
             ExcerptAppender appender = queue.createAppender();){
            Assert.assertThrows((String)"Unable to index 64, the number of entries exceeds max number for the current rollcycle", IllegalStateException.class, () -> CycleOverflowTest.lambda$overflowingMaxMessagesInCycleShouldThrowException$0((RollCycle)rollCycle, appender));
        }
        finally {
            IOTools.deleteDirWithFiles((File)path);
        }
    }

    private static /* synthetic */ void lambda$overflowingMaxMessagesInCycleShouldThrowException$0(RollCycle rollCycle, ExcerptAppender appender) throws Throwable {
        int i = 0;
        while ((long)i < rollCycle.maxMessagesPerCycle() + 1L) {
            appender.writeText((CharSequence)Integer.toString(i));
            ++i;
        }
    }
}

