/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.channel.PubSub;
import net.openhft.chronicle.queue.channel.PubSubHandler;
import net.openhft.chronicle.queue.channel.Says;
import net.openhft.chronicle.queue.channel.Subscribe;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.ChronicleGatewayMain;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PubSubHandlerTest
extends QueueTestCommon {
    private final String url;

    public PubSubHandlerTest(String name, String url) {
        this.url = url;
    }

    public static String createTargetDir(String s) {
        String name = OS.getTarget() + "/" + s + "-" + Time.uniqueId();
        if (!PageUtil.isHugePage((String)name)) {
            Assert.assertTrue((String)name, (boolean)name.contains("target/"));
        }
        File file = new File(name);
        file.mkdirs();
        return name;
    }

    @Parameterized.Parameters(name="name: {0}, url: {1}")
    public static List<Object[]> combinations() {
        return Arrays.asList({"internal", "internal://"}, {"client-only", "tcp://localhost:65451"}, {"server", "tcp://:0"});
    }

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @Test
    public void testPubSub() throws IOException {
        String tmpDir = PubSubHandlerTest.createTargetDir("testPubSub");
        Assume.assumeFalse((String)"PubSubHandler not supported on hugetlbfs", (boolean)PageUtil.isHugePage((String)tmpDir));
        try (ChronicleContext context = ChronicleContext.newContext((String)this.url).name(tmpDir);){
            if (this.url.contains("/localhost:")) {
                ChronicleGatewayMain gateway = new ChronicleGatewayMain(this.url);
                gateway.name(tmpDir);
                context.addCloseable((Closeable)gateway);
                gateway.start();
            }
            ChronicleChannel channel = context.newChannelSupplier((ChannelHandler)new PubSubHandler()).get();
            PubSubSays pss = (PubSubSays)channel.methodWriter(PubSubSays.class, new Class[0]);
            String qname = "queue-pub-sub";
            pss.subscribe(new Subscribe().eventType("from").name("queue-pub-sub"));
            pss.to("queue-pub-sub").say("Hello");
            Wire wire = Wire.newYamlWireOnHeap();
            FromSays fromSays = (FromSays)wire.methodWriter(FromSays.class, new Class[0]);
            MethodReader reader = channel.methodReader(new Object[]{fromSays});
            Assert.assertFalse((boolean)reader.readOne());
            Assert.assertTrue((boolean)reader.readOne());
            IOTools.deleteDirWithFiles((String[])new String[]{tmpDir});
            Assert.assertEquals((Object)"from: queue-pub-sub\nsay: Hello\n...\n", (Object)wire.toString());
        }
        catch (UnsupportedOperationException uos) {
            Assume.assumeFalse((boolean)this.url.startsWith("internal"));
        }
    }

    static interface FromSays {
        public Says from(String var1);
    }

    static interface PubSubSays
    extends PubSub {
        public Says to(String var1);
    }
}

