/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIORuntimeException;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.channel.Subscribe;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.channel.AbstractHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.EventPoller;
import net.openhft.chronicle.wire.channel.impl.BufferedChronicleChannel;

public class PubSubHandler
extends AbstractHandler<PubSubHandler> {
    private final Map<String, Subscription> subscriptionMap = new LinkedHashMap<String, Subscription>();
    private final List<Subscription> prioritySubscriptions = new ArrayList<Subscription>();
    private final List<Subscription> subscriptions = new ArrayList<Subscription>();
    private boolean buffered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run(ChronicleContext context, ChronicleChannel channel) {
        pauser = Pauser.balanced();
        if (channel instanceof BufferedChronicleChannel) {
            bc = (BufferedChronicleChannel)channel;
            bc.eventPoller((EventPoller)new PSHEventPoller());
        } else {
            tailerThread = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(net.openhft.chronicle.wire.channel.ChronicleContext net.openhft.chronicle.threads.Pauser net.openhft.chronicle.wire.channel.ChronicleChannel ), ()V)((PubSubHandler)this, (ChronicleContext)context, (Pauser)pauser, (ChronicleChannel)channel), "pubsub~tailers");
            tailerThread.setDaemon(true);
            tailerThread.start();
        }
        Thread.currentThread().setName("pubsub~reader");
        publicationMap = new LinkedHashMap<String, Publication>();
        try {
            lock = context.affinityLock();
            var6_6 = null;
            try {
                if (!PubSubHandler.$assertionsDisabled && lock == null) {
                    throw new AssertionError();
                }
lbl18:
                // 13 sources

                block51: while (!channel.isClosed()) {
                    try {
                        dc = channel.readingDocument();
                        var8_11 = null;
                        try {
                            pauser.unpause();
                            if (!dc.isPresent() || dc.isMetaData()) continue;
                            s = (String)dc.wire().readEvent(String.class);
                            if (s == null) {
                                s = "";
                            }
                            var10_17 = s;
                            var11_18 = -1;
                            switch (var10_17.hashCode()) {
                                case 514841930: {
                                    if (!var10_17.equals("subscribe")) break;
                                    var11_18 = 0;
                                    break;
                                }
                                case 583281361: {
                                    if (!var10_17.equals("unsubscribe")) break;
                                    var11_18 = 1;
                                }
                            }
                            switch (var11_18) {
                                case 0: {
                                    subscribe = (Subscribe)dc.wire().getValueIn().object(Subscribe.class);
                                    this.addSubscription(context, subscribe);
                                    ** break;
                                }
                                case 1: {
                                    unsubscribe = dc.wire().getValueIn().text();
                                    this.removeSubscription(unsubscribe);
                                    ** break;
                                }
                                default: {
                                    qName = dc.wire().getValueIn().text();
                                    if (qName == null || qName.isEmpty()) {
                                        qName = s;
                                    }
                                    if ((pub = (Publication)publicationMap.get(qName)) == null) {
                                        pub = new Publication();
                                        pub.queue = this.newQueue(context, qName);
                                        pub.appender = pub.queue.createAppender();
                                        publicationMap.put(qName, pub);
                                    }
                                    dc2 = pub.appender.writingDocument();
                                    var17_24 = null;
                                    dc.wire().copyTo((WireOut)dc2.wire());
                                    if (dc2 == null) continue block51;
                                    if (var17_24 == null) ** GOTO lbl69
                                    try {
                                        dc2.close();
                                    }
                                    catch (Throwable var18_25) {
                                        var17_24.addSuppressed(var18_25);
                                    }
                                    continue block51;
lbl69:
                                    // 1 sources

                                    dc2.close();
                                    ** break;
                                    catch (Throwable var18_26) {
                                        try {
                                            var17_24 = var18_26;
                                            throw var18_26;
                                        }
                                        catch (Throwable var19_27) {
                                            if (dc2 != null) {
                                                if (var17_24 != null) {
                                                    try {
                                                        dc2.close();
                                                    }
                                                    catch (Throwable var20_28) {
                                                        var17_24.addSuppressed(var20_28);
                                                    }
                                                } else {
                                                    dc2.close();
                                                }
                                            }
                                            throw var19_27;
                                        }
                                    }
                                }
                            }
                        }
                        catch (Throwable var9_16) {
                            var8_11 = var9_16;
                            throw var9_16;
                        }
                        finally {
                            if (dc == null) continue;
                            if (var8_11 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable var9_13) {
                                    var8_11.addSuppressed(var9_13);
                                }
                                continue;
                            }
                            dc.close();
                        }
                    }
                    catch (ClosedIORuntimeException e) {
                        if (!channel.isClosed()) {
                            Jvm.warn().on(this.getClass(), (Throwable)e);
                        }
                        break;
                    }
                }
            }
            catch (Throwable var7_10) {
                var6_6 = var7_10;
                throw var7_10;
            }
            finally {
                if (lock != null) {
                    if (var6_6 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable var7_9) {
                            var6_6.addSuppressed(var7_9);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        finally {
            Closeable.closeQuietly(publicationMap.values());
            var5_5 = this.subscriptionMap;
            synchronized (var5_5) {
                Closeable.closeQuietly(this.subscriptionMap.values());
            }
            Thread.currentThread().setName("connections");
        }
    }

    public ChronicleChannel asInternalChannel(ChronicleContext context, ChronicleChannelCfg<?> channelCfg) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubscription(String unsubscribe) {
        Map<String, Subscription> map = this.subscriptionMap;
        synchronized (map) {
            Subscription removed = this.subscriptionMap.remove(unsubscribe);
            if (removed != null) {
                Closeable.closeQuietly((Object[])new Object[]{removed.tailer, removed.queue});
            }
            this.updateSubscriptionLists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSubscription(ChronicleContext context, Subscribe subscribe) {
        Map<String, Subscription> map = this.subscriptionMap;
        synchronized (map) {
            String name = subscribe.name();
            Subscription subscription = this.subscriptionMap.get(name);
            if (subscription == null) {
                subscription = new Subscription();
                this.subscriptionMap.put(name, subscription);
                subscription.name(name);
                subscription.queue = this.newQueue(context, name);
                subscription.tailer = subscription.queue.createTailer();
            }
            subscription.eventType(subscribe.eventType());
            subscription.priority(subscribe.priority());
            this.updateSubscriptionLists();
        }
    }

    private void updateSubscriptionLists() {
        assert (Thread.holdsLock(this.subscriptionMap));
        this.subscriptions.clear();
        this.prioritySubscriptions.clear();
        for (Subscription sub : this.subscriptionMap.values()) {
            (sub.priority() ? this.prioritySubscriptions : this.subscriptions).add(sub);
        }
    }

    private void queueTailer(Pauser pauser, ChronicleChannel channel) {
        while (!channel.isClosed()) {
            if (this.pollSubscriptions(channel)) {
                pauser.reset();
                continue;
            }
            pauser.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollSubscriptions(ChronicleChannel conn) {
        Map<String, Subscription> map = this.subscriptionMap;
        synchronized (map) {
            int i;
            boolean wrote = false;
            for (i = 0; i < this.prioritySubscriptions.size(); ++i) {
                while (this.copyOneMessage(conn, this.prioritySubscriptions.get(i))) {
                    wrote = true;
                }
            }
            if (wrote) {
                return true;
            }
            for (i = 0; i < this.subscriptions.size(); ++i) {
                while (this.copyOneMessage(conn, this.subscriptions.get(i))) {
                    wrote = true;
                }
            }
            return wrote;
        }
    }

    private boolean copyOneMessage(ChronicleChannel channel, Subscription subscription) {
        try (DocumentContext dc = subscription.tailer.readingDocument();){
            long dataBuffered;
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            if (dc.isMetaData()) {
                boolean bl = false;
                return bl;
            }
            try (DocumentContext dc2 = channel.writingDocument();){
                dc2.wire().write((CharSequence)subscription.eventType()).text(subscription.name());
                dc.wire().copyTo((WireOut)dc2.wire());
                dataBuffered = dc2.wire().bytes().writePosition();
            }
            boolean bl = dataBuffered < 32768L;
            return bl;
        }
    }

    private ChronicleQueue newQueue(ChronicleContext cc, String subscribe) {
        return ChronicleQueue.singleBuilder((File)cc.toFile(subscribe)).blockSize(OS.isSparseFileSupported() ? 0x8000000000L : 0x4000000L).build();
    }

    private /* synthetic */ void lambda$run$0(ChronicleContext context, Pauser pauser, ChronicleChannel channel) {
        try (AffinityLock lock = context.affinityLock();){
            assert (lock != null);
            this.queueTailer(pauser, channel);
        }
    }

    class PSHEventPoller
    extends SimpleCloseable
    implements EventPoller {
        PSHEventPoller() {
        }

        public boolean onPoll(ChronicleChannel channel) {
            return PubSubHandler.this.pollSubscriptions(channel);
        }
    }

    static class Subscription
    extends Subscribe
    implements Closeable {
        ChronicleQueue queue;
        ExcerptTailer tailer;

        Subscription() {
        }

        public void close() {
            this.tailer.close();
            this.queue.close();
        }

        public boolean isClosed() {
            return this.queue.isClosed();
        }
    }

    static class Publication
    implements Closeable {
        public ChronicleQueue queue;
        public ExcerptAppender appender;

        Publication() {
        }

        public void close() {
            this.appender.close();
            this.queue.close();
        }

        public boolean isClosed() {
            return this.queue.isClosed();
        }
    }
}

