/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class TableStorePutGetTest
extends QueueTestCommon {
    @Test
    public void indexEntry() {
        SetTimeProvider stp = new SetTimeProvider("2020/10/15T01:01:01");
        try (SingleChronicleQueue cq = ChronicleQueue.singleBuilder((File)DirectoryUtils.tempDir("indexEntry")).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).timeProvider((TimeProvider)stp).testBlockSize().build();){
            try (ExcerptAppender appender = cq.createAppender();){
                try (DocumentContext dc = appender.acquireWritingDocument(false);){
                    dc.wire().write((CharSequence)"hello").text("world");
                }
                cq.tableStorePut((CharSequence)"=hello", appender.lastIndexAppended());
            }
            var5_7 = null;
            try (ExcerptTailer tailer = cq.createTailer();){
                long index = cq.tableStoreGet((CharSequence)"=hello");
                Assert.assertEquals((long)79671643340800L, (long)index);
                Assert.assertTrue((boolean)tailer.moveToIndex(index));
                Assert.assertEquals((long)index, (long)tailer.index());
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertEquals((Object)"hello", (Object)dc.wire().readEvent(String.class));
                    Assert.assertEquals((Object)"world", (Object)dc.wire().getValueIn().text());
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n--- !!data #binary\nlisting.highestCycle: 18550\n--- !!data #binary\nlisting.lowestCycle: 18550\n--- !!data #binary\nlisting.modCount: 4\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n--- !!data #binary\n=hello: 79671643340800\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    400,\n    1717986918400\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  400,\n  0, 0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nhello: world\n...\n", (Object)cq.dump().replaceAll("(?m)^#.+$\\n", ""));
        }
    }

    @Test
    public void manyEntries() {
        File tempDir = DirectoryUtils.tempDir("manyEntries");
        try (SingleChronicleQueue cq = ChronicleQueue.singleBuilder((File)tempDir).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).testBlockSize().build();){
            int j;
            int count = 2280;
            for (j = 0; j < 2280; ++j) {
                cq.tableStorePut((CharSequence)("=hello" + j), (long)j);
            }
            for (j = 0; j < 2280; ++j) {
                long l = cq.tableStoreGet((CharSequence)("=hello" + j));
                Assert.assertEquals((long)j, (long)l);
            }
        }
    }

    @Test
    public void testCanGrowBeyondInitialSize() {
        try (SingleChronicleQueue cq = ChronicleQueue.singleBuilder((File)DirectoryUtils.tempDir("canGrow")).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).testBlockSize().build();){
            for (int j = 0; j < 4000; ++j) {
                cq.tableStorePut((CharSequence)("=this_is_a_long_key_to_try_and_consume_space_quicker_" + j), (long)j);
            }
        }
    }
}

