/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.FileStore;
import java.util.Map;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.threads.DiskSpaceMonitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class DiskSpaceMonitoringIntegrationTest
extends QueueTestCommon {
    private Map<String, FileStore> monitoredPaths;

    DiskSpaceMonitoringIntegrationTest() {
    }

    @BeforeEach
    public void beforeEach() throws NoSuchFieldException, IllegalAccessException {
        Field fileStoreCacheMap = DiskSpaceMonitor.class.getDeclaredField("fileStoreCacheMap");
        fileStoreCacheMap.setAccessible(true);
        this.monitoredPaths = (Map)fileStoreCacheMap.get(DiskSpaceMonitor.INSTANCE);
    }

    private void assertMapped(File queuePath) {
        String path = queuePath.getAbsolutePath().toString();
        Assertions.assertTrue((boolean)this.monitoredPaths.containsKey(path), () -> "Expected that the following queue path should be monitored by the disk space monitor, but it was not. Path: " + path);
    }

    @Nested
    class EnsureThatPollIsCalledInDifferentScenarioTests {
        EnsureThatPollIsCalledInDifferentScenarioTests() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        void newQueueNoWrite() {
            File tmpDir = DiskSpaceMonitoringIntegrationTest.this.getTmpDir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(tmpDir).build();
                 ExcerptAppender appender = queue.createAppender();){
                DiskSpaceMonitoringIntegrationTest.this.assertMapped(tmpDir);
            }
            finally {
                IOTools.deleteDirWithFiles((File)tmpDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        void newQueueWithWrite() {
            File tmpDir = DiskSpaceMonitoringIntegrationTest.this.getTmpDir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(tmpDir).build();
                 ExcerptAppender appender = queue.createAppender();){
                appender.writeText((CharSequence)"Test");
                DiskSpaceMonitoringIntegrationTest.this.assertMapped(tmpDir);
            }
            finally {
                IOTools.deleteDirWithFiles((File)tmpDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        void newQueueJustTail() {
            File tmpDir = DiskSpaceMonitoringIntegrationTest.this.getTmpDir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(tmpDir).build();
                 ExcerptTailer tailer = queue.createTailer();){
                DiskSpaceMonitoringIntegrationTest.this.assertMapped(tmpDir);
            }
            finally {
                IOTools.deleteDirWithFiles((File)tmpDir);
            }
        }

        @Test
        void existingQueueNoWrite() {
            Throwable throwable;
            ExcerptAppender appender;
            File tmpDir = DiskSpaceMonitoringIntegrationTest.this.getTmpDir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(tmpDir).build();){
                appender = queue.createAppender();
                throwable = null;
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
            queue = SingleChronicleQueueBuilder.builder().path(tmpDir).build();
            var3_3 = null;
            try {
                appender = queue.createAppender();
                throwable = null;
                try {
                    DiskSpaceMonitoringIntegrationTest.this.assertMapped(tmpDir);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (appender != null) {
                        if (throwable != null) {
                            try {
                                appender.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            appender.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                var3_3 = throwable5;
                throw throwable5;
            }
            finally {
                if (queue != null) {
                    if (var3_3 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable6) {
                            var3_3.addSuppressed(throwable6);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }

        @Test
        void existingQueueWithWrite() {
            Throwable throwable;
            ExcerptAppender appender;
            File tmpDir = DiskSpaceMonitoringIntegrationTest.this.getTmpDir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(tmpDir).build();){
                appender = queue.createAppender();
                throwable = null;
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
            queue = SingleChronicleQueueBuilder.builder().path(tmpDir).build();
            var3_3 = null;
            try {
                appender = queue.createAppender();
                throwable = null;
                try {
                    appender.writeText((CharSequence)"Test");
                    DiskSpaceMonitoringIntegrationTest.this.assertMapped(tmpDir);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (appender != null) {
                        if (throwable != null) {
                            try {
                                appender.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            appender.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                var3_3 = throwable5;
                throw throwable5;
            }
            finally {
                if (queue != null) {
                    if (var3_3 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable6) {
                            var3_3.addSuppressed(throwable6);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
    }
}

