/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.util.StackSampler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChronicleQueueLatencyDistribution
extends QueueTestCommon {
    private static final boolean PRETOUCH = !Jvm.getBoolean((String)"no_pretouch");
    private static final boolean SAMPLING = Jvm.getBoolean((String)"sampling");
    private static final long SAMPLE_THRESHOLD_NS = Long.getLong("sampling_ns", 1000L);
    private static final int ITERATIONS = Integer.getInteger("iterations", 20000000);
    private static final int BLOCK_SIZE = Integer.getInteger("block_size", 0x8000000);
    private static final int WARMUP = 500000;
    @Nullable
    private final StackSampler sampler = SAMPLING ? new StackSampler() : null;

    public static void main(String[] args) throws Exception {
        assert (false) : "test runs slower with assertions on";
        new ChronicleQueueLatencyDistribution().run(args);
    }

    public void run(String[] args) throws Exception {
        File tmpDir = new File(this.getClass().getSimpleName() + "_" + System.currentTimeMillis());
        tmpDir.deleteOnExit();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder((File)tmpDir, (WireType)WireType.FIELDLESS_BINARY).blockSize(BLOCK_SIZE).build();){
            this.runTest((ChronicleQueue)queue, args.length > 0 ? Integer.parseInt(args[0]) : 1200000);
        }
    }

    protected void runTest(@NotNull ChronicleQueue queue, int throughput) throws InterruptedException {
        Histogram histogramCo = new Histogram();
        Histogram histogramIn = new Histogram();
        Histogram histogramWr = new Histogram();
        if (PRETOUCH) {
            Thread pretoucher = new Thread(() -> {
                try (ExcerptAppender appender = queue.createAppender();){
                    while (!Thread.currentThread().isInterrupted()) {
                        appender.pretouch();
                        Jvm.pause((long)500L);
                    }
                }
            });
            pretoucher.setName("pret");
            pretoucher.setDaemon(true);
            pretoucher.start();
        }
        String name = this.getClass().getName();
        Thread tailerThread = new Thread(() -> {
            AffinityLock lock = null;
            try (ExcerptTailer tailer = queue.createTailer();){
                if (Jvm.getBoolean((String)"enableTailerAffinity") || Jvm.getBoolean((String)"enableAffinity")) {
                    lock = Affinity.acquireLock();
                }
                int counter = 0;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        DocumentContext dc = tailer.readingDocument();
                        Throwable throwable = null;
                        try {
                            int count;
                            boolean found = dc.isPresent();
                            if (!found) continue;
                            if ((count = counter++) == 500000) {
                                histogramCo.reset();
                                histogramIn.reset();
                                histogramWr.reset();
                            }
                            Bytes bytes = dc.wire().bytes();
                            long startCo = bytes.readLong();
                            long startIn = bytes.readLong();
                            long now = System.nanoTime();
                            histogramCo.sample((double)(now - startCo));
                            histogramIn.sample((double)(now - startIn));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (dc == null) continue;
                            if (throwable != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            dc.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        });
        Thread appenderThread = new Thread(() -> {
            AffinityLock lock = null;
            try (ExcerptAppender appender = queue.createAppender();){
                if (Jvm.getBoolean((String)"enableAppenderAffinity") || Jvm.getBoolean((String)"enableAffinity")) {
                    lock = Affinity.acquireLock();
                }
                long next = System.nanoTime();
                long interval = 1000000000 / throughput;
                LinkedHashMap<String, Integer> stackCount = new LinkedHashMap<String, Integer>();
                BytesStore bytes24 = BytesStore.nativeStore((long)24L);
                for (int i = -500000; i < ITERATIONS; ++i) {
                    StackTraceElement[] stack;
                    long s0 = System.nanoTime();
                    if (s0 < next) {
                        while (System.nanoTime() < next) {
                        }
                        next = System.nanoTime();
                    }
                    if (SAMPLING) {
                        this.sampler.thread(Thread.currentThread());
                    }
                    long start = System.nanoTime();
                    try (@NotNull DocumentContext dc = appender.writingDocument(false);){
                        Bytes bytes2 = dc.wire().bytes();
                        bytes2.writeLong(next);
                        bytes2.writeLong(start);
                        bytes2.write(bytes24);
                    }
                    long time = System.nanoTime() - start;
                    histogramWr.sample((double)(start - next));
                    if (SAMPLING && time > SAMPLE_THRESHOLD_NS && i > 0 && (stack = this.sampler.getAndReset()) != null && !stack[0].getClassName().equals(name) && !stack[0].getClassName().equals("java.lang.Thread")) {
                        StringBuilder sb = new StringBuilder();
                        Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])stack);
                        stackCount.compute(sb.toString(), (k, v) -> v == null ? 1 : v + 1);
                    }
                    next += interval;
                }
                stackCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).sorted(Comparator.comparingInt(Map.Entry::getValue)).forEach(System.out::println);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        });
        tailerThread.setName("tail");
        tailerThread.start();
        appenderThread.setName("appd");
        appenderThread.start();
        appenderThread.join();
        Jvm.pause((long)500L);
        tailerThread.interrupt();
        tailerThread.join();
    }
}

