/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.fieldinfo;

import java.lang.reflect.Field;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.internal.fieldinfo.UnsafeFieldInfo;
import org.jetbrains.annotations.NotNull;

public final class DoubleFieldInfo
extends UnsafeFieldInfo {
    public DoubleFieldInfo(String name, Class<?> type, BracketType bracketType, @NotNull Field field) {
        super(name, type, bracketType, field);
    }

    @Override
    public double getDouble(Object object) {
        try {
            return UnsafeMemory.unsafeGetDouble(object, this.getOffset());
        }
        catch (NoSuchFieldException e) {
            Jvm.debug().on(DoubleFieldInfo.class, e);
            return Double.NaN;
        }
    }

    @Override
    public void set(Object object, double value) throws IllegalArgumentException {
        try {
            UnsafeMemory.unsafePutDouble(object, this.getOffset(), value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean isEqual(Object a, Object b) {
        return this.getDouble(a) == this.getDouble(b);
    }

    @Override
    public void copy(Object source, Object destination) {
        this.set(destination, this.getDouble(source));
    }
}

