/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ClassLocal;

public final class PackageNameUtil {
    private static final Function<Class<?>, String> PACKAGE_NAME_FUNCTION;

    private PackageNameUtil() {
    }

    public static String getPackageName(Class<?> clazz) {
        return PACKAGE_NAME_FUNCTION.apply(clazz);
    }

    static {
        Function<Class, String> packageNameFunction = null;
        if (Jvm.isJava9Plus()) {
            try {
                Method getPackageNameMethod = Class.class.getMethod("getPackageName", new Class[0]);
                MethodHandle methodHandle = MethodHandles.lookup().unreflect(getPackageNameMethod);
                packageNameFunction = clazz -> {
                    try {
                        return methodHandle.invokeExact((Class)clazz);
                    }
                    catch (Throwable e) {
                        throw Jvm.rethrow(e);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException getPackageNameMethod) {
                // empty catch block
            }
        }
        if (packageNameFunction == null) {
            ClassLocal<String> packageNameCache = ClassLocal.withInitial(clazz -> {
                String className = clazz.getName();
                int lastDotIndex = className.lastIndexOf(46);
                return lastDotIndex < 0 ? "" : className.substring(0, lastDotIndex);
            });
            packageNameFunction = packageNameCache::get;
        }
        PACKAGE_NAME_FUNCTION = packageNameFunction;
    }
}

